/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;

public enum OverlayRenderType {
    OUTLINE(VertexFormat.Mode.DEBUG_LINES, 786432, DefaultVertexFormat.POSITION_COLOR, false, false),
    QUAD(VertexFormat.Mode.QUADS, 786432, DefaultVertexFormat.POSITION_COLOR, false, true);

    private final VertexFormat.Mode drawMode;
    private final VertexFormat vertexFormat;
    private final int bufferSize;
    private final boolean hasCrumbling;
    private final boolean translucent;

    private OverlayRenderType(VertexFormat.Mode drawMode, int bufferSize, VertexFormat format, boolean crumbling, boolean translucent) {
        this.drawMode = drawMode;
        this.bufferSize = Math.max(bufferSize, format.getVertexSize());
        this.vertexFormat = format;
        this.hasCrumbling = crumbling;
        this.translucent = translucent;
    }

    public VertexFormat.Mode getDrawMode() {
        return this.drawMode;
    }

    public int getExpectedBufferSize() {
        return this.bufferSize;
    }

    public VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    public boolean hasCrumbling() {
        return this.hasCrumbling;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }
}

