/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;

public class BuiltBufferCache
implements AutoCloseable {
    private final ConcurrentHashMap<RenderType, MeshData> layerBuffers = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, MeshData> overlayBuffers = new ConcurrentHashMap();

    protected BuiltBufferCache() {
    }

    protected boolean hasBuiltBufferByLayer(RenderType layer) {
        return this.layerBuffers.containsKey(layer);
    }

    protected boolean hasBuiltBufferByType(OverlayRenderType type) {
        return this.overlayBuffers.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBuiltBufferByLayer(RenderType layer, @Nonnull MeshData newBuffer) {
        if (this.hasBuiltBufferByLayer(layer)) {
            this.layerBuffers.get(layer).close();
        }
        ConcurrentHashMap<RenderType, MeshData> concurrentHashMap = this.layerBuffers;
        synchronized (concurrentHashMap) {
            this.layerBuffers.put(layer, newBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBuiltBufferByType(OverlayRenderType type, @Nonnull MeshData newBuffer) {
        if (this.hasBuiltBufferByType(type)) {
            this.overlayBuffers.get((Object)type).close();
        }
        ConcurrentHashMap<OverlayRenderType, MeshData> concurrentHashMap = this.overlayBuffers;
        synchronized (concurrentHashMap) {
            this.overlayBuffers.put(type, newBuffer);
        }
    }

    @Nullable
    protected MeshData getBuiltBufferByLayer(RenderType layer) {
        return this.layerBuffers.get(layer);
    }

    @Nullable
    protected MeshData getBuiltBufferByType(OverlayRenderType type) {
        return this.overlayBuffers.get((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAll() {
        ArrayList<MeshData> builtBuffers;
        ConcurrentHashMap<Object, MeshData> concurrentHashMap = this.layerBuffers;
        synchronized (concurrentHashMap) {
            builtBuffers = new ArrayList<MeshData>(this.layerBuffers.values());
            this.layerBuffers.clear();
        }
        concurrentHashMap = this.overlayBuffers;
        synchronized (concurrentHashMap) {
            builtBuffers.addAll(this.overlayBuffers.values());
            this.overlayBuffers.clear();
        }
        try {
            builtBuffers.forEach(MeshData::close);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        this.closeAll();
    }
}

