/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin.item;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.util.PlacementHandler;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class}, priority=980)
public abstract class MixinBlockItem
extends Item {
    private MixinBlockItem(Item.Properties builder) {
        super(builder);
    }

    @Shadow
    protected abstract BlockState getPlacementState(BlockPlaceContext var1);

    @Shadow
    protected abstract boolean canPlace(BlockPlaceContext var1, BlockState var2);

    @Shadow
    public abstract Block getBlock();

    @Inject(method={"getPlacementState(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void litematica_modifyPlacementState(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> cir) {
        BlockState stateOrig;
        if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Configs.Generic.EASY_PLACE_SP_HANDLING.getBooleanValue() && (stateOrig = this.getBlock().getStateForPlacement(ctx)) != null && this.canPlace(ctx, stateOrig)) {
            PlacementHandler.UseContext context = PlacementHandler.UseContext.from(ctx, ctx.getHand());
            cir.setReturnValue((Object)PlacementHandler.applyPlacementProtocolToPlacementState(stateOrig, context));
        }
    }
}

