/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.fastipping.mixins;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import me.fallenbreath.fastipping.impl.InetAddressPatcher;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddressResolver;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={ServerAddressResolver.class}, priority=200)
public interface AddressResolverMixin {
    @Overwrite
    public static Optional<ResolvedServerAddress> lambda$static$0(ServerAddress address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address.getHost());
            inetAddress = InetAddressPatcher.patch(address.getHost(), inetAddress);
            return Optional.of(ResolvedServerAddress.from((InetSocketAddress)new InetSocketAddress(inetAddress, address.getPort())));
        }
        catch (UnknownHostException var2) {
            ServerAddressResolver.LOGGER.debug("Couldn't resolve server {} address", (Object)address.getHost(), (Object)var2);
            return Optional.empty();
        }
    }
}

