/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.escalated.advancements.WalkwayTravelTracker;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayMovementHandler {
    public static boolean canBeTransported(Entity entity) {
        Player player;
        return entity.isAlive() && (!(entity instanceof Player) || !(player = (Player)entity).isShiftKeyDown());
    }

    public static void transportEntity(WalkwayBlockEntity walkwayBE, Entity entity, TransportedEntityInfo info) {
        LivingEntity livingEntity;
        boolean movingUp;
        boolean movingDown;
        Vec3 movement;
        float movementSpeed;
        boolean isPlayer;
        Level level;
        block24: {
            Vec3 centering;
            block23: {
                double diffCenter;
                boolean betweenWalkways;
                BlockPos pos = info.lastCollidedPos;
                level = walkwayBE.getLevel();
                BlockEntity otherBE = level.getBlockEntity(pos);
                BlockPos belowPos = BlockPos.containing((Position)entity.position().subtract(0.0, 0.05, 0.0));
                BlockEntity beBelowPassenger = level.getBlockEntity(belowPos);
                BlockState blockState = info.lastCollidedState;
                WalkwayBlock walkwayBlock = (WalkwayBlock)blockState.getBlock();
                Direction movementFacing = Direction.fromAxisAndDirection((Direction.Axis)walkwayBlock.getFacing(blockState).getAxis(), (Direction.AxisDirection)(walkwayBE.getSpeed() < 0.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
                boolean collidedWithWalkways = otherBE instanceof WalkwayBlockEntity;
                boolean bl = betweenWalkways = beBelowPassenger instanceof WalkwayBlockEntity && beBelowPassenger != otherBE;
                if (!collidedWithWalkways || betweenWalkways) {
                    return;
                }
                if (Math.abs(walkwayBE.getSpeed()) < 1.0f || !walkwayBlock.movesEntities(blockState)) {
                    return;
                }
                if (entity.getY() + 0.25 < (double)pos.getY()) {
                    return;
                }
                isPlayer = entity instanceof Player;
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    if (!isPlayer) {
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 10, 1, false, false));
                    }
                }
                Direction walkwayFacing = walkwayBlock.getFacing(blockState);
                WalkwaySlope slope = walkwayBlock.getWalkwaySlope(blockState);
                Direction.Axis axis = walkwayFacing.getAxis();
                movementSpeed = walkwayBE.getWalkwayMovementSpeed();
                Direction movementDirection = Direction.get((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
                Vec3i centeringDirection = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)walkwayFacing.getClockWise().getAxis()).getNormal();
                movement = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementSpeed);
                double d = diffCenter = axis == Direction.Axis.Z ? (double)((float)pos.getX() + 0.5f) - entity.getX() : (double)((float)pos.getZ() + 0.5f) - entity.getZ();
                if (Math.abs(diffCenter) > 0.75) {
                    return;
                }
                float top = 0.96875f;
                boolean onSlope = slope == WalkwaySlope.MIDDLE || slope == WalkwaySlope.TOP && entity.getY() - (double)pos.getY() < (double)top || slope == WalkwaySlope.BOTTOM && entity.getY() - (double)pos.getY() > (double)top;
                movingDown = onSlope && movementFacing != walkwayFacing;
                boolean bl2 = movingUp = onSlope && movementFacing == walkwayFacing;
                if (walkwayFacing.getAxis() == Direction.Axis.Z) {
                    boolean b = movingDown;
                    movingDown = movingUp;
                    movingUp = b;
                }
                if (movingUp) {
                    movement = movement.add(0.0, Math.abs(axis.choose(movement.x, movement.y, movement.z)), 0.0);
                }
                if (movingDown) {
                    movement = movement.add(0.0, -Math.abs(axis.choose(movement.x, movement.y, movement.z)), 0.0);
                }
                centering = Vec3.atLowerCornerOf((Vec3i)centeringDirection).scale(diffCenter * (double)Math.min(Math.abs(movementSpeed), 0.1f) * 4.0);
                if (!(entity instanceof LivingEntity)) break block23;
                LivingEntity living = (LivingEntity)entity;
                if (living.zza != 0.0f || living.xxa != 0.0f) break block24;
            }
            movement = movement.add(centering);
        }
        float step = entity.maxUpStep();
        if (!isPlayer && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            step = (float)livingEntity.getAttributeBaseValue(Attributes.STEP_HEIGHT);
            livingEntity.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
        }
        if (Math.abs(movementSpeed) < 0.5f) {
            Vec3 checkDistance = movement.normalize().scale(0.5);
            AABB bb = entity.getBoundingBox();
            AABB checkBB = new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
            checkBB = checkBB.move(checkDistance).inflate(-Math.abs(checkDistance.x), -Math.abs(checkDistance.y), -Math.abs(checkDistance.z));
            List list = level.getEntities(entity, checkBB);
            list.removeIf(e -> WalkwayMovementHandler.shouldIgnoreBlocking(entity, e));
            if (!list.isEmpty()) {
                entity.setDeltaMovement(0.0, 0.0, 0.0);
                --info.ticksSinceLastCollision;
                return;
            }
        }
        entity.fallDistance = 0.0f;
        if (movingUp) {
            Vec3 prevPos = entity.position();
            entity.move(MoverType.SELF, movement);
            if (entity.horizontalCollision) {
                entity.setPos(prevPos);
                entity.move(MoverType.SELF, new Vec3(0.0, movement.y * 0.1, 0.0));
                entity.move(MoverType.SELF, movement);
            }
        } else if (movingDown) {
            entity.move(MoverType.SELF, movement.multiply(1.0, 0.0, 1.0));
            entity.move(MoverType.SELF, movement.multiply(0.0, 1.0, 0.0));
        } else {
            entity.move(MoverType.SELF, movement);
        }
        entity.setOnGround(true);
        if (isPlayer && !entity.level().isClientSide) {
            WalkwayTravelTracker.trackPlayerOnWalkway((Player)entity, 300);
        }
        if (!isPlayer && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.getAttribute(Attributes.STEP_HEIGHT).setBaseValue((double)step);
        }
    }

    public static boolean shouldIgnoreBlocking(Entity me, Entity other) {
        if (other instanceof HangingEntity) {
            return true;
        }
        if (other.getPistonPushReaction() == PushReaction.IGNORE) {
            return true;
        }
        return WalkwayMovementHandler.isRidingOrBeingRiddenBy(me, other);
    }

    public static boolean isRidingOrBeingRiddenBy(Entity me, Entity other) {
        for (Entity entity : me.getPassengers()) {
            if (entity.equals((Object)other)) {
                return true;
            }
            if (!WalkwayMovementHandler.isRidingOrBeingRiddenBy(entity, other)) continue;
            return true;
        }
        return false;
    }

    public static class TransportedEntityInfo {
        int ticksSinceLastCollision;
        BlockPos lastCollidedPos;
        BlockState lastCollidedState;

        public TransportedEntityInfo(BlockPos collision, BlockState walkway) {
            this.refresh(collision, walkway);
        }

        public void refresh(BlockPos collision, BlockState walkway) {
            this.ticksSinceLastCollision = 0;
            this.lastCollidedPos = new BlockPos((Vec3i)collision).immutable();
            this.lastCollidedState = walkway;
        }

        public TransportedEntityInfo tick() {
            ++this.ticksSinceLastCollision;
            return this;
        }

        public int getTicksSinceLastCollision() {
            return this.ticksSinceLastCollision;
        }
    }
}

