/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotPredicate;

public class EquipCurioTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final EquipCurioTrigger INSTANCE = new EquipCurioTrigger();

    @Nonnull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, ItemStack stack) {
        LootParams lootparams = new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)serverPlayer.blockPosition().getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).withParameter(LootContextParams.BLOCK_STATE, (Object)serverPlayer.getBlockStateOn()).withParameter(LootContextParams.TOOL, (Object)stack).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext lootcontext = new LootContext.Builder(lootparams).create(Optional.empty());
        this.trigger(serverPlayer, instance -> instance.matches(null, stack, lootcontext));
    }

    public void trigger(SlotContext slotContext, ServerPlayer serverPlayer, ItemStack stack) {
        LootParams lootparams = new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)serverPlayer.blockPosition().getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).withParameter(LootContextParams.BLOCK_STATE, (Object)serverPlayer.getBlockStateOn()).withParameter(LootContextParams.TOOL, (Object)stack).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext lootcontext = new LootContext.Builder(lootparams).create(Optional.empty());
        this.trigger(serverPlayer, instance -> instance.matches(slotContext, stack, lootcontext));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<LocationPredicate> location, Optional<SlotPredicate> slot) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location), (App)SlotPredicate.CODEC.optionalFieldOf("curios:slot").forGetter(TriggerInstance::slot)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(SlotContext slotContext, ItemStack stack, LootContext lootContext) {
            Vec3 vec3 = (Vec3)lootContext.getParam(LootContextParams.ORIGIN);
            if (slotContext != null && this.slot().map(slotPredicate -> !slotPredicate.matches(slotContext)).orElse(false).booleanValue()) {
                return false;
            }
            if (this.location.isEmpty() || this.location.get().matches(lootContext.getLevel(), vec3.x, vec3.y, vec3.z)) {
                return this.item.isEmpty() || this.item.get().test(stack);
            }
            return false;
        }
    }
}

