/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowTimeAndDateSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class PlatformDisplayTableSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
ITrainNameWidthSetting,
IPlatformWidthSetting,
IShowArrivalSetting,
IShowLineColorSetting,
IShowTimeAndDateSetting {
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected byte trainNameWidth = (byte)16;
    protected byte platformWidth = (byte)-1;
    protected boolean showArrival = true;
    protected boolean showLineColor = false;
    protected boolean showTimeAndDate = true;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.contains("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.getByte("TimeDisplay"));
        }
        if (nbt.contains("TrainNameWidth")) {
            this.trainNameWidth = nbt.getByte("TrainNameWidth");
        }
        if (nbt.contains("PlatformWidth")) {
            this.platformWidth = nbt.getByte("PlatformWidth");
        }
        if (nbt.contains("ShowArrival")) {
            this.showArrival = nbt.getBoolean("ShowArrival");
        }
        if (nbt.contains("ShowLineColor")) {
            this.showLineColor = nbt.getBoolean("ShowLineColor");
        }
        if (nbt.contains("ShowTime")) {
            this.showTimeAndDate = nbt.getBoolean("ShowTime");
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.putByte("TimeDisplay", this.timeDisplay.getId());
        nbt.putByte("TrainNameWidth", this.trainNameWidth);
        nbt.putByte("PlatformWidth", this.platformWidth);
        nbt.putBoolean("ShowArrival", this.showArrival);
        nbt.putBoolean("ShowLineColor", this.showLineColor);
        nbt.putBoolean("ShowTime", this.showTimeAndDate);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildTrainNameGui(context, true, false);
        this.buildPlatformWidthGui(context, true);
        this.buildShowArrivalGui(context);
        this.buildShowLineColorGui(context);
        this.buildShowTimeAndDateGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyTrainNameSetting(oldSettings);
        this.copyPlatformWidthSetting(oldSettings);
        this.copyShowArrivalSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
        this.copyShowTimeAndDateSetting(oldSettings);
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    @Override
    public void setPlatformWidth(byte b) {
        this.platformWidth = b;
    }

    @Override
    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    @Override
    public void setTrainNameWidth(byte b) {
        this.trainNameWidth = b;
    }

    @Override
    public boolean showArrival() {
        return this.showArrival;
    }

    @Override
    public void setShowArrival(boolean b) {
        this.showArrival = b;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }

    @Override
    public void setShowTimeAndDate(boolean showTimeAndDate) {
        this.showTimeAndDate = showTimeAndDate;
    }

    @Override
    public boolean showTimeAndDate() {
        return this.showTimeAndDate;
    }
}

