/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.index;

import com.mrh0.createaddition.CreateAddition;
import com.simibubi.create.foundation.damageTypes.DamageTypeBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class CADamageTypes {
    public static final ResourceKey<DamageType> BARBED_WIRE_KEY = CADamageTypes.key("barbed_wire");
    public static final ResourceKey<DamageType> TESLA_COIL_KEY = CADamageTypes.key("tesla_coil");

    private static ResourceKey<DamageType> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)CreateAddition.asResource(name));
    }

    public static void bootstrap(BootstrapContext<DamageType> ctx) {
        new DamageTypeBuilder(BARBED_WIRE_KEY).exhaustion(0.0f).scaling(DamageScaling.ALWAYS).build();
        new DamageTypeBuilder(TESLA_COIL_KEY).exhaustion(0.0f).scaling(DamageScaling.ALWAYS).build();
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        return new DamageSource((Holder)registry.getHolderOrThrow(key));
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, Entity entity) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        return new DamageSource((Holder)registry.getHolderOrThrow(key), entity);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level, Entity causingEntity, Entity directEntity) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        return new DamageSource((Holder)registry.getHolderOrThrow(key), causingEntity, directEntity);
    }

    public static DamageSource barbedWire(Level level) {
        return CADamageTypes.source(BARBED_WIRE_KEY, (LevelReader)level);
    }

    public static DamageSource teslaCoil(Level level) {
        return CADamageTypes.source(TESLA_COIL_KEY, (LevelReader)level);
    }

    public static void register() {
    }
}

