/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.SmallLightConnectorBlockEntity;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.blocks.connector.base.ConnectorVariant;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class SmallLightConnectorBlock
extends AbstractConnectorBlock<SmallLightConnectorBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShaper CONNECTOR_SHAPE = CAShapes.shape(6.0, 0.0, 6.0, 10.0, 5.0, 10.0).add(5.0, 4.0, 5.0, 11.0, 10.0, 11.0).forDirectional();

    public SmallLightConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)super.getStateForPlacement(c).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODE, NodeRotation.ROTATION, VARIANT, POWERED});
    }

    public Class<SmallLightConnectorBlockEntity> getBlockEntityClass() {
        return SmallLightConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends SmallLightConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.SMALL_LIGHT_CONNECTOR.get();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CABlockEntities.SMALL_LIGHT_CONNECTOR.create(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CONNECTOR_SHAPE.get(((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public static void makeBlockState(DataGenContext<Block, SmallLightConnectorBlock> ctx, RegistrateBlockstateProvider provider) {
        BlockModelProvider models = provider.models();
        String basePath = "block/connector/";
        String basePathSmall = basePath + "small_light/";
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)ctx.get());
        ModelFile.ExistingModelFile noneModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathSmall + "none")));
        ModelFile.ExistingModelFile pushModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathSmall + "push")));
        ModelFile.ExistingModelFile pullModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathSmall + "pull")));
        ModelFile.ExistingModelFile noneOffModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathSmall + "none_off")));
        ModelFile.ExistingModelFile pushOffModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathSmall + "push_off")));
        ModelFile.ExistingModelFile pullOffModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathSmall + "pull_off")));
        ModelFile.ExistingModelFile girderBaseModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePath + "girder_base")));
        for (Direction direction : Direction.values()) {
            int horizontalAngle = direction == Direction.UP ? 180 : (direction == Direction.DOWN ? 0 : 90);
            int verticalAngle = ((int)direction.toYRot() + (direction.getAxis().isVertical() ? 180 : 0)) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)noneModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.None}).condition((Property)POWERED, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile((ModelFile)pushModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.Push}).condition((Property)POWERED, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile((ModelFile)pullModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.Pull}).condition((Property)POWERED, (Comparable[])new Boolean[]{Boolean.TRUE}).end().part().modelFile((ModelFile)noneOffModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.None}).condition((Property)POWERED, (Comparable[])new Boolean[]{Boolean.FALSE}).end().part().modelFile((ModelFile)pullOffModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.Pull}).condition((Property)POWERED, (Comparable[])new Boolean[]{Boolean.FALSE}).end().part().modelFile((ModelFile)pushOffModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.Push}).condition((Property)POWERED, (Comparable[])new Boolean[]{Boolean.FALSE}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)girderBaseModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)VARIANT, (Comparable[])new ConnectorVariant[]{ConnectorVariant.Girder}).end();
        }
    }
}

