/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_extruder.components.extruder.recipe;

import com.oierbravo.create_mechanical_extruder.components.extruder.AbstractExtruderBlockEntity;
import com.oierbravo.create_mechanical_extruder.components.extruder.recipe.ExtrudingRecipeSerializer;
import com.oierbravo.create_mechanical_extruder.components.extruder.recipe.requirements.AdvancedExtruderRecipeRequirement;
import com.oierbravo.create_mechanical_extruder.components.extruder.recipe.requirements.BonksRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipeParams;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.createmod.catnip.data.Couple;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ExtrudingRecipe
extends AbstractMechanicalRecipe<RecipeInput, ExtrudingRecipeParams> {
    public static final BlockPredicate ANY_BLOCK = new BlockPredicate(Optional.empty(), Optional.empty(), Optional.empty());
    public static final BlockPredicate WATER_BLOCK = BlockPredicate.Builder.block().of(new Block[]{Blocks.WATER}).build();
    private Couple<BlockPredicate> blockPredicateIngredients;
    private BlockPredicate catalyst;
    private ProcessingOutput result;
    private int requiredBonks;
    private boolean isAdvanced;
    private Couple<Boolean> consumeBlocks;

    public ArrayList<IRecipeRequirement> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public ExtrudingRecipe(ExtrudingRecipeParams params) {
        super((AbstractMechanicalRecipeParams)params);
        this.result = params.result;
        this.blockPredicateIngredients = params.blockPredicateIngredients;
        this.catalyst = params.catalyst;
        this.requiredBonks = params.requiredBonks;
        this.isAdvanced = params.isAdvanced;
        this.consumeBlocks = params.consumeBlocks;
        this.recipeRequirements.addAll(params.recipeRequirements);
    }

    private boolean matchIngredient(BlockPredicate blockIngredient, BlockInWorld blockInWorld) {
        if (blockInWorld.getState().hasProperty((Property)BlockStateProperties.WATERLOGGED) && blockIngredient.blocks().isPresent()) {
            boolean waterLogged = (Boolean)blockInWorld.getState().getValue((Property)BlockStateProperties.WATERLOGGED);
            boolean isWaterIngredient = ((HolderSet)blockIngredient.blocks().get()).get(0).is(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"water"));
            if (waterLogged && isWaterIngredient) {
                return true;
            }
        }
        return blockIngredient.matches(blockInWorld);
    }

    public <EXB extends AbstractExtruderBlockEntity> boolean matchIngredients(EXB extruderBlockEntity, Couple<BlockPredicate> blockIngredients) {
        Couple matchedIngredients = Couple.create((Object)false, (Object)false);
        Couple<BlockInWorld> sideBlocks = extruderBlockEntity.getSideBlocks();
        if (((BlockPredicate)blockIngredients.getFirst()).equals(blockIngredients.getSecond())) {
            return this.matchIngredient((BlockPredicate)blockIngredients.getFirst(), (BlockInWorld)sideBlocks.getFirst()) && this.matchIngredient((BlockPredicate)blockIngredients.getSecond(), (BlockInWorld)sideBlocks.getSecond());
        }
        BlockInWorld blockInWorld = (BlockInWorld)sideBlocks.getFirst();
        ArrayList<BlockPredicate> notMatchedIngredients = new ArrayList<BlockPredicate>(List.of());
        for (BlockPredicate blockIngredient : blockIngredients) {
            if (this.matchIngredient(blockIngredient, blockInWorld) && !((Boolean)matchedIngredients.getFirst()).booleanValue()) {
                matchedIngredients.setFirst((Object)true);
                continue;
            }
            notMatchedIngredients.add(blockIngredient);
        }
        blockInWorld = (BlockInWorld)sideBlocks.getSecond();
        for (BlockPredicate blockIngredient : notMatchedIngredients) {
            if (!this.matchIngredient(blockIngredient, blockInWorld) || ((Boolean)matchedIngredients.getSecond()).booleanValue()) continue;
            matchedIngredients.setSecond((Object)true);
        }
        return matchedIngredients.both(aBoolean -> aBoolean.equals(true));
    }

    public <EXB extends AbstractExtruderBlockEntity> boolean match(EXB extruderBlockEntity) {
        if (Objects.requireNonNull(extruderBlockEntity.getLevel()).isClientSide) {
            return false;
        }
        FilteringBehaviour filter = extruderBlockEntity.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(this.getResultItemStack());
        if (!this.matchIngredients(extruderBlockEntity, this.getBlockPredicateIngredients())) {
            return false;
        }
        if (this.catalyst.blocks().isPresent() && !this.catalyst.matches(extruderBlockEntity.getCatalystBlock())) {
            return false;
        }
        return filterTest;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.rollOutput();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.rollOutput();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ExtrudingRecipeSerializer.INSTANCE;
    }

    public ItemStack rollOutput() {
        return this.result.rollOutput();
    }

    public ItemStack getResultItemStack() {
        return this.result.getStack();
    }

    public ProcessingOutput getResult() {
        return this.result;
    }

    public BlockPredicate getCatalyst() {
        return this.catalyst;
    }

    public int getRequiredBonks() {
        return this.requiredBonks;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean notAdvanced() {
        return !this.isAdvanced;
    }

    public Couple<Boolean> getConsumeBlocks() {
        return this.consumeBlocks;
    }

    public List<BlockPredicate> getConsumeBlocksList() {
        ArrayList<BlockPredicate> list = new ArrayList<BlockPredicate>();
        if (((Boolean)this.consumeBlocks.getFirst()).booleanValue()) {
            list.add((BlockPredicate)this.blockPredicateIngredients.getFirst());
        }
        if (((Boolean)this.consumeBlocks.getSecond()).booleanValue()) {
            list.add((BlockPredicate)this.blockPredicateIngredients.getSecond());
        }
        return list;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static <T> boolean hasCatalyst(RecipeHolder<ExtrudingRecipe> extrudingRecipeRecipeHolder) {
        return ((ExtrudingRecipe)extrudingRecipeRecipeHolder.value()).catalyst.blocks().isPresent();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<IRecipeRequirement> getJeiRecipeRequirements() {
        ArrayList<Record> extraRequirements = new ArrayList<Record>();
        if (this.isAdvanced()) {
            extraRequirements.add(new AdvancedExtruderRecipeRequirement(true));
        }
        if (this.requiredBonks > 1) {
            extraRequirements.add(new BonksRecipeRequirement(this.requiredBonks));
        }
        return Stream.concat(extraRequirements.stream(), super.getJeiRecipeRequirements().stream()).toList();
    }

    public Couple<BlockPredicate> getBlockPredicateIngredients() {
        return this.blockPredicateIngredients;
    }

    public static class ExtrudingRecipeParams
    extends AbstractMechanicalRecipeParams {
        protected Couple<BlockPredicate> blockPredicateIngredients = Couple.create((Object)ANY_BLOCK, (Object)ANY_BLOCK);
        protected ProcessingOutput result = ProcessingOutput.EMPTY;
        protected BlockPredicate catalyst = BlockPredicate.Builder.block().build();
        protected int requiredBonks = 1;
        protected boolean isAdvanced = false;
        protected Couple<Boolean> consumeBlocks = Couple.create((Object)false, (Object)false);
        public ArrayList<IRecipeRequirement> recipeRequirements = new ArrayList();

        protected ExtrudingRecipeParams(ResourceLocation id) {
        }
    }

    public static class Type
    implements RecipeType<ExtrudingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final RecipeType<ExtrudingRecipe> RECIPE_TYPE = new Type();
        public static final String ID = "extruding";

        private Type() {
        }
    }
}

