/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.util;

import com.leclowndu93150.corpsecurioscompat.data.CuriosSlotDataComponent;
import com.leclowndu93150.corpsecurioscompat.duck.ICuriosAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DelayedCurioHandler {
    private static final Map<UUID, List<ItemStack>> pendingItems = new HashMap<UUID, List<ItemStack>>();
    private static final Map<UUID, Long> scheduledTimes = new HashMap<UUID, Long>();

    public static void scheduleCurioRestoration(Player player, List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        UUID playerId = player.getUUID();
        pendingItems.put(playerId, new ArrayList<ItemStack>(items));
        long currentTime = System.currentTimeMillis();
        long executeTime = currentTime + 50L;
        scheduledTimes.put(playerId, executeTime);
    }

    public static void tickForPlayer(Player player) {
        UUID playerId = player.getUUID();
        Long scheduledTime = scheduledTimes.get(playerId);
        if (scheduledTime == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= scheduledTime) {
            DelayedCurioHandler.processPendingItems(player);
            scheduledTimes.remove(playerId);
        }
    }

    private static void processPendingItems(Player player) {
        UUID playerId = player.getUUID();
        List<ItemStack> items = pendingItems.remove(playerId);
        if (items == null || items.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            Map curios = handler.getCurios();
            for (ICurioStacksHandler stacksHandler : curios.values()) {
                if (!(stacksHandler instanceof ICuriosAccessor)) continue;
                ICuriosAccessor accessor = (ICuriosAccessor)stacksHandler;
                accessor.corpsecurioscompat$forceSlotRebuild();
            }
            for (ItemStack stack : items) {
                if (DelayedCurioHandler.tryEquipCurio(stack, player, curios) || player.getInventory().add(stack)) continue;
                player.drop(stack, false);
            }
        });
    }

    private static boolean tryEquipCurio(ItemStack stack, Player player, Map<String, ICurioStacksHandler> curios) {
        ItemStack existingStack;
        IDynamicStackHandler targetStacks;
        int availableSlots;
        if (stack.isEmpty()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = (CuriosSlotDataComponent.CurioSlotData)stack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
        if (slotData == null) {
            return false;
        }
        String slotType = slotData.slotType();
        int slotIndex = slotData.slotIndex();
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0 && slotIndex < (availableSlots = (targetStacks = slotData.isCosmetic() ? handler.getCosmeticStacks() : handler.getStacks()).getSlots()) && (existingStack = targetStacks.getStackInSlot(slotIndex)).isEmpty()) {
            ItemStack cleanStack = stack.copy();
            cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
            targetStacks.setStackInSlot(slotIndex, cleanStack);
            return true;
        }
        return false;
    }

    public static void cleanupPlayer(Player player) {
        UUID playerId = player.getUUID();
        List<ItemStack> items = pendingItems.remove(playerId);
        scheduledTimes.remove(playerId);
        if (items != null && !items.isEmpty()) {
            for (ItemStack stack : items) {
                if (stack.isEmpty()) continue;
                ItemStack cleanStack = stack.copy();
                cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                if (player.getInventory().add(cleanStack)) continue;
                player.drop(cleanStack, false);
            }
        }
    }
}

