/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.mixin;

import com.leclowndu93150.corpsecurioscompat.Config;
import com.leclowndu93150.corpsecurioscompat.data.CuriosSlotDataComponent;
import com.leclowndu93150.corpsecurioscompat.util.CuriosSlotDetector;
import com.leclowndu93150.corpsecurioscompat.util.DelayedCurioHandler;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mixin(value={CorpseInventoryContainer.class, CorpseAdditionalContainer.class})
public abstract class CorpseContainerMixin {
    private Player cachedPlayer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history, CallbackInfo ci) {
        if (playerInventory != null) {
            this.cachedPlayer = playerInventory.player;
        }
    }

    @Inject(method={"transferItems"}, at={@At(value="HEAD")}, remap=false)
    private void transferItemsToCurios(CallbackInfo ci) {
        ItemStack stack;
        int i;
        CorpseContainerMixin container = this;
        if (this.cachedPlayer == null || !this.cachedPlayer.isAlive()) {
            return;
        }
        if (!((CorpseContainerBase)container).isEditable()) {
            return;
        }
        Optional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)this.cachedPlayer);
        if (curiosOpt.isEmpty()) {
            return;
        }
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)curiosOpt.get();
        Map curios = curiosHandler.getCurios();
        ArrayList<ItemStack> curioItems = new ArrayList<ItemStack>();
        ArrayList<Consumer<ItemStack>> clearActions = new ArrayList<Consumer<ItemStack>>();
        if (container instanceof CorpseInventoryContainer) {
            CorpseInventoryContainer corpseContainer = (CorpseInventoryContainer)container;
            for (i = 0; i < corpseContainer.slots.size() && i < corpseContainer.getInventorySize(); ++i) {
                ItemStack stack2;
                slot = corpseContainer.getSlot(i);
                if (slot == null || (stack2 = slot.getItem()).isEmpty() || !this.corpse_Curios_Compat$shouldTransferCurio(stack2)) continue;
                curioItems.add(stack2.copy());
                slotIndex = i;
                clearActions.add(s -> corpseContainer.getSlot(slotIndex).set(ItemStack.EMPTY));
            }
            for (i = 0; i < corpseContainer.getCorpse().getDeath().getAdditionalItems().size(); ++i) {
                ItemStack stack3 = (ItemStack)corpseContainer.getCorpse().getDeath().getAdditionalItems().get(i);
                if (stack3.isEmpty() || !this.corpse_Curios_Compat$shouldTransferCurio(stack3)) continue;
                curioItems.add(stack3.copy());
                int index = i;
                clearActions.add(s -> corpseContainer.getCorpse().getDeath().getAdditionalItems().set(index, (Object)ItemStack.EMPTY));
            }
        } else if (container instanceof CorpseAdditionalContainer) {
            CorpseAdditionalContainer additionalContainer = (CorpseAdditionalContainer)container;
            for (i = 0; i < additionalContainer.getInventorySize(); ++i) {
                ItemStack stack4;
                slot = additionalContainer.getSlot(i);
                if (slot == null || (stack4 = slot.getItem()).isEmpty() || !this.corpse_Curios_Compat$shouldTransferCurio(stack4)) continue;
                curioItems.add(stack4.copy());
                slotIndex = i;
                clearActions.add(s -> additionalContainer.getSlot(slotIndex).set(ItemStack.EMPTY));
            }
        }
        ArrayList<ItemStack> priorityItems = new ArrayList<ItemStack>();
        ArrayList<Consumer> priorityClearActions = new ArrayList<Consumer>();
        ArrayList<ItemStack> regularItems = new ArrayList<ItemStack>();
        ArrayList<Consumer> regularClearActions = new ArrayList<Consumer>();
        for (int i2 = 0; i2 < curioItems.size(); ++i2) {
            ItemStack stack5 = (ItemStack)curioItems.get(i2);
            CuriosSlotDataComponent.CurioSlotData slotData = (CuriosSlotDataComponent.CurioSlotData)stack5.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
            if (slotData != null && CuriosSlotDetector.doesItemAddSlots(stack5, this.cachedPlayer, slotData.slotType())) {
                priorityItems.add(stack5);
                priorityClearActions.add((Consumer)clearActions.get(i2));
                continue;
            }
            regularItems.add(stack5);
            regularClearActions.add((Consumer)clearActions.get(i2));
        }
        long currentTime = System.currentTimeMillis();
        for (i = 0; i < priorityItems.size(); ++i) {
            stack = (ItemStack)priorityItems.get(i);
            if (!this.corpse_Curios_Compat$tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
            ((Consumer)priorityClearActions.get(i)).accept(stack);
        }
        if (!regularItems.isEmpty() && !priorityItems.isEmpty()) {
            for (i = 0; i < regularItems.size(); ++i) {
                ItemStack itemCopy = ((ItemStack)regularItems.get(i)).copy();
                ((Consumer)regularClearActions.get(i)).accept((ItemStack)regularItems.get(i));
                regularItems.set(i, itemCopy);
            }
            DelayedCurioHandler.scheduleCurioRestoration(this.cachedPlayer, regularItems);
        } else {
            for (i = 0; i < regularItems.size(); ++i) {
                stack = (ItemStack)regularItems.get(i);
                if (!this.corpse_Curios_Compat$tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
                ((Consumer)regularClearActions.get(i)).accept(stack);
            }
        }
    }

    @Unique
    private boolean corpse_Curios_Compat$shouldTransferCurio(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.getItem()).isEmpty()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = (CuriosSlotDataComponent.CurioSlotData)stack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
        if (slotData == null || !slotData.wasEquipped()) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.getItem())) {
            return false;
        }
        return Config.shouldTransferCursedItems() || !Config.isItemCursed(stack);
    }

    @Unique
    private boolean corpse_Curios_Compat$tryTransferPreviouslyEquippedCurio(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        if (stack.isEmpty()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.getItem()).isEmpty()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = (CuriosSlotDataComponent.CurioSlotData)stack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
        if (slotData == null || !slotData.wasEquipped()) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.getItem())) {
            return false;
        }
        if (!Config.shouldTransferCursedItems() && Config.isItemCursed(stack)) {
            return false;
        }
        String slotType = slotData.slotType();
        int slotIndex = slotData.slotIndex();
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0) {
            try {
                IDynamicStackHandler targetStacks = slotData.isCosmetic() ? handler.getCosmeticStacks() : handler.getStacks();
                int availableSlots = targetStacks.getSlots();
                if (slotIndex < availableSlots) {
                    ItemStack existingStack = targetStacks.getStackInSlot(slotIndex);
                    if (!existingStack.isEmpty()) {
                        ItemStack cleanStack = stack.copy();
                        cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                        if (!this.cachedPlayer.getInventory().add(cleanStack)) {
                            this.cachedPlayer.drop(cleanStack, false);
                        }
                        return true;
                    }
                    ItemStack cleanStack = stack.copy();
                    cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                    targetStacks.setStackInSlot(slotIndex, cleanStack);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException e) {
                ItemStack cleanStack = stack.copy();
                cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                if (!this.cachedPlayer.getInventory().add(cleanStack)) {
                    this.cachedPlayer.drop(cleanStack, false);
                }
                return true;
            }
        }
        ItemStack cleanStack = stack.copy();
        cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
        if (!this.cachedPlayer.getInventory().add(cleanStack)) {
            this.cachedPlayer.drop(cleanStack, false);
        }
        return true;
    }
}

