/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.kinetic;

import dev.engine_room.flywheel.api.event.ReloadLevelRendererEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public final class RendererReloadCache<T, U> {
    private static final Set<RendererReloadCache<?, ?>> ALL = Collections.newSetFromMap(new WeakHashMap());
    private final Map<T, U> map = new ConcurrentHashMap<T, U>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RendererReloadCache() {
        Set<RendererReloadCache<?, ?>> set = ALL;
        synchronized (set) {
            ALL.add(this);
        }
    }

    public final U get(T key, Function<T, U> factory) {
        return this.map.computeIfAbsent(key, factory);
    }

    public final void clear() {
        this.map.clear();
    }

    @ApiStatus.Internal
    public static void onReloadLevelRenderer(ReloadLevelRendererEvent e) {
        for (RendererReloadCache<?, ?> cache : ALL) {
            cache.clear();
        }
    }
}

