/*
 * Decompiled with CFR 0.152.
 */
package systems.alexander.bellsandwhistles.block.custom;

import com.simibubi.create.content.decoration.MetalLadderBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalStepBlock
extends MetalLadderBlock
implements IWrenchable {
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)-0.5, (double)12.0, (double)15.0, (double)0.5, (double)16.0);

    public MetalStepBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public float getShadeBrightness(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    private boolean canAttachTo(BlockGetter pBlockReader, BlockPos pPos, Direction pDirection) {
        BlockState blockstate = pBlockReader.getBlockState(pPos);
        return true;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        return this.canAttachTo((BlockGetter)pLevel, pPos.relative(direction.getOpposite()), direction);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return super.isLadder(state, level, pos, entity);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.ordinal() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE;
            }
            case SOUTH: {
                return MetalStepBlock.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
            }
            case WEST: {
                return MetalStepBlock.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
            }
        }
        return MetalStepBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
    }
}

