/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.common.ExtendedHangingSign;
import net.mehvahdjukaar.amendments.common.tile.HangingSignTileExtension;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.BlockUse;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class HangingSignDisplayItem
implements BlockUse {
    public static final HangingSignDisplayItem INSTANCE = new HangingSignDisplayItem();

    @Override
    public boolean isEnabled() {
        return CommonConfigs.HANGING_SIGN_ITEM.get();
    }

    @Override
    public boolean appliesToBlock(Block block) {
        return block instanceof CeilingHangingSignBlock || block instanceof WallHangingSignBlock;
    }

    @Override
    public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (!this.isEnabled()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExtendedHangingSign) {
            ExtendedHangingSign e = (ExtendedHangingSign)blockEntity;
            SignBlockEntity be = (SignBlockEntity)e;
            HangingSignTileExtension ext = e.amendments$getExtension();
            if (!be.isWaxed()) {
                ItemStack item;
                boolean front = be.isFacingFrontText(player);
                ItemStack itemStack = item = front ? ext.getFrontItem() : ext.getBackItem();
                if (!stack.isEmpty() && !item.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                if (stack.getItem() instanceof SignApplicator && !player.isSecondaryUseActive()) {
                    return InteractionResult.PASS;
                }
                return HangingSignDisplayItem.interactWithFace(state, pos, level, player, hand, stack, be, ext, front);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult interactWithFace(BlockState state, BlockPos pos, Level level, Player player, InteractionHand hand, ItemStack stack, SignBlockEntity be, HangingSignTileExtension ext, boolean front) {
        boolean hasItem;
        ItemStack tileItem = front ? ext.getFrontItem() : ext.getBackItem();
        boolean bl = hasItem = !tileItem.isEmpty();
        if (!hasItem && !stack.isEmpty()) {
            level.playSound(player, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.95f);
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (front) {
                ext.setFrontItem(stack.copyWithCount(1));
            } else {
                ext.setBackItem(stack.copyWithCount(1));
            }
            stack.consume(1, (LivingEntity)player);
            HangingSignDisplayItem.setMessagesAndUpdate(be, front, "item");
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return InteractionResult.CONSUME;
        }
        if (hasItem && stack.isEmpty()) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            player.setItemInHand(hand, tileItem.split(1));
            HangingSignDisplayItem.setMessagesAndUpdate(be, front, "");
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static void setMessagesAndUpdate(SignBlockEntity sign, boolean front, String s) {
        sign.updateText(signText -> {
            MutableComponent literal = Component.literal((String)s);
            return signText.setMessage(0, (Component)literal).setMessage(1, (Component)literal).setMessage(2, (Component)literal).setMessage(3, (Component)literal);
        }, front);
    }
}

