/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.holder;

import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record SyncHolderChange(HolderProperty<?> property, Object data) {
    public static final StructEndec<SyncHolderChange> ENDEC = new StructEndec<SyncHolderChange>(){

        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, SyncHolderChange value) {
            struct.field("property", ctx, HolderProperty.ENDEC, value.property());
            struct.field("value", ctx, value.property().endec(), value.data());
        }

        public SyncHolderChange decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            HolderProperty prop = (HolderProperty)struct.field("property", ctx, HolderProperty.ENDEC);
            return new SyncHolderChange(prop, struct.field("value", ctx, prop.endec()));
        }
    };

    public static <T> SyncHolderChange of(HolderProperty<T> property, T data) {
        return new SyncHolderChange(property, data);
    }

    public static <T> SyncHolderChange of(HolderProperty<T> property, Player player, Function<T, T> operation) {
        return new SyncHolderChange(property, operation.apply(property.getter().apply(player.accessoriesHolder())));
    }

    public static void handlePacket(SyncHolderChange packet, Player player) {
        packet.property().setData(player, packet.data());
        if (player.level().isClientSide()) {
            SyncHolderChange.handleClient(packet, player);
        } else {
            AccessoriesNetworking.sendToPlayer((ServerPlayer)player, SyncHolderChange.of(packet.property(), packet.property().getter().apply(player.accessoriesHolder())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(SyncHolderChange packet, Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AccessoriesScreenBase) {
            AccessoriesScreenBase accessoriesScreen = (AccessoriesScreenBase)screen;
            accessoriesScreen.onHolderChange(packet.property().name());
        }
    }
}

