/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.GuiGraphicsUtils;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingComponent;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.ExtendedCollapsibleContainer;
import io.wispforest.accessories.client.gui.components.ExtendedScrollContainer;
import io.wispforest.accessories.client.gui.components.GriddedAccessoriesComponent;
import io.wispforest.accessories.client.gui.components.InventoryEntityComponent;
import io.wispforest.accessories.client.gui.components.ScrollableAccessoriesComponent;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.accessories.mixin.client.AbstractContainerScreenAccessor;
import io.wispforest.accessories.mixin.client.owo.DiscreteSliderComponentAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import io.wispforest.owo.mixin.ui.SlotAccessor;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.slf4j.Logger;
import oshi.util.tuples.Triplet;

public class AccessoriesExperimentalScreen
extends BaseOwoHandledScreen<FlowLayout, AccessoriesExperimentalMenu>
implements AccessoriesScreenBase<AccessoriesExperimentalMenu>,
ContainerScreenExtension {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Integer, Boolean> changedSlots = new HashMap<Integer, Boolean>();
    private boolean showCosmeticState = false;
    @Nullable
    private AccessoriesContainingComponent topComponent = null;
    @Nullable
    private io.wispforest.owo.ui.core.Component baseFilterLayout = null;
    private final Surface SLOT_RENDERING_SURFACE = (context, component) -> {
        ArrayList<ExtendedSlotComponent> validComponents = new ArrayList<ExtendedSlotComponent>();
        ComponentUtils.recursiveSearch(component, ExtendedSlotComponent.class, slotComponent -> {
            if (!slotComponent.isBatched() || !(slotComponent.slot() instanceof SlotTypeAccessible)) {
                return;
            }
            validComponents.add((ExtendedSlotComponent)((Object)((Object)slotComponent)));
        });
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        context.push();
        context.translate(0.0f, 0.0f, 100.0f);
        HashMap<K, @Nullable V> slotStateData = new HashMap();
        HashMap allBl2s = new HashMap();
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)((Object)this);
        int i = this.leftPos;
        int j = this.topPos;
        context.push();
        context.translate((float)i, (float)j, 0.0f);
        AccessoriesExperimentalScreen.safeBatching(context, hasDrawCallOccur -> {
            for (ExtendedSlotComponent slotComponent : validComponents) {
                Slot slot = slotComponent.slot();
                Triplet data = slotStateData.computeIfAbsent(slot, this::getRenderStack);
                if (data == null) continue;
                allBl2s.put(slot, AccessoriesExperimentalScreen.renderSlotTexture((GuiGraphics)context, slot, (ItemStack)data.getA()));
                hasDrawCallOccur.setValue(true);
            }
        });
        AccessoriesExperimentalScreen.safeBatching(context, hasDrawCallOccur -> {
            for (ExtendedSlotComponent slotComponent : validComponents) {
                boolean bl2;
                Slot slot = slotComponent.slot();
                Triplet data = slotStateData.computeIfAbsent(slot, this::getRenderStack);
                if (data == null) {
                    return;
                }
                ItemStack itemStack = (ItemStack)data.getA();
                boolean bl = bl2 = allBl2s.getOrDefault(slot, false) != false || slot == accessor.accessories$getClickedSlot() && !accessor.accessories$getDraggingItem().isEmpty() && !accessor.accessories$isSplittingStack();
                if (!bl2) {
                    int slotX = slot.x;
                    int slotY = slot.y;
                    if (((Boolean)data.getB()).booleanValue()) {
                        context.fill(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
                    }
                    int k = slot.x + slot.y * this.imageWidth;
                    if (slot.isFake()) {
                        context.renderFakeItem(itemStack, slotX, slotY, k);
                    } else {
                        context.renderItem(itemStack, slotX, slotY, k);
                    }
                    context.renderItemDecorations(this.font, itemStack, slotX, slotY, (String)data.getC());
                }
                hasDrawCallOccur.setValue(true);
            }
        });
        context.pop();
        AccessoriesExperimentalScreen.safeBatching(context, hasDrawCallOccur -> {
            for (ExtendedSlotComponent slotComponent : validComponents) {
                slotComponent.renderCosmeticOverlay(context, true);
                hasDrawCallOccur.setValue(true);
            }
        });
        context.pop();
        validComponents.forEach(slotComponent -> slotComponent.renderHover(context, () -> this.hoveredSlot));
    };
    public final Surface FULL_SLOT_RENDERING = ComponentUtils.BACKGROUND_SLOT_RENDERING_SURFACE.and(this.SLOT_RENDERING_SURFACE);

    public AccessoriesExperimentalScreen(AccessoriesExperimentalMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.inventoryLabelX = 42069;
    }

    protected void init() {
        if (!((AccessoriesExperimentalMenu)this.menu).isValidMenu()) {
            Minecraft.getInstance().setScreen((Screen)new ErrorScreen((Component)Component.literal((String)"Accessories Screen Opening Error!"), (Component)Component.literal((String)"Unable to open Accessories Screen due to desync with the Server!")));
            return;
        }
        super.init();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (AccessoriesClient.OPEN_SCREEN.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    public Stream<io.wispforest.owo.ui.core.Component> componentsForExclusionAreas() {
        return ((FlowLayout)this.uiAdapter.rootComponent).children().stream();
    }

    public <C extends io.wispforest.owo.ui.core.Component> C component(Class<C> expectedClass, String id) {
        return (C)super.component(expectedClass, id);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.changedSlots.isEmpty()) {
            return;
        }
        NonNullList slots = ((AccessoriesExperimentalMenu)this.getMenu()).slots;
        Map<Integer, Boolean> changes = this.changedSlots.entrySet().stream().filter(entry -> (Integer)entry.getKey() < slots.size()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ((AccessoriesExperimentalMenu)this.getMenu()).sendMessage(new ToggledSlots(changes));
        this.changedSlots.clear();
    }

    public void hideSlot(int index) {
        this.hideSlot((Slot)((AccessoriesExperimentalMenu)this.menu).slots.get(index));
    }

    public void hideSlot(Slot slot) {
        ((SlotAccessor)slot).owo$setX(-300);
        ((SlotAccessor)slot).owo$setY(-300);
    }

    public void disableSlot(Slot slot) {
        super.disableSlot(slot);
        int index = slot.index;
        Boolean state = this.changedSlots.getOrDefault(index, null);
        if (state != null && state.booleanValue()) {
            return;
        }
        this.hideSlot(index);
        this.changedSlots.put(index, true);
    }

    public void disableSlots(int ... index) {
        for (int i : index) {
            this.disableSlot(i);
        }
    }

    public void enableSlot(Slot slot) {
        super.enableSlot(slot);
        int index = slot.index;
        Boolean state = this.changedSlots.getOrDefault(index, null);
        if (state != null && !state.booleanValue()) {
            return;
        }
        this.changedSlots.put(index, false);
    }

    @Override
    public final LivingEntity targetEntityDefaulted() {
        LivingEntity targetEntity = ((AccessoriesExperimentalMenu)this.menu).targetEntity();
        return targetEntity != null ? targetEntity : this.minecraft.player;
    }

    @Override
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Override
    @Nullable
    public Boolean isHovering_Logical(Slot slot, double mouseX, double mouseY) {
        AccessoriesContainingComponent accessories = this.topComponent;
        return accessories != null ? accessories.isHovering_Logical(slot, mouseX, mouseY) : null;
    }

    @Override
    @Nullable
    public Boolean isHovering_Rendering(Slot slot, double mouseX, double mouseY) {
        return slot instanceof SlotTypeAccessible ? Boolean.FALSE : null;
    }

    @Override
    @Nullable
    public Boolean shouldRenderSlot(Slot slot) {
        return slot instanceof SlotTypeAccessible ? Boolean.FALSE : null;
    }

    @Override
    public int hoverStackOffset() {
        return 160;
    }

    public void onClose() {
        Set selectedGroups = ((AccessoriesExperimentalMenu)this.getMenu()).selectedGroups().stream().map(SlotGroup::name).collect(Collectors.toSet());
        AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.FILTERED_GROUPS, selectedGroups));
        super.onClose();
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.hoveredSlot != null) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof AccessoriesInternalSlot) {
                AccessoriesInternalSlot accessoriesInternalSlot = (AccessoriesInternalSlot)slot;
                if (!ArmorSlotTypes.isArmorType(accessoriesInternalSlot.slotName())) {
                    AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(this.mainWidgetPosition());
                }
            } else if (this.hoveredSlot instanceof ArmorSlot) {
                AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(true);
            } else if ((this.hoveredSlot.container instanceof TransientCraftingContainer || this.hoveredSlot instanceof ResultSlot) && !this.showGroupFilters()) {
                AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(!this.mainWidgetPosition());
            }
        }
        guiGraphics.push().translate(0.0f, 0.0f, 300.0f);
        super.renderTooltip(guiGraphics, x, y);
        guiGraphics.pop();
        AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack itemStack) {
        ItemStack hoveredStack;
        AccessoriesBasedSlot slot;
        Slot slot2;
        List tooltipData = AccessoriesExperimentalScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)itemStack);
        if (Accessories.config().screenOptions.showEquippedStackSlotType() && ((AccessoriesExperimentalMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem() && (slot2 = this.hoveredSlot) instanceof AccessoriesBasedSlot && ExtraSlotTypeProperties.getProperty((slot = (AccessoriesBasedSlot)slot2).slotName(), true).allowTooltipInfo() && itemStack == (hoveredStack = this.hoveredSlot.getItem())) {
            tooltipData.add(Component.empty());
            tooltipData.add(Component.translatable((String)Accessories.translationKey("tooltip.currently_equipped_in")).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)slot.slotType().translation()).withStyle(ChatFormatting.BLUE)));
        }
        return tooltipData;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        AccessoriesInternalSlot slot;
        Slot slot2;
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        if (this.getHoveredSlot() != null && (slot2 = this.getHoveredSlot()) instanceof AccessoriesInternalSlot && (slot = (AccessoriesInternalSlot)slot2).isActive() && !slot.getItem().isEmpty() && NOT_VERY_NICE_POSITIONS.containsKey(slot.accessoriesContainer.getSlotName() + slot.getContainerSlot())) {
            ACCESSORY_POSITIONS.add((Vector3d)NOT_VERY_NICE_POSITIONS.get(slot.accessoriesContainer.getSlotName() + slot.getContainerSlot()));
            String positionKey = slot.accessoriesContainer.getSlotName() + slot.getContainerSlot();
            Vector3d vec = NOT_VERY_NICE_POSITIONS.getOrDefault(positionKey, null);
            if (!slot.isCosmetic && vec != null && Accessories.config().screenOptions.hoveredOptions.line()) {
                Vector3d start = new Vector3d((double)(slot.x + this.leftPos + 17), (double)(slot.y + this.topPos + 9), 5000.0);
                Vector3d vec3 = vec.add(0.0, 0.0, 5000.0);
                ACCESSORY_LINES.add(it.unimi.dsi.fastutil.Pair.of((Object)start, (Object)vec3));
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (Accessories.config().screenOptions.hoveredOptions.clickbait()) {
            ACCESSORY_POSITIONS.forEach(pos -> guiGraphics.blitSprite(Accessories.of("highlight/clickbait"), (int)pos.x - 128, (int)pos.y - 128, 450, 256, 256));
            ACCESSORY_POSITIONS.clear();
        }
        if (!ACCESSORY_LINES.isEmpty() || Accessories.config().screenOptions.hoveredOptions.line()) {
            VertexConsumer buf = guiGraphics.bufferSource().getBuffer((RenderType)RenderType.LINES);
            PoseStack.Pose lastPose = guiGraphics.pose().last();
            for (it.unimi.dsi.fastutil.Pair line : ACCESSORY_LINES) {
                Vector3d endPoint = (Vector3d)line.second();
                if (endPoint.x == 0.0 || endPoint.y == 0.0) continue;
                Vector3f normalVec = endPoint.sub((Vector3dc)line.first(), new Vector3d()).normalize().get(new Vector3f());
                double segments = Math.max(10, (int)(((Vector3d)line.first()).distance((Vector3dc)line.second()) * 10.0) / 100);
                double movement = (double)System.currentTimeMillis() / ((segments *= 2.0) * 1000.0) % 1.0;
                double delta = movement % (2.0 / segments) % segments;
                Vector3f firstVec = ((Vector3d)line.first()).get(new Vector3f());
                if (delta > 0.05) {
                    buf.addVertex(firstVec).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                    Vector3f pos2 = new Vector3d(Mth.lerp((double)(delta - 0.05), (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.lerp((double)(delta - 0.05), (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.lerp((double)(delta - 0.05), (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    buf.addVertex(pos2).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                }
                int i = 0;
                while ((double)i < segments / 2.0) {
                    double delta1 = ((double)(i * 2) / segments + movement) % 1.0;
                    double delta2 = ((double)(i * 2 + 1) / segments + movement) % 1.0;
                    Vector3f pos1 = new Vector3d(Mth.lerp((double)delta1, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.lerp((double)delta1, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.lerp((double)delta1, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    Vector3f pos2 = (delta2 > delta1 ? new Vector3d(Mth.lerp((double)delta2, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.lerp((double)delta2, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.lerp((double)delta2, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)) : (Vector3d)line.second()).get(new Vector3f());
                    buf.addVertex(pos1).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                    buf.addVertex(pos2).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                    ++i;
                }
            }
            this.minecraft.renderBuffers().bufferSource().endBatch((RenderType)RenderType.LINES);
            ACCESSORY_LINES.clear();
        }
    }

    public void showCosmeticState(boolean value) {
        this.showCosmeticState = value;
    }

    public boolean showCosmeticState() {
        return this.showCosmeticState;
    }

    protected void build(FlowLayout rootComponent) {
        this.changedSlots.clear();
        ((AccessoriesExperimentalMenu)this.getMenu()).slots.forEach(this::disableSlot);
        rootComponent.allowOverflow(true).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        ArrayList<Object> baseChildren = new ArrayList<Object>();
        AccessoriesContainingComponent accessoriesComponent = this.createAccessoriesComponent();
        AccessoriesExperimentalMenu menu = (AccessoriesExperimentalMenu)this.getMenu();
        SlotGroupLoader.getValidGroups(((AccessoriesExperimentalMenu)this.getMenu()).targetEntityDefaulted()).keySet().stream().filter(group -> this.getHolderValue(AccessoriesHolder::filteredGroups, Set.of(), "filteredGroups").contains(group.name())).forEach(menu::addSelectedGroup);
        io.wispforest.owo.ui.core.Component playerInv = ComponentUtils.createPlayerInv(5, menu.startingAccessoriesSlot(), this::slotAsComponent, x$0 -> this.enableSlot((int)x$0));
        this.showAdvancedOptions(false);
        int offHandIndex = ((AccessoriesExperimentalMenu)this.getMenu()).startingAccessoriesSlot() - (((AccessoriesExperimentalMenu)this.getMenu()).includeSaddle() ? 2 : 1);
        this.enableSlot(offHandIndex);
        baseChildren.add(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(Containers.verticalFlow((Sizing)Sizing.fixed((int)162), (Sizing)Sizing.fixed((int)76)).child(playerInv).margins(Insets.right((int)3)).id("bottom_component_holder")).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(Components.button((Component)AccessoriesExperimentalScreen.createToggleTooltip("advanced_options", false, this.showAdvancedOptions()), btn -> {
            this.showAdvancedOptions(!this.showAdvancedOptions());
            btn.setMessage(AccessoriesExperimentalScreen.createToggleTooltip("advanced_options", false, this.showAdvancedOptions()));
            btn.tooltip(AccessoriesExperimentalScreen.createToggleTooltip("advanced_options", true, this.showAdvancedOptions()));
            this.swapBottomComponentHolder();
        }).renderer(ComponentUtils.getButtonRenderer()).tooltip(AccessoriesExperimentalScreen.createToggleTooltip("advanced_options", true, this.showAdvancedOptions())).sizing(Sizing.fixed((int)16)).margins(Insets.of((int)1))).child(Components.button((Component)AccessoriesExperimentalScreen.createToggleTooltip("crafting_grid", false, this.showCraftingGrid()), btn -> {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.CRAFTING_GRID_PROP, ((AccessoriesExperimentalMenu)this.menu).owner(), bl -> bl == false));
            this.showCraftingGrid(!this.showCraftingGrid());
            btn.setMessage(AccessoriesExperimentalScreen.createToggleTooltip("crafting_grid", false, this.showCraftingGrid()));
            btn.tooltip(AccessoriesExperimentalScreen.createToggleTooltip("crafting_grid", true, this.showCraftingGrid()));
            this.toggleCraftingGrid();
        }).renderer(ComponentUtils.getButtonRenderer()).tooltip(AccessoriesExperimentalScreen.createToggleTooltip("crafting_grid", true, this.showCraftingGrid())).sizing(Sizing.fixed((int)16)).margins(Insets.of((int)1)).id("crafting_grid_button")).child(Components.spacer().sizing(Sizing.fixed((int)18))).child(Components.spacer().sizing(Sizing.fixed((int)4))).child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)this.slotAsComponent(offHandIndex).margins(Insets.of((int)1)))).zIndex(10))).child(((FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(component -> {
            if (!this.sideBarCraftingSpot() && this.showCraftingGrid()) {
                component.margins(Insets.left((int)3));
                component.child(this.createCraftingGrid());
            }
        })).id("crafting_grid_layout")).padding(Insets.of((int)6)).surface((ctx, component) -> {
            boolean showCraftingGrid = !this.sideBarCraftingSpot() && this.showCraftingGrid();
            int width = showCraftingGrid ? 234 : 195;
            ctx.blit(Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/player_inv/" + (showCraftingGrid ? "with" : "without") + "_crafting.png"), component.x(), component.y(), component.width(), component.height(), 0.0f, 0.0f, width, 88, width, 88);
        }).id("bottom_inventory_section"));
        FlowLayout armorAndEntityLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)138)).gap(2).horizontalAlignment(HorizontalAlignment.CENTER).id("armor_entity_layout");
        FlowLayout armorSlotsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        FlowLayout outerLeftArmorLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)armorSlotsLayout);
        FlowLayout cosmeticArmorSlotsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> layout.allowOverflow(true));
        FlowLayout outerRightArmorLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)cosmeticArmorSlotsLayout);
        for (int i = 0; i < menu.addedArmorSlots() / 2; ++i) {
            int armor = menu.startingAccessoriesSlot() + i * 2;
            int cosmeticArmor = armor + 1;
            this.enableSlot(armor);
            this.enableSlot(cosmeticArmor);
            armorSlotsLayout.child((io.wispforest.owo.ui.core.Component)this.slotAsComponent(armor).margins(Insets.of((int)1)));
            cosmeticArmorSlotsLayout.child((io.wispforest.owo.ui.core.Component)ComponentUtils.slotAndToggle((AccessoriesBasedSlot)((AccessoriesExperimentalMenu)this.menu).slots.get(cosmeticArmor), false, this::slotAsComponent).left());
        }
        int entityComponentSize = 126;
        ParentComponent entityContainer = Containers.stack((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)(entityComponentSize + 12))).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(InventoryEntityComponent.of(Sizing.fixed((int)entityComponentSize), Sizing.fixed((int)108), ((AccessoriesExperimentalMenu)this.getMenu()).targetEntityDefaulted()).renderWrapping((TriConsumer<OwoUIDrawContext, io.wispforest.owo.ui.core.Component, Runnable>)((TriConsumer)(ctx, component, renderCall) -> {
            AccessoriesScreenBase.SCISSOR_BOX.set(component.x(), component.y(), component.x() + component.width(), component.y() + component.height());
            AccessoriesScreenBase.togglePositionCollection();
            AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.setValue(true);
            AccessoriesScreenBase.IS_RENDERING_LINE_TARGET.setValue(true);
            renderCall.run();
            AccessoriesScreenBase.IS_RENDERING_LINE_TARGET.setValue(false);
            AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.setValue(false);
            AccessoriesScreenBase.COLLECT_ACCESSORY_POSITIONS.setValue(false);
        })).startingRotation(this.mainWidgetPosition() ? -45.0f : 45.0f).scaleToFit(true).allowMouseRotation(true).lookAtCursor(Accessories.config().screenOptions.entityLooksAtMouseCursor()).id("entity_rendering_component"))).child(((FlowLayout)outerLeftArmorLayout.configure(component -> component.mouseScroll().subscribe((mouseX, mouseY, amount) -> true))).padding(Insets.of((int)6)).margins(Insets.left((int)-6)).positioning(Positioning.relative((int)0, (int)40)).zIndex(200)).child(((FlowLayout)outerRightArmorLayout.configure(component -> component.mouseScroll().subscribe((mouseX, mouseY, amount) -> true))).padding(Insets.of((int)6)).margins(Insets.right((int)-6)).positioning(Positioning.relative((int)100, (int)40)).zIndex(200)).child(Components.button((Component)Component.literal((String)""), btn -> this.switchToBaseInventory()).renderer((context, btn, delta) -> {
            ComponentUtils.getButtonRenderer().draw(context, btn, delta);
            context.push();
            ResourceLocation BACK_ICON = Accessories.config().screenOptions.isDarkMode() ? Accessories.of("widget/back_dark") : Accessories.of("widget/back");
            GuiSpriteManager sprites = this.minecraft.getGuiSprites();
            TextureAtlasSprite textureAtlasSprite = sprites.getSprite(BACK_ICON);
            int width = Math.min(textureAtlasSprite.contents().width(), 8);
            int height = Math.min(textureAtlasSprite.contents().height(), 8);
            context.blitSprite(BACK_ICON, btn.x() + 1, btn.y() + 1, width, height);
            context.pop();
        }).tooltip((Component)Component.translatable((String)Accessories.translationKey("back.screen"))).positioning(Positioning.relative((int)100, (int)0)).margins(Insets.of((int)1, (int)0, (int)0, (int)1)).sizing(Sizing.fixed((int)10))).padding(Insets.of((int)6)).surface((ctx, component) -> {
            String surfaceType = ((AccessoriesExperimentalMenu)this.getMenu()).addedArmorSlots() > 4 ? "full_armor" : "single_armor" + (((AccessoriesExperimentalMenu)this.getMenu()).includeSaddle() ? "_saddled" : "");
            ctx.blit(Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/entity_view/" + surfaceType + ".png"), component.x(), component.y(), component.width(), component.height(), 0.0f, 0.0f, 120, 138, 120, 138);
        });
        if (((AccessoriesExperimentalMenu)this.getMenu()).includeSaddle()) {
            int saddleIndex = ((AccessoriesExperimentalMenu)this.getMenu()).startingAccessoriesSlot() - 1;
            this.enableSlot(saddleIndex);
            ((StackLayout)entityContainer).child(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)this.slotAsComponent(saddleIndex).margins(Insets.of((int)1)))).padding(Insets.of((int)6)).positioning(Positioning.relative((int)0, (int)100)).margins(Insets.of((int)0, (int)-6, (int)-6, (int)0)).zIndex(10));
        }
        armorAndEntityLayout.child((io.wispforest.owo.ui.core.Component)entityContainer);
        baseChildren.add(armorAndEntityLayout);
        if (accessoriesComponent != null) {
            armorAndEntityLayout.child(this.mainWidgetPosition() ? 0 : 1, (io.wispforest.owo.ui.core.Component)accessoriesComponent);
        }
        if (accessoriesComponent != null || !((AccessoriesExperimentalMenu)this.getMenu()).selectedGroups().isEmpty()) {
            FlowLayout sideBarHolder = this.createSideBarOptions();
            if (this.sideWidgetPosition() == this.mainWidgetPosition()) {
                armorAndEntityLayout.child(0, (io.wispforest.owo.ui.core.Component)sideBarHolder);
            } else {
                armorAndEntityLayout.child((io.wispforest.owo.ui.core.Component)sideBarHolder);
            }
        }
        FlowLayout baseLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).children((Collection)baseChildren.reversed());
        baseLayout.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)50, (int)50));
        rootComponent.child((io.wispforest.owo.ui.core.Component)baseLayout);
    }

    public void rebuildAccessoriesComponent() {
        DiscreteSliderComponent columnAmountSlider = (DiscreteSliderComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(DiscreteSliderComponent.class, "column_amount_slider");
        if (columnAmountSlider != null) {
            double previousValue = columnAmountSlider.discreteValue();
            int newMinimum = this.getMinimumColumnAmount();
            ((DiscreteSliderComponentAccessor)columnAmountSlider).accessories$setMin(newMinimum);
            int newValue = Math.max((int)Math.round(previousValue), newMinimum);
            columnAmountSlider.setFromDiscreteValue((double)newValue);
            ((DiscreteSliderComponentAccessor)columnAmountSlider).accessories$updateMessage();
            this.columnAmount(newValue);
        }
        ((AccessoriesExperimentalMenu)this.getMenu()).getAccessoriesSlots().forEach(this::disableSlot);
        FlowLayout armorAndEntityComp = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "armor_entity_layout");
        for (io.wispforest.owo.ui.core.Component child : List.copyOf(armorAndEntityComp.children())) {
            AccessoriesContainingComponent accessories;
            ParentComponent parent;
            if (!AccessoriesContainingComponent.defaultID().equals(child.id()) || !(child instanceof AccessoriesContainingComponent) || (parent = (accessories = (AccessoriesContainingComponent)child).parent()) == null) continue;
            ComponentUtils.recursiveSearch(parent, ExtendedSlotComponent.class, slotComponent -> this.hideSlot(slotComponent.slot()));
            parent.removeChild((io.wispforest.owo.ui.core.Component)accessories);
        }
        AccessoriesContainingComponent accessoriesComp = this.createAccessoriesComponent();
        if (accessoriesComp != null) {
            if (this.mainWidgetPosition()) {
                armorAndEntityComp.child(0, (io.wispforest.owo.ui.core.Component)accessoriesComp);
            } else {
                armorAndEntityComp.child((io.wispforest.owo.ui.core.Component)accessoriesComp);
            }
            this.swapOrCreateSideBarComponent();
        } else if (((AccessoriesExperimentalMenu)this.getMenu()).selectedGroups().isEmpty()) {
            ParentComponent parent;
            io.wispforest.owo.ui.core.Component sideBarOptionsComponent = armorAndEntityComp.childById(io.wispforest.owo.ui.core.Component.class, "accessories_toggle_panel");
            if (sideBarOptionsComponent != null && (parent = sideBarOptionsComponent.parent()) != null) {
                parent.removeChild(sideBarOptionsComponent);
            }
        } else {
            this.swapOrCreateSideBarComponent();
        }
        this.toggleCraftingGrid();
    }

    public void swapOrCreateSideBarComponent() {
        if (this.topComponent == null && ((AccessoriesExperimentalMenu)this.getMenu()).selectedGroups().isEmpty()) {
            return;
        }
        FlowLayout armorAndEntityComp = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "armor_entity_layout");
        FlowLayout sideBarHolder = (FlowLayout)armorAndEntityComp.childById(FlowLayout.class, "side_bar_holder");
        armorAndEntityComp.removeChild((io.wispforest.owo.ui.core.Component)sideBarHolder);
        sideBarHolder = this.createSideBarOptions();
        if (this.sideWidgetPosition() == this.mainWidgetPosition()) {
            armorAndEntityComp.child(0, (io.wispforest.owo.ui.core.Component)sideBarHolder);
        } else {
            armorAndEntityComp.child((io.wispforest.owo.ui.core.Component)sideBarHolder);
        }
    }

    private int getMinimumColumnAmount() {
        return this.widgetType() == 2 ? 1 : 3;
    }

    @Nullable
    private AccessoriesContainingComponent createAccessoriesComponent() {
        this.topComponent = this.widgetType() == 2 ? ScrollableAccessoriesComponent.createOrNull(this) : GriddedAccessoriesComponent.createOrNull(this);
        return this.topComponent;
    }

    private FlowLayout createSideBarOptions() {
        io.wispforest.owo.ui.core.Component cosmeticToggleButton = Components.button((Component)Component.literal((String)""), btn -> {
            this.showCosmeticState(!this.showCosmeticState());
            btn.tooltip(AccessoriesExperimentalScreen.createToggleTooltip("slot_cosmetics", false, this.showCosmeticState()));
            AccessoriesContainingComponent component = (AccessoriesContainingComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(AccessoriesContainingComponent.class, AccessoriesContainingComponent.defaultID());
            if (component != null) {
                component.onCosmeticToggle(this.showCosmeticState());
            }
        }).renderer((context, button, delta) -> {
            ComponentUtils.getButtonRenderer().draw(context, button, delta);
            ResourceLocation texture = !this.showCosmeticState() ? Accessories.of("textures/gui/theme/cosmetic_rainbow_icon.png") : Accessories.of("textures/gui/theme/" + (Accessories.config().screenOptions.isDarkMode() ? "dark" : "light") + "/charm_icon.png");
            context.blit(texture, button.x() + 2, button.y() + 2, 16, 16, 0.0f, 0.0f, 32, 32, 32, 32);
        }).sizing(Sizing.fixed((int)20)).tooltip(AccessoriesExperimentalScreen.createToggleTooltip("slot_cosmetics", false, this.showCosmeticState()));
        FlowLayout accessoriesTogglePanel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(cosmeticToggleButton.margins(Insets.of((int)2, (int)2, (int)2, (int)2))).gap(1).padding(Insets.of((int)6)).surface((ctx, component) -> {
            if (component.children().size() > 1) {
                ComponentUtils.getPanelSurface().and(ComponentUtils.getPanelWithInset(6)).draw(ctx, component);
            } else {
                ctx.blit(Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/toggle_background.png"), component.x(), component.y(), component.width(), component.height(), 0.0f, 0.0f, 36, 36, 36, 36);
            }
        }).horizontalAlignment(HorizontalAlignment.CENTER).id("accessories_toggle_panel");
        io.wispforest.owo.ui.core.Component groupFilterComponent = this.createGroupFilters();
        if (groupFilterComponent != null) {
            accessoriesTogglePanel.child(groupFilterComponent);
        }
        return (FlowLayout)((FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)accessoriesTogglePanel).configure(component -> {
            if (this.sideBarCraftingSpot() && this.showCraftingGrid()) {
                component.child(this.createCraftingGrid());
            }
        })).horizontalAlignment(this.mainWidgetPosition() ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT).id("side_bar_holder");
    }

    @Nullable
    private io.wispforest.owo.ui.core.Component createGroupFilters() {
        if (!this.showGroupFilters()) {
            return null;
        }
        ArrayList<SlotGroup> groups = new ArrayList<SlotGroup>(SlotGroupLoader.getValidGroups(((AccessoriesExperimentalMenu)this.getMenu()).targetEntityDefaulted()).keySet());
        Set<SlotType> usedSlots = ((AccessoriesExperimentalMenu)this.getMenu()).getUsedSlots();
        if (groups.isEmpty()) {
            return null;
        }
        List<ButtonComponent> groupButtons = groups.stream().map(group -> {
            block3: {
                block2: {
                    Set groupSlots = group.slots().stream().filter(slotName -> !UniqueSlotHandling.isUniqueSlot(slotName)).map(slotName -> SlotTypeLoader.getSlotType(this.targetEntityDefaulted(), slotName)).filter(Objects::nonNull).filter(slotType -> {
                        AccessoriesCapability capability = this.targetEntityDefaulted().accessoriesCapability();
                        if (capability == null) {
                            return false;
                        }
                        AccessoriesContainer container = capability.getContainer((SlotType)slotType);
                        if (container == null) {
                            return false;
                        }
                        return container.getSize() > 0;
                    }).collect(Collectors.toSet());
                    if (groupSlots.isEmpty()) break block2;
                    if (usedSlots == null) break block3;
                    if (!groupSlots.stream().noneMatch(usedSlots::contains)) break block3;
                }
                return null;
            }
            return ComponentUtils.groupToggleBtn(this, group);
        }).filter(Objects::nonNull).toList();
        if (groupButtons.isEmpty()) {
            return null;
        }
        FlowLayout baseButtonLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(groupButtons).gap(1);
        if (groupButtons.size() > 5) {
            double d;
            ExtendedScrollContainer<ParentComponent> extendedScrollContainer = new ExtendedScrollContainer<ParentComponent>(ScrollContainer.ScrollDirection.VERTICAL, Sizing.fixed((int)24), Sizing.fixed((int)78), baseButtonLayout.padding(!this.mainWidgetPosition() ? Insets.of((int)2, (int)2, (int)1, (int)1) : Insets.of((int)2, (int)2, (int)2, (int)0))).oppositeScrollbar(this.sideWidgetPosition() == this.mainWidgetPosition()).customClippingInsets(Insets.of((int)1));
            io.wispforest.owo.ui.core.Component component2 = this.baseFilterLayout;
            if (component2 instanceof ExtendedScrollContainer) {
                ExtendedScrollContainer prevContainer = (ExtendedScrollContainer)component2;
                d = prevContainer.getProgress();
            } else {
                d = 0.0;
            }
            baseButtonLayout = extendedScrollContainer.scrollToAfterLayout(d).scrollbarThiccness(7).scrollbar(ComponentUtils.getScrollbarRenderer()).fixedScrollbarLength(16);
        } else {
            baseButtonLayout.margins(Insets.bottom((int)2));
        }
        this.baseFilterLayout = baseButtonLayout;
        return ((ExtendedCollapsibleContainer)new ExtendedCollapsibleContainer(Sizing.content(), Sizing.content(), this.isGroupFiltersOpen()).configure(component -> component.onToggled().subscribe(b -> {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.GROUP_FILTER_OPEN_PROP, b));
            this.isGroupFiltersOpen(b);
        }))).child(Components.button((Component)Component.empty(), btn -> {
            ((AccessoriesExperimentalMenu)this.getMenu()).selectedGroups().clear();
            this.rebuildAccessoriesComponent();
        }).renderer((context, button, delta) -> {
            ComponentUtils.getButtonRenderer().draw(context, button, delta);
            RenderSystem.depthMask((boolean)false);
            Color color = Color.WHITE;
            RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            context.blit(Accessories.of("textures/gui/reset_icon.png"), button.x() + 3 + 3, button.y() + 3, 0, 0.0f, 0.0f, 8, 8, 8, 8);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }).sizing(Sizing.fixed((int)14)).horizontalSizing(Sizing.fixed((int)20)).margins(Insets.bottom((int)1)).tooltip((Component)Component.translatable((String)Accessories.translationKey("reset.group_filter")))).child((io.wispforest.owo.ui.core.Component)baseButtonLayout).id("group_filter_component");
    }

    private void swapBottomComponentHolder() {
        FlowLayout holder = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "bottom_component_holder");
        holder.clearChildren();
        if (this.showAdvancedOptions()) {
            for (int i = 0; i < ((AccessoriesExperimentalMenu)this.menu).startingAccessoriesSlot() - (((AccessoriesExperimentalMenu)this.getMenu()).includeSaddle() ? 2 : 1); ++i) {
                this.disableSlot(i);
            }
            holder.child(this.createOptionsComponent());
        } else {
            holder.child(ComponentUtils.createPlayerInv(5, ((AccessoriesExperimentalMenu)this.menu).startingAccessoriesSlot(), this::slotAsComponent, x$0 -> this.enableSlot((int)x$0)));
        }
    }

    private void toggleCraftingGrid() {
        this.removeCraftingGrid();
        if (!this.showCraftingGrid()) {
            return;
        }
        FlowLayout bottom_holder = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "crafting_grid_layout");
        FlowLayout side_holder = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "side_bar_holder");
        if (this.sideBarCraftingSpot()) {
            side_holder.child(this.createCraftingGrid());
        } else {
            bottom_holder.margins(Insets.left((int)3));
            bottom_holder.child(this.createCraftingGrid());
        }
    }

    private void removeCraftingGrid() {
        io.wispforest.owo.ui.core.Component craftingComponent;
        FlowLayout bottom_holder = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "crafting_grid_layout");
        FlowLayout side_holder = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "side_bar_holder");
        if (bottom_holder != null) {
            bottom_holder.clearChildren();
        }
        if (side_holder != null && (craftingComponent = side_holder.childById(io.wispforest.owo.ui.core.Component.class, "crafting_component")) != null) {
            side_holder.removeChild(craftingComponent);
        }
        if (!this.showCraftingGrid()) {
            bottom_holder.margins(Insets.of((int)0));
            this.disableSlots(0, 1, 2, 3, 4);
        }
    }

    private boolean sideBarCraftingSpot() {
        return !this.showGroupFilters() && Accessories.config().screenOptions.allowSideBarCraftingGrid() && this.topComponent != null;
    }

    private io.wispforest.owo.ui.core.Component createCraftingGrid() {
        io.wispforest.owo.ui.core.Component component = ComponentUtils.createCraftingComponent(0, 4, this::slotAsComponent, x$0 -> this.enableSlot((int)x$0), true);
        if (this.sideBarCraftingSpot()) {
            component = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand())).child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(component).surface((ctx, component1) -> ctx.blit(Accessories.of("textures/gui/theme/" + ComponentUtils.checkMode("light", "dark") + "/crafting_grid.png"), component1.x(), component1.y(), component1.width(), component1.height(), 0.0f, 0.0f, 44, 88, 44, 88)).padding(Insets.of((int)6)));
        }
        return component.id("crafting_component");
    }

    private io.wispforest.owo.ui.core.Component createOptionsComponent() {
        GridLayout baseOptionPanel = (GridLayout)Containers.grid((Sizing)Sizing.fixed((int)162), (Sizing)Sizing.content(), (int)5, (int)2).configure(component -> component.surface(ComponentUtils.getInsetPanelSurface()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)3)));
        baseOptionPanel.child(this.createConfigComponent("unused_slots", this::showUnusedSlots, bl -> AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, bl))).margins(Insets.bottom((int)3)), 0, 0);
        baseOptionPanel.child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Components.label((Component)Accessories.translation("column_amount_slider.label"))).child(((DiscreteSliderComponent)Components.discreteSlider((Sizing)Sizing.fixed((int)45), (double)this.getMinimumColumnAmount(), (double)18.0).configure(slider -> slider.onChanged().subscribe(value -> {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.COLUMN_AMOUNT_PROP, (int)value));
            this.columnAmount((int)value);
            this.rebuildAccessoriesComponent();
        }))).snap(true).setFromDiscreteValue((double)this.columnAmount()).scrollStep((double)(1.0f / (float)(18 - this.getMinimumColumnAmount()))).tooltip(Accessories.translation("column_amount_slider.tooltip")).id("column_amount_slider").horizontalSizing(Sizing.fixed((int)74))).margins(Insets.bottom((int)3)), 0, 1);
        baseOptionPanel.child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Components.label((Component)Accessories.translation("widget_type.label"))).child(Components.button((Component)AccessoriesExperimentalScreen.widgetTypeToggleMessage(this.widgetType(), false), btn -> {
            int newWidget = this.widgetType() + 1;
            if (newWidget > 2) {
                newWidget = 1;
            }
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.WIDGET_TYPE_PROP, newWidget));
            this.widgetType(newWidget);
            this.updateWidgetTypeToggleButton();
        }).renderer(ComponentUtils.getButtonRenderer()).tooltip(AccessoriesExperimentalScreen.widgetTypeToggleMessage(this.widgetType(), true)).id("widget_type_toggle").horizontalSizing(Sizing.fixed((int)74))).margins(Insets.bottom((int)3)), 1, 0);
        baseOptionPanel.child(this.createConfigComponent("main_widget_position", this::mainWidgetPosition, bl -> {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.MAIN_WIDGET_POSITION_PROP, bl));
            this.mainWidgetPosition((boolean)bl);
            ((InventoryEntityComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(InventoryEntityComponent.class, "entity_rendering_component")).startingRotation(this.mainWidgetPosition() ? -45.0f : 45.0f);
        }).margins(Insets.bottom((int)3)), 1, 1);
        baseOptionPanel.child(this.createConfigComponent("group_filter", this::showGroupFilters, bl -> {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.GROUP_FILTER_PROP, bl));
            this.showGroupFilters((boolean)bl);
            if (this.showGroupFilters()) {
                io.wispforest.owo.ui.core.Component groupFilter;
                FlowLayout panel = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "accessories_toggle_panel");
                if (panel != null && (groupFilter = this.createGroupFilters()) != null) {
                    panel.child(groupFilter);
                }
            } else {
                io.wispforest.owo.ui.core.Component component = ((FlowLayout)this.uiAdapter.rootComponent).childById(io.wispforest.owo.ui.core.Component.class, "group_filter_component");
                if (component != null) {
                    component.remove();
                }
            }
            this.toggleCraftingGrid();
        }).margins(Insets.bottom((int)3)), 2, 0);
        baseOptionPanel.child(this.createConfigComponent("side_widget_position", this::sideWidgetPosition, bl -> {
            AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.SIDE_WIDGET_POSITION_PROP, bl));
            this.sideWidgetPosition((boolean)bl);
            this.swapOrCreateSideBarComponent();
        }).margins(Insets.bottom((int)3)), 2, 1);
        baseOptionPanel.child(this.createConfigComponent("dark_mode_toggle", () -> Accessories.config().screenOptions.isDarkMode(), bl -> Accessories.config().screenOptions.isDarkMode((boolean)bl)), 3, 0);
        baseOptionPanel.child(this.createConfigComponent("show_equipped_stack_slot_type", () -> Accessories.config().screenOptions.showEquippedStackSlotType(), bl -> Accessories.config().screenOptions.showEquippedStackSlotType((boolean)bl)), 3, 1);
        baseOptionPanel.child(this.createConfigComponent("entity_look_at_cursor", () -> Accessories.config().screenOptions.entityLooksAtMouseCursor(), bl -> {
            Accessories.config().screenOptions.entityLooksAtMouseCursor((boolean)bl);
            InventoryEntityComponent component = (InventoryEntityComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(InventoryEntityComponent.class, "entity_rendering_component");
            component.lookAtCursor((boolean)bl);
        }), 4, 0);
        return Containers.verticalScroll((Sizing)Sizing.expand(), (Sizing)Sizing.expand(), (io.wispforest.owo.ui.core.Component)baseOptionPanel);
    }

    private io.wispforest.owo.ui.core.Component createConfigComponent(String type, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)Components.label((Component)Accessories.translation(type + ".label"))).child(Components.button((Component)AccessoriesExperimentalScreen.createToggleTooltip(type, false, getter.get()), btn -> {
            boolean newValue = (Boolean)getter.get() == false;
            setter.accept(newValue);
            btn.setMessage(AccessoriesExperimentalScreen.createToggleTooltip(type, false, newValue));
            btn.tooltip(AccessoriesExperimentalScreen.createToggleTooltip(type, true, newValue));
        }).renderer(ComponentUtils.getButtonRenderer()).tooltip(AccessoriesExperimentalScreen.createToggleTooltip(type, true, getter.get())).id(type).horizontalSizing(Sizing.fixed((int)74)));
    }

    @Override
    public void onHolderChange(String key) {
        switch (key) {
            case "unused_slots": {
                this.updateToggleButton("unused_slots", this::showUnusedSlots, () -> {
                    ((AccessoriesExperimentalMenu)this.getMenu()).updateUsedSlots();
                    Accessories.config().screenOptions.showUnusedSlots(this.showUnusedSlots());
                    this.rebuildAccessoriesComponent();
                });
                break;
            }
            case "group_filter": {
                this.updateToggleButton("group_filter", this::showGroupFilters, this::rebuildAccessoriesComponent);
                break;
            }
            case "main_widget_position": {
                this.updateToggleButton("main_widget_position", this::mainWidgetPosition, () -> {
                    this.rebuildAccessoriesComponent();
                    this.swapOrCreateSideBarComponent();
                });
                break;
            }
            case "side_widget_position": {
                this.updateToggleButton("side_widget_position", this::sideWidgetPosition, this::swapOrCreateSideBarComponent);
            }
        }
    }

    private void updateToggleButton(String baseId, Supplier<Boolean> getter, Runnable runnable) {
        ButtonComponent btn = (ButtonComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(ButtonComponent.class, baseId);
        Boolean value = getter.get();
        btn.setMessage(AccessoriesExperimentalScreen.createToggleTooltip(baseId, false, value));
        btn.tooltip(AccessoriesExperimentalScreen.createToggleTooltip(baseId, true, value));
        runnable.run();
    }

    private void updateWidgetTypeToggleButton() {
        ButtonComponent btn = (ButtonComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(ButtonComponent.class, "widget_type_toggle");
        int value = this.widgetType();
        btn.setMessage(AccessoriesExperimentalScreen.widgetTypeToggleMessage(value, false));
        btn.tooltip(AccessoriesExperimentalScreen.widgetTypeToggleMessage(value, true));
        this.rebuildAccessoriesComponent();
    }

    private static Component widgetTypeToggleMessage(int value, boolean isTooltip) {
        String type = value == 2 ? "scrollable" : "paginated";
        return Accessories.translation("widget_type." + type + (isTooltip ? ".tooltip" : ""));
    }

    private static Component createToggleTooltip(String type, boolean isTooltip, boolean value) {
        return Accessories.translation(type + ".toggle." + (value ? "enabled" : "disabled") + (isTooltip ? ".tooltip" : ""));
    }

    public ExtendedSlotComponent slotAsComponent(int index) {
        return new ExtendedSlotComponent(this, index);
    }

    private static boolean renderSlotTexture(GuiGraphics context, Slot slot, ItemStack itemStack) {
        Pair pair;
        if (itemStack.isEmpty() && (pair = slot.getNoItemIcon()) != null) {
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            context.blit(slot.x, slot.y, 0, 16, 16, textureAtlasSprite);
            return true;
        }
        return false;
    }

    @Nullable
    private @Nullable Triplet<ItemStack, Boolean, @Nullable String> getRenderStack(Slot slot) {
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)((Object)this);
        ItemStack itemStack = slot.getItem();
        boolean bl = false;
        ItemStack itemStack2 = ((AccessoriesExperimentalMenu)this.menu).getCarried();
        String string = null;
        if (slot == accessor.accessories$getClickedSlot() && !accessor.accessories$getDraggingItem().isEmpty() && accessor.accessories$isSplittingStack() && !itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(itemStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return null;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemStack2, (boolean)true) && ((AccessoriesExperimentalMenu)this.menu).canDragTo(slot)) {
                bl = true;
                int maxSlotStackSize = Math.min(itemStack2.getMaxStackSize(), slot.getMaxStackSize(itemStack2));
                int currentSlotStackSize = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int newStackSize = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)accessor.accessories$getQuickCraftingType(), (ItemStack)itemStack2) + currentSlotStackSize;
                if (newStackSize > maxSlotStackSize) {
                    newStackSize = maxSlotStackSize;
                    string = ChatFormatting.YELLOW.toString() + maxSlotStackSize;
                }
                itemStack = itemStack2.copyWithCount(newStackSize);
            } else {
                this.quickCraftSlots.remove(slot);
                accessor.accessories$recalculateQuickCraftRemaining();
            }
        }
        return new Triplet((Object)itemStack, (Object)bl, string);
    }

    private <T> T getHolderValue(Function<AccessoriesHolder, T> getter, T defaultValue, String valueType) {
        return (T)Optional.ofNullable(AccessoriesHolder.get((LivingEntity)((AccessoriesExperimentalMenu)this.menu).owner())).map(getter).orElseGet(() -> {
            LOGGER.warn("[AccessoriesScreen] Unable to get the given holder value '{}' for the given owner: {}", (Object)valueType, (Object)((AccessoriesExperimentalMenu)this.menu).owner().getName());
            return defaultValue;
        });
    }

    private <T> void setHolderValue(BiFunction<AccessoriesHolder, T, AccessoriesHolder> setter, T value, String valueType) {
        AccessoriesHolder holder = AccessoriesHolder.get((LivingEntity)((AccessoriesExperimentalMenu)this.menu).owner());
        if (holder == null) {
            LOGGER.warn("[AccessoriesScreen] Unable to set the given holder value '{}' for the given owner: {}", (Object)valueType, (Object)((AccessoriesExperimentalMenu)this.menu).owner().getName());
            return;
        }
        setter.apply(holder, (AccessoriesHolder)value);
    }

    private int widgetType() {
        return this.getHolderValue(AccessoriesHolder::widgetType, 1, "widgetType");
    }

    private void widgetType(int type) {
        this.setHolderValue(AccessoriesHolder::widgetType, type, "widgetType");
    }

    private int columnAmount() {
        return this.getHolderValue(AccessoriesHolder::columnAmount, 1, "columnAmount");
    }

    private void columnAmount(int type) {
        this.setHolderValue(AccessoriesHolder::columnAmount, type, "columnAmount");
    }

    public boolean mainWidgetPosition() {
        return this.getHolderValue(AccessoriesHolder::mainWidgetPosition, false, "mainWidgetPosition");
    }

    private void mainWidgetPosition(boolean value) {
        this.setHolderValue(AccessoriesHolder::mainWidgetPosition, value, "mainWidgetPosition");
    }

    public boolean showGroupFilters() {
        return this.getHolderValue(AccessoriesHolder::showGroupFilter, false, "showGroupFilter");
    }

    private void showGroupFilters(boolean value) {
        this.setHolderValue(AccessoriesHolder::showGroupFilter, value, "showGroupFilter");
    }

    public boolean isGroupFiltersOpen() {
        return this.getHolderValue(AccessoriesHolder::isGroupFiltersOpen, false, "isGroupFiltersOpen");
    }

    private void isGroupFiltersOpen(boolean value) {
        this.setHolderValue(AccessoriesHolder::isGroupFiltersOpen, value, "isGroupFiltersOpen");
    }

    private boolean showUnusedSlots() {
        return this.getHolderValue(AccessoriesHolder::showUnusedSlots, false, "showUnusedSlots");
    }

    private void showUnusedSlots(boolean value) {
        this.setHolderValue(AccessoriesHolder::showUnusedSlots, value, "showUnusedSlots");
    }

    private boolean showAdvancedOptions() {
        return this.getHolderValue(AccessoriesHolder::showAdvancedOptions, false, "showAdvancedOptions");
    }

    private void showAdvancedOptions(boolean value) {
        this.setHolderValue(AccessoriesHolder::showAdvancedOptions, value, "showAdvancedOptions");
    }

    private boolean sideWidgetPosition() {
        return this.getHolderValue(AccessoriesHolder::sideWidgetPosition, false, "sideWidgetPosition");
    }

    private void sideWidgetPosition(boolean value) {
        this.setHolderValue(AccessoriesHolder::sideWidgetPosition, value, "sideWidgetPosition");
    }

    public boolean showCraftingGrid() {
        return this.getHolderValue(AccessoriesHolder::showCraftingGrid, false, "showCraftingGrid");
    }

    public void showCraftingGrid(boolean value) {
        this.setHolderValue(AccessoriesHolder::showCraftingGrid, value, "showCraftingGrid");
    }

    public static void safeBatching(OwoUIDrawContext context, Consumer<MutableBoolean> drawCallback) {
        context.recordQuads();
        MutableBoolean hasDrawCallOccur = new MutableBoolean(false);
        drawCallback.accept(hasDrawCallOccur);
        try {
            if (hasDrawCallOccur.booleanValue()) {
                context.submitQuads();
            }
        }
        catch (Exception e) {
            String string = "this is for debugging only really!";
        }
    }

    public class ExtendedSlotComponent
    extends BaseOwoHandledScreen.SlotComponent {
        private boolean isBatched;
        protected final AccessoriesExperimentalScreen screen;
        protected int index;

        protected ExtendedSlotComponent(AccessoriesExperimentalScreen screen, int index) {
            super((BaseOwoHandledScreen)AccessoriesExperimentalScreen.this, index);
            this.isBatched = false;
            this.screen = screen;
            this.index = index;
            this.didDraw = true;
            Slot slot = this.slot();
            if (slot instanceof AccessoriesBasedSlot) {
                AccessoriesBasedSlot accessoriesBasedSlot = (AccessoriesBasedSlot)slot;
                this.tooltip(accessoriesBasedSlot.getTooltipData());
            }
        }

        public final Slot slot() {
            return this.slot;
        }

        public final boolean isBatched() {
            return this.isBatched;
        }

        public ExtendedSlotComponent isBatched(boolean value) {
            this.isBatched = value;
            return this;
        }

        public void dismount(Component.DismountReason reason) {
            super.dismount(reason);
            if (reason == Component.DismountReason.REMOVED) {
                this.screen.hideSlot(this.slot);
            }
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (!(this.slot() instanceof SlotTypeAccessible)) {
                super.draw(context, mouseX, mouseY, partialTicks, delta);
                return;
            }
            this.didDraw = true;
            if (this.isBatched) {
                return;
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            this.renderSlot(context);
            this.renderCosmeticOverlay(context, false);
            this.renderHover(context, () -> this.screen.hoveredSlot);
        }

        public void renderSlot(OwoUIDrawContext context) {
            int i = this.screen.leftPos;
            int j = this.screen.topPos;
            context.push();
            context.translate((float)i, (float)j, 0.0f);
            this.screen.forceRenderSlot((GuiGraphics)context, this.slot());
            context.pop();
        }

        public void renderCosmeticOverlay(OwoUIDrawContext context, boolean externalBatching) {
            SlotTypeAccessible slotTypeAccessible;
            Slot slot = this.slot();
            if (!(slot instanceof SlotTypeAccessible) || !(slotTypeAccessible = (SlotTypeAccessible)slot).isCosmeticSlot()) {
                return;
            }
            context.push();
            context.translate(0.0f, 0.0f, 101.0f);
            if (externalBatching) {
                GuiGraphicsUtils.drawRectOutlineWithSpectrumWithoutRecord(context, this.x(), this.y(), 0, 16, 16, 0.35f, true);
            } else {
                GuiGraphicsUtils.drawRectOutlineWithSpectrum(context, this.x(), this.y(), 0, 16, 16, 0.35f, true);
            }
            context.pop();
        }

        public void renderHover(OwoUIDrawContext context, Supplier<Slot> hoverSlot) {
            Slot hoveredSlot = hoverSlot.get();
            if (this.slot.equals(hoveredSlot) && hoveredSlot.isHighlightable()) {
                context.push();
                context.fillGradient(RenderType.gui(), this.x(), this.y(), this.x() + 16, this.y() + 16, -2130706433, -2130706433, 330);
                context.pop();
            }
        }

        public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            RenderSystem.enableDepthTest();
            context.push().translate(0.0f, 0.0f, 300.0f);
            AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(AccessoriesExperimentalScreen.this.mainWidgetPosition());
            super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
            AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
            context.pop();
        }
    }
}

