/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.client.gui.CookingPotTooltip;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;

public class CookingPotItem
extends BlockItem {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public CookingPotItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return CookingPotItem.getServingCount(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.min(1 + 12 * CookingPotItem.getServingCount(stack) / 64, 13);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ItemStack mealStack = CookingPotBlockEntity.getMealFromItem(stack);
        return Optional.of(new CookingPotTooltip.CookingPotTooltipComponent(mealStack));
    }

    private static int getServingCount(ItemStack stack) {
        ItemStack mealStack = CookingPotBlockEntity.getMealFromItem(stack);
        return mealStack.getCount();
    }
}

