/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.gui;

import com.anthonyhilyard.equipmentcompare.EquipmentCompare;
import com.anthonyhilyard.equipmentcompare.config.EquipmentCompareConfig;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.ItemUtil;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joml.Matrix4f;

public class ComparisonTooltips {
    public static MutableComponent getEquippedBadge() {
        MutableComponent equippedBadge = EquipmentCompareConfig.getInstance().overrideBadgeText.get() != false ? Component.translatable((String)EquipmentCompareConfig.getInstance().badgeText.get()) : Component.translatable((String)"equipmentcompare.general.badgeText");
        return equippedBadge;
    }

    private static void drawTooltip(GuiGraphics graphics, ClientTooltipPositioner positioner, ItemStack itemStack, Rect2i rect, List<ClientTooltipComponent> tooltipLines, Font font, Screen screen, int maxWidth, boolean showBadge, int index) {
        boolean legendaryTooltipsPresent = Services.getPlatformHelper().isModLoaded("legendarytooltips");
        if (showBadge && legendaryTooltipsPresent) {
            rect.setHeight(rect.getHeight() + 11);
        }
        Tooltips.renderItemTooltip((ItemStack)itemStack, (Font)font, tooltipLines, (Rect2i)rect, (GuiGraphics)graphics, (ClientTooltipPositioner)positioner, (boolean)showBadge, (int)index);
        if (showBadge && !legendaryTooltipsPresent) {
            int bgColor = EquipmentCompareConfig.getInstance().badgeBackgroundColor.get().intValue();
            int borderStartColor = EquipmentCompareConfig.getInstance().badgeBorderStartColor.get().intValue();
            int borderEndColor = EquipmentCompareConfig.getInstance().badgeBorderEndColor.get().intValue();
            Style textColor = Style.EMPTY.withColor(TextColor.fromRgb((int)EquipmentCompareConfig.getInstance().badgeTextColor.get().intValue()));
            MutableComponent equippedBadge = ComparisonTooltips.getEquippedBadge().withStyle(textColor);
            PoseStack poseStack = graphics.pose();
            if (rect.getY() + rect.getHeight() + 4 > screen.height) {
                rect = new Rect2i(rect.getX(), screen.height - rect.getHeight() - 4, rect.getWidth(), rect.getHeight());
            }
            poseStack.pushPose();
            poseStack.translate((float)(rect.getX() - 2), (float)(rect.getY() - 4), 411.0f);
            Matrix4f matrix = poseStack.last().pose();
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)-17, (int)(rect.getWidth() + 7), (int)-16, (int)bgColor, (int)bgColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)0, (int)-16, (int)1, (int)-4, (int)bgColor, (int)bgColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.getWidth() + 7), (int)-16, (int)(rect.getWidth() + 8), (int)-4, (int)bgColor, (int)bgColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)-4, (int)(rect.getWidth() + 7), (int)-3, (int)bgColor, (int)bgColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)-16, (int)(rect.getWidth() + 7), (int)-4, (int)bgColor, (int)bgColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)-15, (int)2, (int)-5, (int)borderStartColor, (int)borderEndColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(rect.getWidth() + 6), (int)-15, (int)(rect.getWidth() + 7), (int)-5, (int)borderStartColor, (int)borderEndColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)-16, (int)(rect.getWidth() + 7), (int)-15, (int)borderStartColor, (int)borderStartColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)1, (int)-5, (int)(rect.getWidth() + 7), (int)-4, (int)borderEndColor, (int)borderEndColor);
            graphics.drawCenteredString(font, (Component)equippedBadge, rect.getWidth() / 2 + 4, -14, -1);
            poseStack.popPose();
        }
    }

    public static boolean render(GuiGraphics graphics, ClientTooltipPositioner positioner, int x, int y, ItemStack itemStack, Minecraft minecraft, Font font, Screen screen) {
        if (screen == null || minecraft == null || minecraft.player == null || minecraft.player.containerMenu == null || minecraft.level == null || itemStack == null) {
            return false;
        }
        if (minecraft.player.containerMenu.getCarried().isEmpty() && !itemStack.isEmpty() && !EquipmentCompareConfig.isItemBlacklisted(itemStack, (HolderLookup.Provider)minecraft.level.registryAccess())) {
            EquipmentSlot slot = ItemUtil.getEquipmentSlot((ItemStack)itemStack);
            List equippedItems = new ArrayList<ItemStack>();
            ItemStack equippedItem = minecraft.player.getItemBySlot(slot);
            boolean checkItem = true;
            if (slot == EquipmentSlot.MAINHAND) {
                if (!itemStack.isDamageableItem() || !equippedItem.isDamageableItem()) {
                    checkItem = false;
                } else if (EquipmentCompareConfig.getInstance().strict.get().booleanValue() && !itemStack.getItem().getClass().equals(equippedItem.getItem().getClass())) {
                    checkItem = false;
                }
            }
            if (checkItem) {
                equippedItems.add(equippedItem);
                equippedItems.remove(ItemStack.EMPTY);
                equippedItems.remove(itemStack);
            }
            if (EquipmentCompareConfig.getInstance().compareAccessories.get().booleanValue()) {
                if (Services.getPlatformHelper().isModLoaded("trinkets")) {
                    try {
                        equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.compat.TrinketsHandler").getMethod("getTrinketsMatchingSlot", LivingEntity.class, ItemStack.class).invoke(null, minecraft.player, itemStack));
                    }
                    catch (Exception e) {
                        EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                if (Services.getPlatformHelper().isModLoaded("curios") && Services.getPlatformHelper().getPlatformName().contentEquals("NeoForge")) {
                    try {
                        equippedItems.addAll((List)Class.forName("com.anthonyhilyard.equipmentcompare.neoforge.compat.CuriosHandler").getMethod("getCuriosMatchingSlot", LivingEntity.class, ItemStack.class).invoke(null, minecraft.player, itemStack));
                    }
                    catch (Exception e) {
                        EquipmentCompare.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
            equippedItems.removeIf(stack -> EquipmentCompareConfig.isItemBlacklisted(stack, (HolderLookup.Provider)minecraft.level.registryAccess()));
            equippedItems.remove(itemStack);
            if (equippedItems.size() > EquipmentCompareConfig.getInstance().maxComparisons.get()) {
                equippedItems = equippedItems.subList(0, EquipmentCompareConfig.getInstance().maxComparisons.get());
            }
            if (equippedItems.size() > EquipmentCompareConfig.getInstance().maxComparisons.get()) {
                equippedItems = equippedItems.subList(0, EquipmentCompareConfig.getInstance().maxComparisons.get());
            }
            if (!equippedItems.isEmpty() && EquipmentCompare.comparisonsActive ^ EquipmentCompareConfig.getInstance().defaultOn.get()) {
                List itemStackTooltipLines;
                Rect2i itemStackRect;
                int maxWidth = (screen.width - equippedItems.size() * 16) / (equippedItems.size() + 1);
                Font itemFont = Services.getFontLookup().getTooltipFont(itemStack, screen);
                if (itemFont == null) {
                    itemFont = font;
                }
                itemStackRect = x + (itemStackRect = Tooltips.calculateRect((ItemStack)itemStack, (GuiGraphics)graphics, (ClientTooltipPositioner)positioner, (List)(itemStackTooltipLines = Tooltips.gatherTooltipComponents((ItemStack)itemStack, (List)Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)itemStack), (Optional)itemStack.getTooltipImage(), (int)x, (int)screen.width, (int)screen.height, (Font)itemFont, (Font)font, (int)maxWidth, (int)0)), (int)x, (int)y, (Font)itemFont)).getWidth() + 12 > screen.width ? new Rect2i(screen.width - itemStackRect.getWidth() - 24, itemStackRect.getY(), itemStackRect.getWidth(), itemStackRect.getHeight()) : new Rect2i(itemStackRect.getX() - 2, itemStackRect.getY(), itemStackRect.getWidth(), itemStackRect.getHeight());
                HashMap<ItemStack, Rect2i> tooltipRects = new HashMap<ItemStack, Rect2i>();
                HashMap<ItemStack, List> tooltipLines = new HashMap<ItemStack, List>();
                Rect2i previousRect = itemStackRect;
                boolean firstRect = true;
                int tooltipIndex = 1;
                for (ItemStack thisItem : equippedItems) {
                    if (Services.getFontLookup().getTooltipFont(thisItem, screen) != null) {
                        itemFont = Services.getFontLookup().getTooltipFont(thisItem, screen);
                    }
                    int tooltipY = y;
                    if (Services.getPlatformHelper().isModLoaded("legendarytooltips")) {
                        tooltipY -= 11;
                    }
                    List equippedTooltipLines = Tooltips.gatherTooltipComponents((ItemStack)thisItem, (List)Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)thisItem), (Optional)thisItem.getTooltipImage(), (int)(previousRect.getX() - 8), (int)screen.width, (int)screen.height, (Font)itemFont, (Font)font, (int)maxWidth, (int)tooltipIndex++);
                    Rect2i equippedRect = Tooltips.calculateRect((ItemStack)itemStack, (GuiGraphics)graphics, (ClientTooltipPositioner)positioner, (List)equippedTooltipLines, (int)(previousRect.getX() - 8), (int)tooltipY, (Font)itemFont);
                    if (firstRect) {
                        equippedRect = new Rect2i(previousRect.getX() - equippedRect.getWidth() - 20, equippedRect.getY(), equippedRect.getWidth(), equippedRect.getHeight());
                        firstRect = false;
                    } else {
                        equippedRect = new Rect2i(previousRect.getX() - equippedRect.getWidth() - 16, equippedRect.getY(), equippedRect.getWidth(), equippedRect.getHeight());
                    }
                    tooltipRects.put(thisItem, equippedRect);
                    tooltipLines.put(thisItem, equippedTooltipLines);
                    previousRect = equippedRect;
                }
                int xOffset = ((Rect2i)tooltipRects.get(equippedItems.get(equippedItems.size() - 1))).getX();
                if (xOffset < 0) {
                    for (ItemStack thisItem : equippedItems) {
                        Rect2i equippedRect = (Rect2i)tooltipRects.get(thisItem);
                        tooltipRects.replace(thisItem, new Rect2i(equippedRect.getX() - xOffset, equippedRect.getY(), equippedRect.getWidth(), equippedRect.getHeight()));
                    }
                    itemStackRect = new Rect2i(itemStackRect.getX() - xOffset, itemStackRect.getY(), itemStackRect.getWidth(), itemStackRect.getHeight());
                }
                tooltipIndex = 1;
                for (ItemStack thisItem : equippedItems) {
                    ComparisonTooltips.drawTooltip(graphics, positioner, thisItem, (Rect2i)tooltipRects.get(thisItem), (List)tooltipLines.get(thisItem), font, screen, maxWidth, true, tooltipIndex++);
                }
                ComparisonTooltips.drawTooltip(graphics, positioner, itemStack, itemStackRect, itemStackTooltipLines, font, screen, maxWidth, false, 0);
                return true;
            }
            return false;
        }
        return false;
    }
}

