/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.world.level.levelgen.structure.crater;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.enhancedcelestials.world.level.levelgen.structure.ECStructureTypes;
import dev.corgitaco.enhancedcelestials.world.level.levelgen.structure.crater.CraterPiece;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class CraterStructure
extends Structure {
    public static final MapCodec<CraterStructure> CODEC = RecordCodecBuilder.mapCodec(archStructureInstance -> archStructureInstance.group((App)CraterStructure.settingsCodec((RecordCodecBuilder.Instance)archStructureInstance)).apply((Applicative)archStructureInstance, CraterStructure::new));

    public CraterStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context) {
        double baseRadiusX;
        WorldgenRandom random = context.random();
        int seed = random.nextInt();
        ChunkPos chunkPos = context.chunkPos();
        int blockX = chunkPos.getBlockX(random.nextInt(16));
        int blockZ = chunkPos.getBlockZ(random.nextInt(16));
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        RandomState randomState = context.randomState();
        int baseHeight = chunkGenerator.getBaseHeight(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), randomState);
        BlockPos origin = new BlockPos(blockX, baseHeight, blockZ);
        double baseRadiusZ = baseRadiusX = 128.0;
        double threshold = 1.0;
        int coneSizePackedX = SectionPos.blockToSectionCoord((double)baseRadiusX) + 1;
        int coneSizePackedZ = SectionPos.blockToSectionCoord((double)baseRadiusZ) + 1;
        ArrayList<CraterPiece> craterPieceList = new ArrayList<CraterPiece>();
        for (int x = -coneSizePackedX; x <= coneSizePackedX; ++x) {
            for (int z = -coneSizePackedZ; z <= coneSizePackedZ; ++z) {
                int chunkX = SectionPos.blockToSectionCoord((int)blockX) + x;
                int chunkZ = SectionPos.blockToSectionCoord((int)blockZ) + z;
                long chunk = ChunkPos.asLong((int)chunkX, (int)chunkZ);
                if (!CraterStructure.isCraterSafe(chunkX, chunkZ, chunkGenerator, biomeHolder -> !biomeHolder.is(BiomeTags.IS_OCEAN) && !biomeHolder.is(BiomeTags.IS_RIVER), randomState)) {
                    return;
                }
                craterPieceList.add(new CraterPiece(new PieceStructureInfo(origin, seed, baseRadiusX, baseRadiusZ, threshold), 0, CraterStructure.getWritableArea(new ChunkPos(chunk), context.heightAccessor())));
            }
        }
        craterPieceList.forEach(arg_0 -> ((StructurePiecesBuilder)piecesBuilder).addPiece(arg_0));
    }

    public static BoundingBox getWritableArea(ChunkPos chunkPos, LevelHeightAccessor accessor) {
        int i = chunkPos.getMinBlockX();
        int j = chunkPos.getMinBlockZ();
        int k = accessor.getMinBuildHeight() + 1;
        int l = accessor.getMaxBuildHeight() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public static boolean isCraterSafe(int sectionX, int sectionZ, ChunkGenerator generator, Predicate<Holder<Biome>> isBiome, RandomState randomState) {
        for (int xOffset = 0; xOffset < 4; ++xOffset) {
            for (int zOffset = 0; zOffset < 4; ++zOffset) {
                int quartX = QuartPos.fromBlock((int)SectionPos.sectionToBlockCoord((int)sectionX)) + xOffset;
                int quartY = QuartPos.fromBlock((int)generator.getSeaLevel());
                int quartZ = QuartPos.fromBlock((int)SectionPos.sectionToBlockCoord((int)sectionZ)) + zOffset;
                if (isBiome.test((Holder<Biome>)generator.getBiomeSource().getNoiseBiome(quartX, quartY, quartZ, randomState.sampler()))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchesBiome(BlockPos pos, ChunkGenerator generator, Predicate<Holder<Biome>> isBiome, RandomState randomState) {
        return isBiome.test((Holder<Biome>)generator.getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)pos.getX()), QuartPos.fromBlock((int)pos.getY()), QuartPos.fromBlock((int)pos.getZ()), randomState.sampler()));
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext generationContext) {
        return CraterStructure.onTopOfChunkCenter((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> CraterStructure.generatePieces(piecesBuilder, generationContext));
    }

    public StructureType<?> type() {
        return ECStructureTypes.CRATER.get();
    }

    static {
        String string = "";
    }

    public record PieceStructureInfo(BlockPos origin, int noiseSeed, double baseRadiusX, double baseRadiusZ, double threshold) {
        public static final Codec<PieceStructureInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("origin").forGetter(PieceStructureInfo::origin), (App)Codec.INT.fieldOf("noiseSeed").forGetter(PieceStructureInfo::noiseSeed), (App)Codec.DOUBLE.fieldOf("baseRadiusX").forGetter(PieceStructureInfo::baseRadiusX), (App)Codec.DOUBLE.fieldOf("baseRadiusZ").forGetter(PieceStructureInfo::baseRadiusZ), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(PieceStructureInfo::threshold)).apply((Applicative)builder, PieceStructureInfo::new));
    }
}

