/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public class SetLunarEventCommand {
    private static final DynamicCommandExceptionType ERROR_LUNAR_EVENT_INVALID = new DynamicCommandExceptionType(obj -> Component.translatable((String)"enhancedcelestials.commands.setlunarevent.invalid", (Object[])new Object[]{obj}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.literal((String)"setLunarEvent").then(Commands.argument((String)"lunarEvent", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY)).executes(cs -> SetLunarEventCommand.setLunarEvent((CommandSourceStack)cs.getSource(), (ResourceOrTagKeyArgument.Result<LunarEvent>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)cs, (String)"lunarEvent", EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (DynamicCommandExceptionType)ERROR_LUNAR_EVENT_INVALID))));
    }

    public static int setLunarEvent(CommandSourceStack source, ResourceOrTagKeyArgument.Result<LunarEvent> lunarEventResult) {
        ServerLevel world = source.getLevel();
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)world);
        if (lunarForecastWorldData.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"enhancedcelestials.commands.disabled"));
            return 0;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        if (world.isRaining() && data.getDimensionSettings().requiresClearSkies()) {
            source.sendFailure((Component)Component.literal((String)"Lunar events can only be started during clear skies!"));
            return 0;
        }
        Either unwrap = lunarEventResult.unwrap();
        if (unwrap.left().isPresent()) {
            ResourceKey lunarEventResourceKey = (ResourceKey)unwrap.left().orElseThrow();
            Registry lunarEvents = (Registry)world.registryAccess().registry(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
            if (lunarEvents.containsKey(lunarEventResourceKey) && lunarEvents.getHolderOrThrow(lunarEventResourceKey).isBound()) {
                data.setLunarEvent((ResourceKey<LunarEvent>)lunarEventResourceKey);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)"Invalid lunar event \"%s\"!".formatted(lunarEventResourceKey.location())));
            return 0;
        }
        if (unwrap.right().isPresent()) {
            Optional possibleTag = ((Registry)world.registryAccess().registry(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow()).getTag((TagKey)unwrap.right().orElseThrow());
            if (possibleTag.isPresent()) {
                HolderSet.Named possibleLunarEvents = (HolderSet.Named)possibleTag.orElseThrow();
                Optional randomLunarEvent = possibleLunarEvents.getRandomElement(world.random);
                if (randomLunarEvent.isPresent()) {
                    source.getServer().submit(() -> data.setLunarEvent((ResourceKey<LunarEvent>)((ResourceKey)((Holder)randomLunarEvent.orElseThrow()).unwrapKey().orElseThrow())));
                    return 1;
                }
                source.sendFailure((Component)Component.literal((String)"Invalid lunar event tag \"%s\"!".formatted(possibleLunarEvents.key().location())));
                return 0;
            }
            source.sendFailure((Component)Component.literal((String)"Invalid lunar event tag."));
            return 0;
        }
        source.sendFailure((Component)Component.literal((String)"Could not start Lunar Event..."));
        return 0;
    }
}

