/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.mixin;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarMobSpawnInfo;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class MixinWorldEntitySpawner {
    @Inject(method={"mobsAt(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Holder;)Lnet/minecraft/util/random/WeightedRandomList;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void useLunarSpawner(ServerLevel world, StructureManager $$1, ChunkGenerator $$2, MobCategory classification, BlockPos $$4, Holder<Biome> $$5, CallbackInfoReturnable<WeightedRandomList<MobSpawnSettings.SpawnerData>> cir) {
        EnhancedCelestials.lunarForecastWorldData((Level)world).ifPresent(data -> {
            LunarMobSpawnInfo lunarSpawner = data.currentLunarEvent().getLunarSpawner();
            if (lunarSpawner != null) {
                MobSpawnSettings mobSpawnInfo = lunarSpawner.spawnInfo();
                if (lunarSpawner.useBiomeSpawnSettings()) {
                    ArrayList unwrap = new ArrayList(mobSpawnInfo.getMobs(classification).unwrap());
                    unwrap.addAll(((WeightedRandomList)cir.getReturnValue()).unwrap());
                    cir.setReturnValue((Object)WeightedRandomList.create(unwrap));
                } else {
                    cir.setReturnValue((Object)mobSpawnInfo.getMobs(classification));
                }
            }
        });
    }

    @Inject(method={"getRoughBiome(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/ChunkAccess;)Lnet/minecraft/world/level/biome/Biome;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void useLunarSpawner(BlockPos pos, ChunkAccess chunk, CallbackInfoReturnable<Biome> cir) {
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            Level world = levelChunk.getLevel();
            EnhancedCelestials.lunarForecastWorldData(world).ifPresent(data -> {
                LunarMobSpawnInfo lunarSpawner = data.currentLunarEvent().getLunarSpawner();
                if (lunarSpawner != null) {
                    MobSpawnSettings lunarMobSpawnInfo = lunarSpawner.spawnInfo();
                    Biome.BiomeBuilder fakeBiome = new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(1).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build());
                    if (lunarSpawner.useBiomeSpawnSettings()) {
                        MobSpawnSettings biomeMobSpawnInfo = ((Biome)cir.getReturnValue()).getMobSettings();
                        EnumMap mergedSpawnersMap = new EnumMap(biomeMobSpawnInfo.spawners);
                        mergedSpawnersMap.putAll(lunarMobSpawnInfo.spawners);
                        IdentityHashMap mergedSpawnCosts = new IdentityHashMap(biomeMobSpawnInfo.mobSpawnCosts);
                        mergedSpawnCosts.putAll(lunarMobSpawnInfo.mobSpawnCosts);
                        MobSpawnSettings mobSpawnInfo = new MobSpawnSettings(Math.max(lunarMobSpawnInfo.getCreatureProbability(), biomeMobSpawnInfo.getCreatureProbability()), mergedSpawnersMap, mergedSpawnCosts);
                        fakeBiome.mobSpawnSettings(mobSpawnInfo);
                    } else {
                        fakeBiome.mobSpawnSettings(lunarMobSpawnInfo);
                    }
                    fakeBiome.generationSettings(BiomeGenerationSettings.EMPTY);
                    cir.setReturnValue((Object)fakeBiome.build());
                }
            });
        }
    }

    @Inject(method={"getRandomPosWithin(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/chunk/LevelChunk;)Lnet/minecraft/core/BlockPos;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void forceSurface(Level world, LevelChunk chunk, CallbackInfoReturnable<BlockPos> cir) {
        EnhancedCelestials.lunarForecastWorldData(world).ifPresent(data -> {
            BlockPos closestPlayerPosition;
            BlockPos returnValue;
            Player closestPlayer;
            LunarMobSpawnInfo lunarSpawner = data.currentLunarEvent().getLunarSpawner();
            if (lunarSpawner != null && lunarSpawner.forceSurfaceSpawning() && (closestPlayer = world.getNearestPlayer((double)(returnValue = (BlockPos)cir.getReturnValue()).getX(), (double)returnValue.getY(), (double)returnValue.getZ(), -1.0, false)) != null && (closestPlayerPosition = closestPlayer.blockPosition()).getY() > world.getHeight(Heightmap.Types.WORLD_SURFACE, closestPlayerPosition.getX(), closestPlayerPosition.getZ())) {
                cir.setReturnValue((Object)new BlockPos(returnValue.getX(), world.getHeight(Heightmap.Types.WORLD_SURFACE, returnValue.getX(), returnValue.getZ()) + 1, returnValue.getZ()));
            }
        });
    }
}

