/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.mixin;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slime.class})
public class MixinSlimeEntity {
    @Inject(method={"checkSlimeSpawnRules(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void allowSlimeSpawnsAnywhere(EntityType<Slime> slimeEntityType, LevelAccessor accessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource, CallbackInfoReturnable<Boolean> cir) {
        if (accessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessor;
            EnhancedCelestials.lunarForecastWorldData((Level)serverLevel).ifPresent(data -> {
                boolean aboveY;
                boolean slimesSpawnEverywhere = data.currentLunarEvent().getLunarMobSettings().lunarMobSpawnInfo().slimesSpawnEverywhere();
                boolean bl = aboveY = pos.getY() > 50 && pos.getY() >= accessor.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()) - 1;
                if (slimesSpawnEverywhere && aboveY && randomSource.nextFloat() < 0.5f && randomSource.nextFloat() < accessor.getMoonBrightness() && accessor.getMaxLocalRawBrightness(pos) <= randomSource.nextInt(8)) {
                    cir.setReturnValue((Object)Mob.checkMobSpawnRules((EntityType)slimeEntityType, (LevelAccessor)accessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomSource));
                }
            });
        }
    }
}

