/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.entity;

import com.google.common.annotations.VisibleForTesting;
import dev.corgitaco.enhancedcelestials.core.ECEntities;
import dev.corgitaco.enhancedcelestials.entity.MeteorEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MeteorStrikeEntity
extends Entity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(MeteorStrikeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> READY = SynchedEntityData.defineId(MeteorStrikeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int life;

    public MeteorStrikeEntity(EntityType<? extends MeteorStrikeEntity> $$0, Level level) {
        super($$0, level);
    }

    public MeteorStrikeEntity(Level level, Vec3 position, @Nullable Entity spawner) {
        super(ECEntities.METEOR_STRIKE.get(), level);
        this.setPos(position);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIZE, (Object)Float.valueOf(1.0f));
        builder.define(READY, (Object)true);
    }

    public void tick() {
        super.tick();
        Vec3 position = this.position();
        if (!this.level().isClientSide && this.isReady()) {
            if ((double)this.level().random.nextFloat() < 0.01) {
                float angle = this.level().random.nextFloat() * ((float)Math.PI * 2);
                float addedDistance = Mth.nextFloat((RandomSource)this.random, (float)2.0f, (float)(this.getBbWidth() / 2.0f));
                double addX = Mth.sin((float)angle) * addedDistance;
                double addZ = Mth.cos((float)angle) * addedDistance;
                Vec3 meteorSpawnPos = position.add(addX, (double)Mth.nextInt((RandomSource)this.random, (int)450, (int)500), addZ);
                MeteorEntity meteorEntity = new MeteorEntity(this.level());
                meteorEntity.setPos(meteorSpawnPos);
                meteorEntity.setSize(Mth.nextFloat((RandomSource)this.level().random, (float)0.3f, (float)3.0f));
                meteorEntity.setDeltaMovement(0.0, -0.6, 0.0);
                this.level().addFreshEntity((Entity)meteorEntity);
            }
            if (this.life > 400) {
                this.discard();
            }
            ++this.life;
        }
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.life = compoundTag.getInt("life");
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("life", this.life);
    }

    public boolean isReady() {
        return (Boolean)this.entityData.get(READY);
    }

    public void setReady(boolean ready) {
        this.entityData.set(READY, (Object)ready);
    }

    public float getSize() {
        return Math.max(((Float)this.entityData.get(SIZE)).floatValue(), 1.0f);
    }

    @VisibleForTesting
    public void setSize(float pSize) {
        float i = Mth.clamp((float)pSize, (float)1.0f, (float)127.0f);
        this.entityData.set(SIZE, (Object)Float.valueOf(i));
        this.reapplyPosition();
        this.refreshDimensions();
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return super.getDimensions(pPose).scale(this.getSize() * 0.5f);
    }
}

