/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.entity;

import com.google.common.annotations.VisibleForTesting;
import dev.corgitaco.enhancedcelestials.core.ECEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class MeteorEntity
extends Entity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(MeteorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public MeteorEntity(Level level) {
        this(ECEntities.METEOR.get(), level);
    }

    public MeteorEntity(EntityType<? extends MeteorEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIZE, (Object)Float.valueOf(1.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setSize(compoundTag.getFloat("Size"));
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putFloat("Size", this.getSize());
    }

    public void tick() {
        super.tick();
        Vec3 velocity = this.getDeltaMovement();
        this.setDeltaMovement(velocity.subtract(0.0, 0.3, 0.0));
        this.move(MoverType.SELF, velocity);
        if (!this.level().isClientSide) {
            if (this.onGround() || this.verticalCollision || this.horizontalCollision) {
                this.discard();
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 5.0f, Level.ExplosionInteraction.TNT);
            }
        } else {
            Vec3 reverse = this.getDeltaMovement().multiply(-1.0, -1.0, -1.0);
            float bbWidth = this.getBbWidth() / 2.0f;
            for (float xOffset = -bbWidth; xOffset <= bbWidth; xOffset += 1.0f) {
                for (float zOffset = -bbWidth; zOffset <= bbWidth; zOffset += 1.0f) {
                    for (int i = 0; i < 5; ++i) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + (double)xOffset, this.getY() + Mth.nextDouble((RandomSource)this.random, (double)-0.4, (double)0.4), this.getZ() + (double)zOffset, reverse.x(), reverse.y(), reverse.z());
                    }
                }
            }
        }
    }

    public float getSize() {
        return Math.max(((Float)this.entityData.get(SIZE)).floatValue(), 1.0f);
    }

    @VisibleForTesting
    public void setSize(float pSize) {
        float i = Mth.clamp((float)pSize, (float)1.0f, (float)127.0f);
        this.entityData.set(SIZE, (Object)Float.valueOf(i));
        this.reapplyPosition();
        this.refreshDimensions();
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return super.getDimensions(pPose).scale(this.getSize() * 0.5f);
    }
}

