/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data.type.entity.network;

import dev.corgitaco.dataanchor.DataAnchor;
import dev.corgitaco.dataanchor.data.SyncedTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import dev.corgitaco.dataanchor.data.type.entity.EntityTrackedData;
import dev.corgitaco.dataanchor.network.Packet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record SyncEntityTrackedDataS2C(int id, TrackedDataKey<? extends EntityTrackedData> dataKey, CompoundTag tag) implements Packet
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncEntityTrackedDataS2C> STREAM_CODEC = CustomPacketPayload.codec(SyncEntityTrackedDataS2C::write, SyncEntityTrackedDataS2C::new);
    public static final CustomPacketPayload.Type<SyncEntityTrackedDataS2C> TYPE = new CustomPacketPayload.Type(DataAnchor.id("entity_tracked_data"));

    public SyncEntityTrackedDataS2C(FriendlyByteBuf buf) {
        this(buf.readInt(), TrackedDataKey.fromID(TrackedDataRegistries.ENTITY, buf.readResourceLocation()), buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeResourceLocation(this.dataKey.getId());
        buf.writeNbt((Tag)this.tag);
    }

    @Override
    public void handle(@Nullable Level level, @Nullable Player player) {
        Entity entity = level.getEntity(this.id);
        if (entity instanceof TrackedDataContainer) {
            TrackedDataContainer access = (TrackedDataContainer)entity;
            access.dataAnchor$getTrackedData(this.dataKey).ifPresent(data -> {
                if (data instanceof SyncedTrackedData) {
                    SyncedTrackedData syncedData = (SyncedTrackedData)data;
                    syncedData.readFromNetwork(this.tag);
                }
            });
        } else {
            DataAnchor.LOGGER.warn("Failed to sync entity tracked data {}: Entity {} not found", (Object)this.dataKey.getId().toString(), (Object)this.id);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

