/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data.type.blockentity.network;

import dev.corgitaco.dataanchor.DataAnchor;
import dev.corgitaco.dataanchor.data.SyncedTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import dev.corgitaco.dataanchor.data.type.blockentity.BlockEntityTrackedData;
import dev.corgitaco.dataanchor.network.Packet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public record SyncBlockEntityTrackedDataS2C(BlockPos pos, TrackedDataKey<? extends BlockEntityTrackedData> dataKey, CompoundTag tag) implements Packet
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBlockEntityTrackedDataS2C> STREAM_CODEC = CustomPacketPayload.codec(SyncBlockEntityTrackedDataS2C::write, SyncBlockEntityTrackedDataS2C::new);
    public static final CustomPacketPayload.Type<SyncBlockEntityTrackedDataS2C> TYPE = new CustomPacketPayload.Type(DataAnchor.id("block_entity_tracked_data"));

    public SyncBlockEntityTrackedDataS2C(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), TrackedDataKey.fromID(TrackedDataRegistries.BLOCK_ENTITY, buf.readResourceLocation()), buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeResourceLocation(this.dataKey.getId());
        buf.writeNbt((Tag)this.tag);
    }

    @Override
    public void handle(@Nullable Level level, @Nullable Player player) {
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof TrackedDataContainer) {
            TrackedDataContainer access = (TrackedDataContainer)blockEntity;
            access.dataAnchor$getTrackedData(this.dataKey).ifPresent(data -> {
                if (data instanceof SyncedTrackedData) {
                    SyncedTrackedData syncedData = (SyncedTrackedData)data;
                    syncedData.readFromNetwork(this.tag);
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

