/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics.service;

import com.mojang.logging.LogUtils;
import com.teamresourceful.resourcefulcosmetics.ResourcefulCosmetics;
import com.teamresourceful.resourcefulcosmetics.errors.BadRequestException;
import com.teamresourceful.resourcefulcosmetics.errors.ForbiddenException;
import com.teamresourceful.resourcefulcosmetics.errors.InternalServerException;
import com.teamresourceful.resourcefulcosmetics.errors.NotFoundException;
import com.teamresourceful.resourcefulcosmetics.errors.UnauthorizedException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetic;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.service.StatusCode;

public class CosmeticsApi {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourcefulCosmetics<Cosmetic> API = ResourcefulCosmetics.create((String)"https://creeperoverhaul.thatgravyboat.tech/", Cosmetic::fromJson, error -> LOGGER.error("Failed to load cosmetics", (Throwable)error));

    public static void init() {
    }

    private static CompletableFuture<StatusCode> tryApiCall(TryApiCall runnable) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                runnable.run();
                return StatusCode.OK;
            }
            catch (BadRequestException e) {
                return StatusCode.BAD_REQUEST;
            }
            catch (ForbiddenException e) {
                return StatusCode.FORBIDDEN;
            }
            catch (InternalServerException e) {
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            catch (NotFoundException e) {
                return StatusCode.NOT_FOUND;
            }
            catch (UnauthorizedException e) {
                return StatusCode.UNAUTHORIZED;
            }
            catch (Exception e) {
                LOGGER.error("Failed to call API", (Throwable)e);
                return StatusCode.UNKOWN_ERROR;
            }
        });
    }

    private static UUID getProfileId() {
        return Minecraft.getInstance().getUser().getProfileId();
    }

    public static CompletableFuture<StatusCode> login() {
        return CosmeticsApi.tryApiCall(() -> {
            User user = Minecraft.getInstance().getUser();
            String serverId = UUID.randomUUID().toString();
            Minecraft.getInstance().getMinecraftSessionService().joinServer(user.getProfileId(), user.getAccessToken(), serverId);
            API.login(user.getProfileId(), user.getName(), serverId);
        });
    }

    public static CompletableFuture<StatusCode> getCosmetics() {
        return CosmeticsApi.tryApiCall(() -> API.getCosmetics(CosmeticsApi.getProfileId(), false));
    }

    public static CompletableFuture<StatusCode> setCosmetic(@Nullable Cosmetic cosmetic) {
        return CosmeticsApi.tryApiCall(() -> API.setCosmetic(CosmeticsApi.getProfileId(), (String)Optionull.map((Object)cosmetic, Cosmetic::id)));
    }

    public static CompletableFuture<StatusCode> claimReward(String code) {
        return CosmeticsApi.tryApiCall(() -> API.claimCosmetic(CosmeticsApi.getProfileId(), code));
    }

    public static boolean hasSessionToken() {
        return API.hasSession(Minecraft.getInstance().getUser().getProfileId());
    }

    public static List<String> getAvailableCosmetics() {
        try {
            return API.getCosmetics(CosmeticsApi.getProfileId(), true).available();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static Cosmetic getCosmetic(String id) {
        return (Cosmetic)API.getCosmetic(id);
    }

    public static Cosmetic getCosmetic(UUID id) {
        return (Cosmetic)API.getSelectedCosmetic(id);
    }

    @FunctionalInterface
    private static interface TryApiCall {
        public void run() throws Exception;
    }
}

