/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.IsInsideStructureTracker;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class InsideStructureTagCondition
implements Condition {
    public static final Codec<InsideStructureTagCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.STRUCTURE).listOf().fieldOf("structure_tag_is").forGetter(insideStructureTagCondition -> insideStructureTagCondition.structureTags), (App)Codec.BOOL.optionalFieldOf("in_piece", (Object)false).forGetter(insideStructureTagCondition -> insideStructureTagCondition.intersectsPiece)).apply((Applicative)builder, InsideStructureTagCondition::new));
    private final List<TagKey<Structure>> structureTags;
    private final boolean intersectsPiece;

    public InsideStructureTagCondition(List<TagKey<Structure>> structureTags, boolean mustIntersectPiece) {
        if (structureTags.isEmpty()) {
            throw new IllegalArgumentException("No structures were specified.");
        }
        this.structureTags = structureTags;
        this.intersectsPiece = mustIntersectPiece;
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        Level world = conditionContext.world();
        LivingEntity entity = conditionContext.entity();
        if (world.isClientSide) {
            return this.clientPasses((IsInsideStructureTracker.Access)entity);
        }
        Registry configuredStructureFeatures = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (TagKey<Structure> structureTag : this.structureTags) {
            HolderSet.Named tag = configuredStructureFeatures.getOrCreateTag(structureTag);
            List structures = tag.stream().toList();
            for (Holder structure : structures) {
                BlockPos entityPosition = entity.blockPosition();
                Optional possibleStructureStart = ((ServerLevel)world).structureManager().startsForStructure(SectionPos.of((BlockPos)entityPosition), (Structure)structure.value()).stream().findFirst();
                if (possibleStructureStart.isEmpty()) {
                    return false;
                }
                StructureStart structureStart = (StructureStart)possibleStructureStart.get();
                if (this.intersectsPiece) {
                    for (StructurePiece piece : structureStart.getPieces()) {
                        if (piece.getBoundingBox().isInside((Vec3i)entityPosition)) {
                            ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(true, true));
                            return true;
                        }
                        ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(structureStart.getBoundingBox().isInside((Vec3i)entityPosition), false));
                    }
                    continue;
                }
                if (structureStart.getBoundingBox().isInside((Vec3i)entityPosition)) {
                    ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(true, false));
                    return true;
                }
                ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(false, true));
            }
        }
        return false;
    }

    private boolean clientPasses(IsInsideStructureTracker.Access entity) {
        IsInsideStructureTracker.IsInside tracker = entity.getIsInsideStructureTracker().getTracker();
        return tracker.isInsideStructurePiece() && this.intersectsPiece || tracker.isInsideStructure();
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

