/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.freetype.FT_Incremental_Funcs;

@NativeType(value="struct FT_Incremental_InterfaceRec")
public class FT_Incremental_Interface
extends Struct<FT_Incremental_Interface>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FUNCS;
    public static final int OBJECT;

    protected FT_Incremental_Interface(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_Incremental_Interface create(long address, @Nullable ByteBuffer container) {
        return new FT_Incremental_Interface(address, container);
    }

    public FT_Incremental_Interface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_Incremental_Interface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_Incremental_FuncsRec const *")
    public FT_Incremental_Funcs funcs() {
        return FT_Incremental_Interface.nfuncs(this.address());
    }

    @NativeType(value="FT_Incremental")
    public long object() {
        return FT_Incremental_Interface.nobject(this.address());
    }

    public FT_Incremental_Interface funcs(@NativeType(value="FT_Incremental_FuncsRec const *") FT_Incremental_Funcs value) {
        FT_Incremental_Interface.nfuncs(this.address(), value);
        return this;
    }

    public FT_Incremental_Interface object(@NativeType(value="FT_Incremental") long value) {
        FT_Incremental_Interface.nobject(this.address(), value);
        return this;
    }

    public FT_Incremental_Interface set(FT_Incremental_Funcs funcs, long object) {
        this.funcs(funcs);
        this.object(object);
        return this;
    }

    public FT_Incremental_Interface set(FT_Incremental_Interface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FT_Incremental_Interface malloc() {
        return new FT_Incremental_Interface(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FT_Incremental_Interface calloc() {
        return new FT_Incremental_Interface(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FT_Incremental_Interface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FT_Incremental_Interface(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FT_Incremental_Interface create(long address) {
        return new FT_Incremental_Interface(address, null);
    }

    @Nullable
    public static FT_Incremental_Interface createSafe(long address) {
        return address == 0L ? null : new FT_Incremental_Interface(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FT_Incremental_Interface.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FT_Incremental_Interface.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FT_Incremental_Interface malloc(MemoryStack stack) {
        return new FT_Incremental_Interface(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FT_Incremental_Interface calloc(MemoryStack stack) {
        return new FT_Incremental_Interface(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FT_Incremental_Funcs nfuncs(long struct) {
        return FT_Incremental_Funcs.create(MemoryUtil.memGetAddress((long)(struct + (long)FUNCS)));
    }

    public static long nobject(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OBJECT));
    }

    public static void nfuncs(long struct, FT_Incremental_Funcs value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FUNCS), (long)value.address());
    }

    public static void nobject(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OBJECT), (long)value);
    }

    public static void validate(long struct) {
        long funcs = MemoryUtil.memGetAddress((long)(struct + (long)FUNCS));
        Checks.check((long)funcs);
        FT_Incremental_Funcs.validate(funcs);
    }

    static {
        Struct.Layout layout = FT_Incremental_Interface.__struct((Struct.Member[])new Struct.Member[]{FT_Incremental_Interface.__member((int)POINTER_SIZE), FT_Incremental_Interface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FUNCS = layout.offsetof(0);
        OBJECT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<FT_Incremental_Interface, Buffer>
    implements NativeResource {
        private static final FT_Incremental_Interface ELEMENT_FACTORY = FT_Incremental_Interface.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected FT_Incremental_Interface getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_Incremental_FuncsRec const *")
        public FT_Incremental_Funcs funcs() {
            return FT_Incremental_Interface.nfuncs(this.address());
        }

        @NativeType(value="FT_Incremental")
        public long object() {
            return FT_Incremental_Interface.nobject(this.address());
        }

        public Buffer funcs(@NativeType(value="FT_Incremental_FuncsRec const *") FT_Incremental_Funcs value) {
            FT_Incremental_Interface.nfuncs(this.address(), value);
            return this;
        }

        public Buffer object(@NativeType(value="FT_Incremental") long value) {
            FT_Incremental_Interface.nobject(this.address(), value);
            return this;
        }
    }
}

