/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class DispenseFluidContainer
extends DefaultDispenseItemBehavior {
    private static final DispenseFluidContainer INSTANCE = new DispenseFluidContainer();
    private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();

    public static DispenseFluidContainer getInstance() {
        return INSTANCE;
    }

    private DispenseFluidContainer() {
    }

    public ItemStack execute(BlockSource source, ItemStack stack) {
        if (FluidUtil.getFluidContained(stack).isPresent()) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    private ItemStack fillContainer(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        Direction dispenserFacing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos blockpos = source.pos().relative(dispenserFacing);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid(stack, null, (Level)level, blockpos, dispenserFacing.getOpposite());
        ItemStack resultStack = actionResult.getResult();
        if (!actionResult.isSuccess() || resultStack.isEmpty()) {
            return super.execute(source, stack);
        }
        return this.consumeWithRemainder(source, stack, resultStack);
    }

    private ItemStack dumpContainer(BlockSource source, ItemStack stack) {
        ItemStack singleStack = stack.copy();
        singleStack.setCount(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler(singleStack).orElse(null);
        if (fluidHandler == null) {
            return super.execute(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        Direction dispenserFacing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos blockpos = source.pos().relative(dispenserFacing);
        FluidActionResult result = FluidUtil.tryPlaceFluid(null, (Level)source.level(), InteractionHand.MAIN_HAND, blockpos, stack, fluidStack);
        if (result.isSuccess()) {
            ItemStack drainedStack = result.getResult();
            return this.consumeWithRemainder(source, stack, drainedStack);
        }
        return this.dispenseBehavior.dispense(source, stack);
    }
}

