/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record IntersectionIngredient(List<Ingredient> children) implements ICustomIngredient
{
    public static final MapCodec<IntersectionIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("children").forGetter(IntersectionIngredient::children)).apply((Applicative)builder, IntersectionIngredient::new));

    public IntersectionIngredient {
        if (children.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with no children, use Ingredient.of() to create an empty ingredient");
        }
    }

    public static Ingredient of(Ingredient ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IntersectionIngredient(Arrays.asList(ingredients)).toVanilla();
    }

    @Override
    public boolean test(ItemStack stack) {
        for (Ingredient child : this.children) {
            if (child.test(stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Stream<ItemStack> getItems() {
        return this.children.stream().flatMap(child -> Arrays.stream(child.getItems())).filter(this::test);
    }

    @Override
    public boolean isSimple() {
        for (Ingredient child : this.children) {
            if (child.isSimple()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IngredientType<?> getType() {
        return NeoForgeMod.INTERSECTION_INGREDIENT_TYPE.get();
    }
}

