/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CampfireBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<CampfireBlock> CODEC = RecordCodecBuilder.mapCodec(p_308808_ -> p_308808_.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(p_304361_ -> p_304361_.spawnParticles), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(p_304360_ -> p_304360_.fireDamage), (App)CampfireBlock.propertiesCodec()).apply((Applicative)p_308808_, CampfireBlock::new));
    protected static final VoxelShape SHAPE = Block.box(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.SIGNAL_FIRE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    private static final int SMOKE_DISTANCE = 5;
    private final boolean spawnParticles;
    private final int fireDamage;

    public MapCodec<CampfireBlock> codec() {
        return CODEC;
    }

    public CampfireBlock(boolean p_51236_, int p_51237_, BlockBehaviour.Properties p_51238_) {
        super(p_51238_);
        this.spawnParticles = p_51236_;
        this.fireDamage = p_51237_;
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, Boolean.valueOf(true)))).setValue((Property)SIGNAL_FIRE, Boolean.valueOf(false)))).setValue((Property)WATERLOGGED, Boolean.valueOf(false)))).setValue((Property)FACING, (Comparable)Direction.NORTH)));
    }

    protected ItemInteractionResult useItemOn(ItemStack p_316347_, BlockState p_51274_, Level p_51275_, BlockPos p_51276_, Player p_51277_, InteractionHand p_51278_, BlockHitResult p_51279_) {
        ItemStack itemstack;
        CampfireBlockEntity campfireblockentity;
        Optional optional;
        BlockEntity blockEntity = p_51275_.getBlockEntity(p_51276_);
        if (blockEntity instanceof CampfireBlockEntity && (optional = (campfireblockentity = (CampfireBlockEntity)blockEntity).getCookableRecipe(itemstack = p_51277_.getItemInHand(p_51278_))).isPresent()) {
            if (!p_51275_.isClientSide && campfireblockentity.placeFood((LivingEntity)p_51277_, itemstack, ((CampfireCookingRecipe)((RecipeHolder)optional.get()).value()).getCookingTime())) {
                p_51277_.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void entityInside(BlockState p_51269_, Level p_51270_, BlockPos p_51271_, Entity p_51272_) {
        if (((Boolean)p_51269_.getValue((Property)LIT)).booleanValue() && p_51272_ instanceof LivingEntity) {
            p_51272_.hurt(p_51270_.damageSources().campfire(), this.fireDamage);
        }
        super.entityInside(p_51269_, p_51270_, p_51271_, p_51272_);
    }

    protected void onRemove(BlockState p_51281_, Level p_51282_, BlockPos p_51283_, BlockState p_51284_, boolean p_51285_) {
        if (!p_51281_.is(p_51284_.getBlock())) {
            BlockEntity blockentity = p_51282_.getBlockEntity(p_51283_);
            if (blockentity instanceof CampfireBlockEntity) {
                Containers.dropContents((Level)p_51282_, (BlockPos)p_51283_, (NonNullList)((CampfireBlockEntity)blockentity).getItems());
            }
            super.onRemove(p_51281_, p_51282_, p_51283_, p_51284_, p_51285_);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_51240_) {
        BlockPos blockpos;
        Level levelaccessor = p_51240_.getLevel();
        boolean flag = levelaccessor.getFluidState(blockpos = p_51240_.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)WATERLOGGED, Boolean.valueOf(flag)))).setValue((Property)SIGNAL_FIRE, Boolean.valueOf(this.isSmokeSource(levelaccessor.getBlockState(blockpos.below())))))).setValue((Property)LIT, Boolean.valueOf(!flag)))).setValue((Property)FACING, (Comparable)p_51240_.getHorizontalDirection()));
    }

    protected BlockState updateShape(BlockState p_51298_, Direction p_51299_, BlockState p_51300_, LevelAccessor p_51301_, BlockPos p_51302_, BlockPos p_51303_) {
        if (((Boolean)p_51298_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_51301_.scheduleTick(p_51302_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_51301_));
        }
        return p_51299_ == Direction.DOWN ? (BlockState)((Object)p_51298_.setValue((Property)SIGNAL_FIRE, Boolean.valueOf(this.isSmokeSource(p_51300_)))) : super.updateShape(p_51298_, p_51299_, p_51300_, p_51301_, p_51302_, p_51303_);
    }

    private boolean isSmokeSource(BlockState p_51324_) {
        return p_51324_.is(Blocks.HAY_BLOCK);
    }

    protected VoxelShape getShape(BlockState p_51309_, BlockGetter p_51310_, BlockPos p_51311_, CollisionContext p_51312_) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState p_51307_) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState p_220918_, Level p_220919_, BlockPos p_220920_, RandomSource p_220921_) {
        if (((Boolean)p_220918_.getValue((Property)LIT)).booleanValue()) {
            if (p_220921_.nextInt(10) == 0) {
                p_220919_.playLocalSound((double)p_220920_.getX() + 0.5, (double)p_220920_.getY() + 0.5, (double)p_220920_.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + p_220921_.nextFloat(), p_220921_.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.spawnParticles && p_220921_.nextInt(5) == 0) {
                for (int i = 0; i < p_220921_.nextInt(1) + 1; ++i) {
                    p_220919_.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)p_220920_.getX() + 0.5, (double)p_220920_.getY() + 0.5, (double)p_220920_.getZ() + 0.5, p_220921_.nextFloat() / 2.0f, 5.0E-5, p_220921_.nextFloat() / 2.0f);
                }
            }
        }
    }

    public static void dowse(@Nullable Entity p_152750_, LevelAccessor p_152751_, BlockPos p_152752_, BlockState p_152753_) {
        BlockEntity blockentity;
        if (p_152751_.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                CampfireBlock.makeParticles((Level)p_152751_, p_152752_, (Boolean)p_152753_.getValue((Property)SIGNAL_FIRE), true);
            }
        }
        if ((blockentity = p_152751_.getBlockEntity(p_152752_)) instanceof CampfireBlockEntity) {
            ((CampfireBlockEntity)blockentity).dowse();
        }
        p_152751_.gameEvent(p_152750_, (Holder)GameEvent.BLOCK_CHANGE, p_152752_);
    }

    public boolean placeLiquid(LevelAccessor p_51257_, BlockPos p_51258_, BlockState p_51259_, FluidState p_51260_) {
        if (!((Boolean)p_51259_.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && p_51260_.getType() == Fluids.WATER) {
            boolean flag = (Boolean)p_51259_.getValue((Property)LIT);
            if (flag) {
                if (!p_51257_.isClientSide()) {
                    p_51257_.playSound(null, p_51258_, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                CampfireBlock.dowse(null, p_51257_, p_51258_, p_51259_);
            }
            p_51257_.setBlock(p_51258_, (BlockState)((Object)((BlockState)((Object)p_51259_.setValue((Property)WATERLOGGED, Boolean.valueOf(true)))).setValue((Property)LIT, Boolean.valueOf(false))), 3);
            p_51257_.scheduleTick(p_51258_, p_51260_.getType(), p_51260_.getType().getTickDelay((LevelReader)p_51257_));
            return true;
        }
        return false;
    }

    protected void onProjectileHit(Level p_51244_, BlockState p_51245_, BlockHitResult p_51246_, Projectile p_51247_) {
        BlockPos blockpos = p_51246_.getBlockPos();
        if (!p_51244_.isClientSide && p_51247_.isOnFire() && p_51247_.mayInteract(p_51244_, blockpos) && !((Boolean)p_51245_.getValue((Property)LIT)).booleanValue() && !((Boolean)p_51245_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_51244_.setBlock(blockpos, (BlockState)((Object)p_51245_.setValue((Property)BlockStateProperties.LIT, Boolean.valueOf(true))), 11);
        }
    }

    public static void makeParticles(Level p_51252_, BlockPos p_51253_, boolean p_51254_, boolean p_51255_) {
        RandomSource randomsource = p_51252_.getRandom();
        SimpleParticleType simpleparticletype = p_51254_ ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
        p_51252_.addAlwaysVisibleParticle((ParticleOptions)simpleparticletype, true, (double)p_51253_.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)p_51253_.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)p_51253_.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (p_51255_) {
            p_51252_.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p_51253_.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)p_51253_.getY() + 0.4, (double)p_51253_.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isSmokeyPos(Level p_51249_, BlockPos p_51250_) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos blockpos = p_51250_.below(i);
            BlockState blockstate = p_51249_.getBlockState(blockpos);
            if (CampfireBlock.isLitCampfire(blockstate)) {
                return true;
            }
            boolean flag = Shapes.joinIsNotEmpty((VoxelShape)VIRTUAL_FENCE_POST, (VoxelShape)blockstate.getCollisionShape((BlockGetter)((Object)p_51249_), blockpos, CollisionContext.empty()), (BooleanOp)BooleanOp.AND);
            if (!flag) continue;
            BlockState blockstate1 = p_51249_.getBlockState(blockpos.below());
            return CampfireBlock.isLitCampfire(blockstate1);
        }
        return false;
    }

    public static boolean isLitCampfire(BlockState p_51320_) {
        return p_51320_.hasProperty((Property)LIT) && p_51320_.is(BlockTags.CAMPFIRES) && (Boolean)p_51320_.getValue((Property)LIT) != false;
    }

    protected FluidState getFluidState(BlockState p_51318_) {
        return (Boolean)p_51318_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_51318_);
    }

    protected BlockState rotate(BlockState p_51295_, Rotation p_51296_) {
        return (BlockState)((Object)p_51295_.setValue((Property)FACING, (Comparable)p_51296_.rotate((Direction)p_51295_.getValue((Property)FACING))));
    }

    protected BlockState mirror(BlockState p_51292_, Mirror p_51293_) {
        return p_51292_.rotate(p_51293_.getRotation((Direction)p_51292_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51305_) {
        p_51305_.add(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING});
    }

    public BlockEntity newBlockEntity(BlockPos p_152759_, BlockState p_152760_) {
        return new CampfireBlockEntity(p_152759_, p_152760_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        if (p_152755_.isClientSide) {
            return (Boolean)p_152756_.getValue((Property)LIT) != false ? CampfireBlock.createTickerHelper(p_152757_, BlockEntityType.CAMPFIRE, CampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)p_152756_.getValue((Property)LIT) != false ? CampfireBlock.createTickerHelper(p_152757_, BlockEntityType.CAMPFIRE, CampfireBlockEntity::cookTick) : CampfireBlock.createTickerHelper(p_152757_, BlockEntityType.CAMPFIRE, CampfireBlockEntity::cooldownTick);
    }

    protected boolean isPathfindable(BlockState p_51264_, PathComputationType p_51267_) {
        return false;
    }

    public static boolean canLight(BlockState p_51322_) {
        return p_51322_.is(BlockTags.CAMPFIRES, p_51262_ -> p_51262_.hasProperty((Property)WATERLOGGED) && p_51262_.hasProperty((Property)LIT)) && (Boolean)p_51322_.getValue((Property)WATERLOGGED) == false && (Boolean)p_51322_.getValue((Property)LIT) == false;
    }
}

