/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IMinecartCollisionHandler;
import net.neoforged.neoforge.common.extensions.IAbstractMinecartExtension;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMinecart
extends VehicleEntity
implements IAbstractMinecartExtension {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.BOOLEAN);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private boolean onRails;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3 targetDeltaMovement = Vec3.ZERO;
    private boolean canBePushed = true;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Util.make(Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.getNormal();
        Vec3i vec3i1 = Direction.EAST.getNormal();
        Vec3i vec3i2 = Direction.NORTH.getNormal();
        Vec3i vec3i3 = Direction.SOUTH.getNormal();
        Vec3i vec3i4 = vec3i.below();
        Vec3i vec3i5 = vec3i1.below();
        Vec3i vec3i6 = vec3i2.below();
        Vec3i vec3i7 = vec3i3.below();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });
    private static IMinecartCollisionHandler COLLISIONS = null;
    private boolean canUseRail = true;
    private float currentSpeedCapOnRail = this.getMaxCartSpeedOnRail();
    @Nullable
    private Float maxSpeedAirLateral = null;
    private float maxSpeedAirVertical = -1.0f;
    private double dragAir = 0.95f;

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.blocksBuilding = true;
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.setPos(p_38092_, p_38093_, p_38094_);
        this.xo = p_38092_;
        this.yo = p_38093_;
        this.zo = p_38094_;
    }

    public IMinecartCollisionHandler getCollisionHandler() {
        return COLLISIONS;
    }

    public static void registerCollisionHandler(@javax.annotation.Nullable IMinecartCollisionHandler handler) {
        COLLISIONS = handler;
    }

    public static AbstractMinecart createMinecart(ServerLevel p_305794_, double p_38121_, double p_38122_, double p_38123_, Type p_38124_, ItemStack p_305892_, @javax.annotation.Nullable Player p_306203_) {
        Object abstractminecart = switch (p_38124_.ordinal()) {
            case 1 -> new MinecartChest((Level)p_305794_, p_38121_, p_38122_, p_38123_);
            case 2 -> new MinecartFurnace(p_305794_, p_38121_, p_38122_, p_38123_);
            case 3 -> new MinecartTNT((Level)p_305794_, p_38121_, p_38122_, p_38123_);
            case 4 -> new MinecartSpawner(p_305794_, p_38121_, p_38122_, p_38123_);
            case 5 -> new MinecartHopper((Level)p_305794_, p_38121_, p_38122_, p_38123_);
            case 6 -> new MinecartCommandBlock(p_305794_, p_38121_, p_38122_, p_38123_);
            default -> new Minecart(p_305794_, p_38121_, p_38122_, p_38123_);
        };
        EntityType.createDefaultStackConfig(p_305794_, p_305892_, p_306203_).accept((MinecartChest)abstractminecart);
        return abstractminecart;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326247_) {
        super.defineSynchedData(p_326247_);
        p_326247_.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        p_326247_.define(DATA_ID_DISPLAY_OFFSET, 6);
        p_326247_.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    public boolean canCollideWith(Entity p_38168_) {
        return Boat.canVehicleCollide((Entity)((Object)this), p_38168_);
    }

    public boolean isPushable() {
        return this.canBePushed;
    }

    public Vec3 getRelativePortalPosition(Direction.Axis p_38132_, BlockUtil.FoundRectangle p_38133_) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(p_38132_, p_38133_));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_294753_, EntityDimensions p_295251_, float p_296054_) {
        boolean flag = p_294753_ instanceof Villager || p_294753_ instanceof WanderingTrader;
        return flag ? LOWERED_PASSENGER_ATTACHMENT : super.getPassengerAttachmentPoint(p_294753_, p_295251_, p_296054_);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity p_38145_) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(p_38145_);
        }
        int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
        BlockPos blockpos = this.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = p_38145_.getDismountPoses();
        for (Pose pose : immutablelist) {
            EntityDimensions entitydimensions = p_38145_.getDimensions(pose);
            float f = Math.min(entitydimensions.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i = (Integer)unmodifiableIterator.next();
                for (int[] aint1 : aint) {
                    blockpos$mutableblockpos.set(blockpos.getX() + aint1[0], blockpos.getY() + i, blockpos.getZ() + aint1[1]);
                    double d0 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape((BlockGetter)((Object)this.level()), (BlockPos)blockpos$mutableblockpos), () -> DismountHelper.nonClimbableShape((BlockGetter)((Object)this.level()), (BlockPos)blockpos$mutableblockpos.below()));
                    if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                    AABB aabb = new AABB(-f, 0.0, -f, f, entitydimensions.height(), f);
                    Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)blockpos$mutableblockpos, (double)d0);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)p_38145_, (AABB)aabb.move(vec3))) continue;
                    p_38145_.setPose(pose);
                    return vec3;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockpos$mutableblockpos.set((double)blockpos.getX(), d1, (double)blockpos.getZ());
        for (Pose pose1 : immutablelist) {
            int j;
            double d3;
            double d2 = p_38145_.getDimensions(pose1).height();
            if (!(d1 + d2 <= (d3 = DismountHelper.findCeilingFrom((BlockPos)blockpos$mutableblockpos, (int)(j = Mth.ceil((double)(d1 - (double)blockpos$mutableblockpos.getY() + d2))), p_352844_ -> this.level().getBlockState((BlockPos)p_352844_).getCollisionShape((BlockGetter)((Object)this.level()), (BlockPos)p_352844_))))) continue;
            p_38145_.setPose(pose1);
            break;
        }
        return super.getDismountLocationForPassenger(p_38145_);
    }

    protected float getBlockSpeedFactor() {
        BlockState blockstate = this.level().getBlockState(this.blockPosition());
        return blockstate.is(BlockTags.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    public void animateHurt(float p_265349_) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    private static Pair<Vec3i, Vec3i> exits(RailShape p_38126_) {
        return EXITS.get(p_38126_);
    }

    public Direction getMotionDirection() {
        return this.flipped ? this.getDirection().getOpposite().getClockWise() : this.getDirection().getClockWise();
    }

    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.handlePortal();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            double d2;
            this.applyGravity();
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)this.getY());
            int k = Mth.floor((double)this.getZ());
            if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
                --j;
            }
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(blockpos);
            this.onRails = BaseRailBlock.isRail(blockstate);
            if (this.canUseRail() && this.onRails) {
                this.moveAlongTrack(blockpos, blockstate);
                if (blockstate.getBlock() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.getBlock()).isActivatorRail()) {
                    this.activateMinecart(i, j, k, (Boolean)blockstate.getValue((Property)PoweredRailBlock.POWERED));
                }
            } else {
                this.comeOffTrack();
            }
            this.checkInsideBlocks();
            this.setXRot(0.0f);
            double d0 = this.xo - this.getX();
            double d1 = this.zo - this.getZ();
            if (d0 * d0 + d1 * d1 > 0.001) {
                this.setYRot((float)(Mth.atan2((double)d1, (double)d0) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.setYRot(this.getYRot() + 180.0f);
                }
            }
            if ((d2 = (double)Mth.wrapDegrees((float)(this.getYRot() - this.yRotO))) < -170.0 || d2 >= 170.0) {
                this.setYRot(this.getYRot() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.setRot(this.getYRot(), this.getXRot());
            AABB box = this.getCollisionHandler() != null ? this.getCollisionHandler().getMinecartCollisionBox(this) : this.getBoundingBox().inflate(0.2f, 0.0, 0.2f);
            if (this.canBeRidden() && this.getDeltaMovement().horizontalDistanceSqr() > 0.01) {
                List<Entity> list = this.level().getEntities((Entity)((Object)this), box, EntitySelector.pushableBy((Entity)((Object)this)));
                if (!list.isEmpty()) {
                    for (Entity entity1 : list) {
                        if (!(entity1 instanceof Player || entity1 instanceof IronGolem || entity1 instanceof AbstractMinecart || this.isVehicle() || entity1.isPassenger())) {
                            entity1.startRiding((Entity)((Object)this));
                            continue;
                        }
                        entity1.push((Entity)((Object)this));
                    }
                }
            } else {
                for (Entity entity : this.level().getEntities((Entity)((Object)this), box)) {
                    if (this.hasPassenger(entity) || !entity.isPushable() || !(entity instanceof AbstractMinecart)) continue;
                    entity.push((Entity)((Object)this));
                }
            }
            this.updateInWaterStateAndDoFluidPushing();
            if (this.isInLava()) {
                this.lavaHurt();
                this.fallDistance *= 0.5f;
            }
            this.firstTick = false;
        }
    }

    protected double getMaxSpeed() {
        return (this.isInWater() ? 4.0 : 8.0) / 20.0;
    }

    public void activateMinecart(int p_38111_, int p_38112_, int p_38113_, boolean p_38114_) {
    }

    protected void comeOffTrack() {
        double d0 = this.onGround() ? this.getMaxSpeed() : (double)this.getMaxSpeedAirLateral();
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp((double)vec3.x, (double)(-d0), (double)d0), vec3.y, Mth.clamp((double)vec3.z, (double)(-d0), (double)d0));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        if (this.getMaxSpeedAirVertical() > 0.0f && this.getDeltaMovement().y > (double)this.getMaxSpeedAirVertical()) {
            if (Math.abs(this.getDeltaMovement().x) < (double)0.3f && Math.abs(this.getDeltaMovement().z) < (double)0.3f) {
                this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, (double)0.15f, this.getDeltaMovement().z));
            } else {
                this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, (double)this.getMaxSpeedAirVertical(), this.getDeltaMovement().z));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(this.getDragAir()));
        }
    }

    protected void moveAlongTrack(BlockPos p_38156_, BlockState p_38157_) {
        double d14;
        this.resetFallDistance();
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        Vec3 vec3 = this.getPos(d0, d1, d2);
        d1 = p_38156_.getY();
        boolean flag = false;
        boolean flag1 = false;
        BaseRailBlock baserailblock = (BaseRailBlock)p_38157_.getBlock();
        if (baserailblock instanceof PoweredRailBlock && !((PoweredRailBlock)baserailblock).isActivatorRail()) {
            flag = (Boolean)p_38157_.getValue((Property)PoweredRailBlock.POWERED);
            flag1 = !flag;
        }
        double d3 = this.getSlopeAdjustment();
        if (this.isInWater()) {
            d3 *= 0.2;
        }
        Vec3 vec31 = this.getDeltaMovement();
        RailShape railshape = ((BaseRailBlock)p_38157_.getBlock()).getRailDirection(p_38157_, (BlockGetter)((Object)this.level()), p_38156_, this);
        switch (railshape) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(vec31.add(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(vec31.add(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(vec31.add(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(vec31.add(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec31 = this.getDeltaMovement();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.getX() - vec3i.getX();
        double d5 = vec3i1.getZ() - vec3i.getZ();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec31.x * d4 + vec31.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec31.horizontalDistance());
        vec31 = new Vec3(d8 * d4 / d6, vec31.y, d8 * d5 / d6);
        this.setDeltaMovement(vec31);
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Vec3 vec32 = entity.getDeltaMovement();
            double d9 = vec32.horizontalDistanceSqr();
            double d11 = this.getDeltaMovement().horizontalDistanceSqr();
            if (d9 > 1.0E-4 && d11 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(vec32.x * 0.1, 0.0, vec32.z * 0.1));
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            double d22 = this.getDeltaMovement().horizontalDistance();
            if (d22 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double d23 = (double)p_38156_.getX() + 0.5 + (double)vec3i.getX() * 0.5;
        double d10 = (double)p_38156_.getZ() + 0.5 + (double)vec3i.getZ() * 0.5;
        double d12 = (double)p_38156_.getX() + 0.5 + (double)vec3i1.getX() * 0.5;
        double d13 = (double)p_38156_.getZ() + 0.5 + (double)vec3i1.getZ() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = d2 - (double)p_38156_.getZ();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)p_38156_.getX();
        } else {
            double d15 = d0 - d23;
            double d16 = d2 - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d23 + d4 * d14;
        d2 = d10 + d5 * d14;
        this.setPos(d0, d1, d2);
        this.moveMinecartOnRail(p_38156_);
        if (vec3i.getY() != 0 && Mth.floor((double)this.getX()) - p_38156_.getX() == vec3i.getX() && Mth.floor((double)this.getZ()) - p_38156_.getZ() == vec3i.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)vec3i.getY(), this.getZ());
        } else if (vec3i1.getY() != 0 && Mth.floor((double)this.getX()) - p_38156_.getX() == vec3i1.getX() && Mth.floor((double)this.getZ()) - p_38156_.getZ() == vec3i1.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)vec3i1.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3 vec33 = this.getPos(this.getX(), this.getY(), this.getZ());
        if (vec33 != null && vec3 != null) {
            double d17 = (vec3.y - vec33.y) * 0.05;
            Vec3 vec34 = this.getDeltaMovement();
            double d18 = vec34.horizontalDistance();
            if (d18 > 0.0) {
                this.setDeltaMovement(vec34.multiply((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            this.setPos(this.getX(), vec33.y, this.getZ());
        }
        int j = Mth.floor((double)this.getX());
        int i = Mth.floor((double)this.getZ());
        if (j != p_38156_.getX() || i != p_38156_.getZ()) {
            Vec3 vec35 = this.getDeltaMovement();
            double d26 = vec35.horizontalDistance();
            this.setDeltaMovement(d26 * (double)(j - p_38156_.getX()), vec35.y, d26 * (double)(i - p_38156_.getZ()));
        }
        if (this.shouldDoRailFunctions()) {
            baserailblock.onMinecartPass(p_38157_, this.level(), p_38156_, this);
        }
        if (flag && this.shouldDoRailFunctions()) {
            Vec3 vec36 = this.getDeltaMovement();
            double d27 = vec36.horizontalDistance();
            if (d27 > 0.01) {
                double d19 = 0.06;
                this.setDeltaMovement(vec36.add(vec36.x / d27 * 0.06, 0.0, vec36.z / d27 * 0.06));
            } else {
                Vec3 vec37 = this.getDeltaMovement();
                double d20 = vec37.x;
                double d21 = vec37.z;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(p_38156_.west())) {
                        d20 = 0.02;
                    } else if (this.isRedstoneConductor(p_38156_.east())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isRedstoneConductor(p_38156_.north())) {
                        d21 = 0.02;
                    } else if (this.isRedstoneConductor(p_38156_.south())) {
                        d21 = -0.02;
                    }
                }
                this.setDeltaMovement(d20, vec37.y, d21);
            }
        }
    }

    public boolean isOnRails() {
        return this.onRails;
    }

    private boolean isRedstoneConductor(BlockPos p_38130_) {
        return this.level().getBlockState(p_38130_).isRedstoneConductor((BlockGetter)((Object)this.level()), p_38130_);
    }

    protected void applyNaturalSlowdown() {
        double d0 = this.isVehicle() ? 0.997 : 0.96;
        Vec3 vec3 = this.getDeltaMovement();
        vec3 = vec3.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3 = vec3.scale((double)0.95f);
        }
        this.setDeltaMovement(vec3);
    }

    @javax.annotation.Nullable
    public Vec3 getPosOffs(double p_38097_, double p_38098_, double p_38099_, double p_38100_) {
        BlockState blockstate;
        int i = Mth.floor((double)p_38097_);
        int j = Mth.floor((double)p_38098_);
        int k = Mth.floor((double)p_38099_);
        if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(blockstate = this.level().getBlockState(new BlockPos(i, j, k)))) {
            RailShape railshape = ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)((Object)this.level()), new BlockPos(i, j, k), this);
            p_38098_ = j;
            if (railshape.isAscending()) {
                p_38098_ = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = vec3i1.getX() - vec3i.getX();
            double d1 = vec3i1.getZ() - vec3i.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            if (vec3i.getY() != 0 && Mth.floor((double)(p_38097_ += (d0 /= d2) * p_38100_)) - i == vec3i.getX() && Mth.floor((double)(p_38099_ += (d1 /= d2) * p_38100_)) - k == vec3i.getZ()) {
                p_38098_ += (double)vec3i.getY();
            } else if (vec3i1.getY() != 0 && Mth.floor((double)p_38097_) - i == vec3i1.getX() && Mth.floor((double)p_38099_) - k == vec3i1.getZ()) {
                p_38098_ += (double)vec3i1.getY();
            }
            return this.getPos(p_38097_, p_38098_, p_38099_);
        }
        return null;
    }

    @javax.annotation.Nullable
    public Vec3 getPos(double p_38180_, double p_38181_, double p_38182_) {
        BlockState blockstate;
        int i = Mth.floor((double)p_38180_);
        int j = Mth.floor((double)p_38181_);
        int k = Mth.floor((double)p_38182_);
        if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(blockstate = this.level().getBlockState(new BlockPos(i, j, k)))) {
            double d9;
            RailShape railshape = ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)((Object)this.level()), new BlockPos(i, j, k), this);
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = (double)i + 0.5 + (double)vec3i.getX() * 0.5;
            double d1 = (double)j + 0.0625 + (double)vec3i.getY() * 0.5;
            double d2 = (double)k + 0.5 + (double)vec3i.getZ() * 0.5;
            double d3 = (double)i + 0.5 + (double)vec3i1.getX() * 0.5;
            double d4 = (double)j + 0.0625 + (double)vec3i1.getY() * 0.5;
            double d5 = (double)k + 0.5 + (double)vec3i1.getZ() * 0.5;
            double d6 = d3 - d0;
            double d7 = (d4 - d1) * 2.0;
            double d8 = d5 - d2;
            if (d6 == 0.0) {
                d9 = p_38182_ - (double)k;
            } else if (d8 == 0.0) {
                d9 = p_38180_ - (double)i;
            } else {
                double d10 = p_38180_ - d0;
                double d11 = p_38182_ - d2;
                d9 = (d10 * d6 + d11 * d8) * 2.0;
            }
            p_38180_ = d0 + d6 * d9;
            p_38181_ = d1 + d7 * d9;
            p_38182_ = d2 + d8 * d9;
            if (d7 < 0.0) {
                p_38181_ += 1.0;
            } else if (d7 > 0.0) {
                p_38181_ += 0.5;
            }
            return new Vec3(p_38180_, p_38181_, p_38182_);
        }
        return null;
    }

    public AABB getBoundingBoxForCulling() {
        AABB aabb = this.getBoundingBox();
        return this.hasCustomDisplay() ? aabb.inflate((double)Math.abs(this.getDisplayOffset()) / 16.0) : aabb;
    }

    protected void readAdditionalSaveData(CompoundTag p_38137_) {
        if (p_38137_.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)p_38137_.getCompound("DisplayState")));
            this.setDisplayOffset(p_38137_.getInt("DisplayOffset"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag p_38151_) {
        if (this.hasCustomDisplay()) {
            p_38151_.putBoolean("CustomDisplayTile", true);
            p_38151_.put("DisplayState", NbtUtils.writeBlockState((BlockState)this.getDisplayBlockState()));
            p_38151_.putInt("DisplayOffset", this.getDisplayOffset());
        }
    }

    public void push(Entity p_38165_) {
        double d1;
        double d0;
        double d2;
        if (this.getCollisionHandler() != null) {
            this.getCollisionHandler().onEntityCollision(this, p_38165_);
            return;
        }
        if (!(this.level().isClientSide || p_38165_.noPhysics || this.noPhysics || this.hasPassenger(p_38165_) || !((d2 = (d0 = p_38165_.getX() - this.getX()) * d0 + (d1 = p_38165_.getZ() - this.getZ()) * d1) >= (double)1.0E-4f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (p_38165_ instanceof AbstractMinecart) {
                Vec3 vec31;
                double d5;
                double d4 = p_38165_.getX() - this.getX();
                Vec3 vec3 = new Vec3(d4, 0.0, d5 = p_38165_.getZ() - this.getZ()).normalize();
                double d6 = Math.abs(vec3.dot(vec31 = new Vec3((double)Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))), 0.0, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize()));
                if (d6 < (double)0.8f) {
                    return;
                }
                Vec3 vec32 = this.getDeltaMovement();
                Vec3 vec33 = p_38165_.getDeltaMovement();
                if (((AbstractMinecart)((Object)p_38165_)).isPoweredCart() && !this.isPoweredCart()) {
                    this.setDeltaMovement(vec32.multiply(0.2, 1.0, 0.2));
                    this.push(vec33.x - d0, 0.0, vec33.z - d1);
                    p_38165_.setDeltaMovement(vec33.multiply(0.95, 1.0, 0.95));
                } else if (!((AbstractMinecart)((Object)p_38165_)).isPoweredCart() && this.isPoweredCart()) {
                    p_38165_.setDeltaMovement(vec33.multiply(0.2, 1.0, 0.2));
                    p_38165_.push(vec32.x + d0, 0.0, vec32.z + d1);
                    this.setDeltaMovement(vec32.multiply(0.95, 1.0, 0.95));
                } else {
                    double d7 = (vec33.x + vec32.x) / 2.0;
                    double d8 = (vec33.z + vec32.z) / 2.0;
                    this.setDeltaMovement(vec32.multiply(0.2, 1.0, 0.2));
                    this.push(d7 - d0, 0.0, d8 - d1);
                    p_38165_.setDeltaMovement(vec33.multiply(0.2, 1.0, 0.2));
                    p_38165_.push(d7 + d0, 0.0, d8 + d1);
                }
            } else {
                this.push(-d0, 0.0, -d1);
                p_38165_.push(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    public void lerpTo(double p_38102_, double p_38103_, double p_38104_, float p_38105_, float p_38106_, int p_38107_) {
        this.lerpX = p_38102_;
        this.lerpY = p_38103_;
        this.lerpZ = p_38104_;
        this.lerpYRot = p_38105_;
        this.lerpXRot = p_38106_;
        this.lerpSteps = p_38107_ + 2;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    public void lerpMotion(double p_38171_, double p_38172_, double p_38173_) {
        this.targetDeltaMovement = new Vec3(p_38171_, p_38172_, p_38173_);
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    public abstract Type getMinecartType();

    public BlockState getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : this.getEntityData().get(DATA_ID_DISPLAY_OFFSET).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState p_38147_) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(p_38147_));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int p_38175_) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, p_38175_);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean p_38139_) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, p_38139_);
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean value) {
        this.canUseRail = value;
    }

    public float getCurrentCartSpeedCapOnRail() {
        return this.currentSpeedCapOnRail;
    }

    public void setCurrentCartSpeedCapOnRail(float value) {
        this.currentSpeedCapOnRail = Math.min(value, this.getMaxCartSpeedOnRail());
    }

    public double getMaxSpeedWithRail() {
        if (!this.canUseRail()) {
            return this.getMaxSpeed();
        }
        BlockPos pos = this.getCurrentRailPosition();
        BlockState state = this.level().getBlockState(pos);
        if (!state.is(BlockTags.RAILS)) {
            return this.getMaxSpeed();
        }
        float railMaxSpeed = ((BaseRailBlock)state.getBlock()).getRailMaxSpeed(state, this.level(), pos, this);
        return Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral == null ? (float)this.getMaxSpeed() : this.maxSpeedAirLateral.floatValue();
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = Float.valueOf(value);
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public void moveMinecartOnRail(BlockPos pos) {
        AbstractMinecart mc = this;
        double d24 = mc.isVehicle() ? 0.75 : 1.0;
        double d25 = mc.getMaxSpeedWithRail();
        Vec3 vec3d1 = mc.getDeltaMovement();
        mc.move(MoverType.SELF, new Vec3(Mth.clamp((double)(d24 * vec3d1.x), (double)(-d25), (double)d25), 0.0, Mth.clamp((double)(d24 * vec3d1.z), (double)(-d25), (double)d25)));
    }

    public ItemStack getPickResult() {
        return new ItemStack(switch (this.getMinecartType().ordinal()) {
            case 1 -> Items.CHEST_MINECART;
            case 2 -> Items.FURNACE_MINECART;
            case 3 -> Items.TNT_MINECART;
            default -> Items.MINECART;
            case 5 -> Items.HOPPER_MINECART;
            case 6 -> Items.COMMAND_BLOCK_MINECART;
        });
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

