/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jarjar.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Optional;
import net.neoforged.jarjar.metadata.ContainedJarIdentifier;
import net.neoforged.jarjar.metadata.ContainedJarMetadata;
import net.neoforged.jarjar.metadata.ContainedVersion;
import net.neoforged.jarjar.metadata.Metadata;
import net.neoforged.jarjar.metadata.json.ArtifactVersionSerializer;
import net.neoforged.jarjar.metadata.json.ContainedJarIdentifierSerializer;
import net.neoforged.jarjar.metadata.json.ContainedJarMetadataSerializer;
import net.neoforged.jarjar.metadata.json.ContainedVersionSerializer;
import net.neoforged.jarjar.metadata.json.MetadataSerializer;
import net.neoforged.jarjar.metadata.json.VersionRangeSerializer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataIOHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataIOHandler.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(VersionRange.class, (Object)new VersionRangeSerializer()).registerTypeAdapter(ArtifactVersion.class, (Object)new ArtifactVersionSerializer()).registerTypeAdapter(DefaultArtifactVersion.class, (Object)new ArtifactVersionSerializer()).registerTypeAdapter(ContainedJarIdentifier.class, (Object)new ContainedJarIdentifierSerializer()).registerTypeAdapter(ContainedJarMetadata.class, (Object)new ContainedJarMetadataSerializer()).registerTypeAdapter(ContainedVersion.class, (Object)new ContainedVersionSerializer()).registerTypeAdapter(Metadata.class, (Object)new MetadataSerializer()).setPrettyPrinting().create();

    private MetadataIOHandler() {
        throw new IllegalStateException("Can not instantiate an instance of: MetadataIOHandler. This is a utility class");
    }

    public static Optional<Metadata> fromStream(InputStream stream) {
        try {
            return Optional.of(GSON.fromJson((Reader)new InputStreamReader(stream), Metadata.class));
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse metadata", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Iterable<String> toLines(Metadata metadata) {
        return Arrays.asList(GSON.toJson((Object)metadata).split("\n"));
    }

    public static InputStream toInputStream(Metadata metadata) {
        String values = GSON.toJson((Object)metadata);
        return new ByteArrayInputStream(values.getBytes());
    }
}

