/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> $$0 = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(200){

            protected void rehash(int p_76102_) {
            }
        };
        $$0.defaultReturnValue((byte)127);
        return $$0;
    });
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> p_76046_) {
        p_76046_.add(FALLING);
    }

    @Override
    public Vec3 getFlow(BlockGetter p_75987_, BlockPos p_75988_, FluidState p_75989_) {
        double $$3 = 0.0;
        double $$4 = 0.0;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            $$5.setWithOffset((Vec3i)p_75988_, $$6);
            FluidState $$7 = p_75987_.getFluidState($$5);
            if (!this.affectsFlow($$7)) continue;
            float $$8 = $$7.getOwnHeight();
            float $$9 = 0.0f;
            if ($$8 == 0.0f) {
                Vec3i $$10;
                FluidState $$11;
                if (!p_75987_.getBlockState($$5).blocksMotion() && this.affectsFlow($$11 = p_75987_.getFluidState((BlockPos)($$10 = $$5.below()))) && ($$8 = $$11.getOwnHeight()) > 0.0f) {
                    $$9 = p_75989_.getOwnHeight() - ($$8 - 0.8888889f);
                }
            } else if ($$8 > 0.0f) {
                $$9 = p_75989_.getOwnHeight() - $$8;
            }
            if ($$9 == 0.0f) continue;
            $$3 += (double)((float)$$6.getStepX() * $$9);
            $$4 += (double)((float)$$6.getStepZ() * $$9);
        }
        Vec3 $$12 = new Vec3($$3, 0.0, $$4);
        if (p_75989_.getValue(FALLING).booleanValue()) {
            for (Direction $$13 : Direction.Plane.HORIZONTAL) {
                $$5.setWithOffset((Vec3i)p_75988_, $$13);
                if (!this.isSolidFace(p_75987_, $$5, $$13) && !this.isSolidFace(p_75987_, (BlockPos)$$5.above(), $$13)) continue;
                $$12 = $$12.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return $$12.normalize();
    }

    private boolean affectsFlow(FluidState p_76095_) {
        return p_76095_.isEmpty() || p_76095_.getType().isSame(this);
    }

    protected boolean isSolidFace(BlockGetter p_75991_, BlockPos p_75992_, Direction p_75993_) {
        BlockState $$3 = p_75991_.getBlockState(p_75992_);
        FluidState $$4 = p_75991_.getFluidState(p_75992_);
        if ($$4.getType().isSame(this)) {
            return false;
        }
        if (p_75993_ == Direction.UP) {
            return true;
        }
        if ($$3.getBlock() instanceof IceBlock) {
            return false;
        }
        return $$3.isFaceSturdy(p_75991_, p_75992_, p_75993_);
    }

    protected void spread(Level p_255851_, BlockPos p_76012_, FluidState p_76013_) {
        if (p_76013_.isEmpty()) {
            return;
        }
        BlockState $$3 = p_255851_.getBlockState(p_76012_);
        BlockPos $$4 = p_76012_.below();
        BlockState $$5 = p_255851_.getBlockState($$4);
        FluidState $$6 = this.getNewLiquid(p_255851_, $$4, $$5);
        if (this.canSpreadTo(p_255851_, p_76012_, $$3, Direction.DOWN, $$4, $$5, p_255851_.getFluidState($$4), $$6.getType())) {
            this.spreadTo(p_255851_, $$4, $$5, Direction.DOWN, $$6);
            if (this.sourceNeighborCount(p_255851_, p_76012_) >= 3) {
                this.spreadToSides(p_255851_, p_76012_, p_76013_, $$3);
            }
        } else if (p_76013_.isSource() || !this.isWaterHole(p_255851_, $$6.getType(), p_76012_, $$3, $$4, $$5)) {
            this.spreadToSides(p_255851_, p_76012_, p_76013_, $$3);
        }
    }

    private void spreadToSides(Level p_256644_, BlockPos p_76016_, FluidState p_76017_, BlockState p_76018_) {
        int $$4 = p_76017_.getAmount() - this.getDropOff(p_256644_);
        if (p_76017_.getValue(FALLING).booleanValue()) {
            $$4 = 7;
        }
        if ($$4 <= 0) {
            return;
        }
        Map<Direction, FluidState> $$5 = this.getSpread(p_256644_, p_76016_, p_76018_);
        for (Map.Entry<Direction, FluidState> $$6 : $$5.entrySet()) {
            BlockState $$10;
            Direction $$7 = $$6.getKey();
            FluidState $$8 = $$6.getValue();
            BlockPos $$9 = p_76016_.relative($$7);
            if (!this.canSpreadTo(p_256644_, p_76016_, p_76018_, $$7, $$9, $$10 = p_256644_.getBlockState($$9), p_256644_.getFluidState($$9), $$8.getType())) continue;
            this.spreadTo(p_256644_, $$9, $$10, $$7, $$8);
        }
    }

    protected FluidState getNewLiquid(Level p_256464_, BlockPos p_76037_, BlockState p_76038_) {
        BlockPos $$11;
        BlockState $$12;
        FluidState $$13;
        int $$3 = 0;
        int $$4 = 0;
        for (Direction $$5 : Direction.Plane.HORIZONTAL) {
            BlockPos $$6 = p_76037_.relative($$5);
            BlockState $$7 = p_256464_.getBlockState($$6);
            FluidState $$8 = $$7.getFluidState();
            if (!$$8.getType().isSame(this) || !this.canPassThroughWall($$5, p_256464_, p_76037_, p_76038_, $$6, $$7)) continue;
            if ($$8.isSource()) {
                ++$$4;
            }
            $$3 = Math.max($$3, $$8.getAmount());
        }
        if (this.canConvertToSource(p_256464_) && $$4 >= 2) {
            BlockState $$9 = p_256464_.getBlockState(p_76037_.below());
            FluidState $$10 = $$9.getFluidState();
            if ($$9.isSolid() || this.isSourceBlockOfThisType($$10)) {
                return this.getSource(false);
            }
        }
        if (!($$13 = ($$12 = p_256464_.getBlockState($$11 = p_76037_.above())).getFluidState()).isEmpty() && $$13.getType().isSame(this) && this.canPassThroughWall(Direction.UP, p_256464_, p_76037_, p_76038_, $$11, $$12)) {
            return this.getFlowing(8, true);
        }
        int $$14 = $$3 - this.getDropOff(p_256464_);
        if ($$14 <= 0) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return this.getFlowing($$14, false);
    }

    private boolean canPassThroughWall(Direction p_76062_, BlockGetter p_76063_, BlockPos p_76064_, BlockState p_76065_, BlockPos p_76066_, BlockState p_76067_) {
        VoxelShape $$12;
        VoxelShape $$11;
        boolean $$13;
        Object $$10;
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> $$7;
        if (p_76065_.getBlock().hasDynamicShape() || p_76067_.getBlock().hasDynamicShape()) {
            Object $$6 = null;
        } else {
            $$7 = OCCLUSION_CACHE.get();
        }
        if ($$7 != null) {
            Block.BlockStatePairKey $$8 = new Block.BlockStatePairKey(p_76065_, p_76067_, p_76062_);
            byte $$9 = $$7.getAndMoveToFirst((Object)$$8);
            if ($$9 != 127) {
                return $$9 != 0;
            }
        } else {
            $$10 = null;
        }
        boolean bl = $$13 = !Shapes.mergedFaceOccludes($$11 = p_76065_.getCollisionShape(p_76063_, p_76064_), $$12 = p_76067_.getCollisionShape(p_76063_, p_76066_), p_76062_);
        if ($$7 != null) {
            if ($$7.size() == 200) {
                $$7.removeLastByte();
            }
            $$7.putAndMoveToFirst($$10, (byte)($$13 ? 1 : 0));
        }
        return $$13;
    }

    public abstract Fluid getFlowing();

    public FluidState getFlowing(int p_75954_, boolean p_75955_) {
        return (FluidState)((FluidState)this.getFlowing().defaultFluidState().setValue(LEVEL, p_75954_)).setValue(FALLING, p_75955_);
    }

    public abstract Fluid getSource();

    public FluidState getSource(boolean p_76069_) {
        return (FluidState)this.getSource().defaultFluidState().setValue(FALLING, p_76069_);
    }

    protected abstract boolean canConvertToSource(Level var1);

    protected void spreadTo(LevelAccessor p_76005_, BlockPos p_76006_, BlockState p_76007_, Direction p_76008_, FluidState p_76009_) {
        if (p_76007_.getBlock() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)((Object)p_76007_.getBlock())).placeLiquid(p_76005_, p_76006_, p_76007_, p_76009_);
        } else {
            if (!p_76007_.isAir()) {
                this.beforeDestroyingBlock(p_76005_, p_76006_, p_76007_);
            }
            p_76005_.setBlock(p_76006_, p_76009_.createLegacyBlock(), 3);
        }
    }

    protected abstract void beforeDestroyingBlock(LevelAccessor var1, BlockPos var2, BlockState var3);

    private static short getCacheKey(BlockPos p_76059_, BlockPos p_76060_) {
        int $$2 = p_76060_.getX() - p_76059_.getX();
        int $$3 = p_76060_.getZ() - p_76059_.getZ();
        return (short)(($$2 + 128 & 0xFF) << 8 | $$3 + 128 & 0xFF);
    }

    protected int getSlopeDistance(LevelReader p_76027_, BlockPos p_76028_, int p_76029_, Direction p_76030_, BlockState p_76031_, BlockPos p_76032_, Short2ObjectMap<Pair<BlockState, FluidState>> p_76033_, Short2BooleanMap p_76034_) {
        int $$8 = 1000;
        for (Direction $$9 : Direction.Plane.HORIZONTAL) {
            int $$16;
            if ($$9 == p_76030_) continue;
            BlockPos $$10 = p_76028_.relative($$9);
            short $$11 = FlowingFluid.getCacheKey(p_76032_, $$10);
            Pair $$12 = (Pair)p_76033_.computeIfAbsent($$11, p_284932_ -> {
                BlockState $$3 = p_76027_.getBlockState($$10);
                return Pair.of((Object)$$3, (Object)$$3.getFluidState());
            });
            BlockState $$13 = (BlockState)$$12.getFirst();
            FluidState $$14 = (FluidState)$$12.getSecond();
            if (!this.canPassThrough(p_76027_, this.getFlowing(), p_76028_, p_76031_, $$9, $$10, $$13, $$14)) continue;
            boolean $$15 = p_76034_.computeIfAbsent($$11, p_192912_ -> {
                BlockPos $$4 = $$10.below();
                BlockState $$5 = p_76027_.getBlockState($$4);
                return this.isWaterHole(p_76027_, this.getFlowing(), $$10, $$13, $$4, $$5);
            });
            if ($$15) {
                return p_76029_;
            }
            if (p_76029_ >= this.getSlopeFindDistance(p_76027_) || ($$16 = this.getSlopeDistance(p_76027_, $$10, p_76029_ + 1, $$9.getOpposite(), $$13, p_76032_, p_76033_, p_76034_)) >= $$8) continue;
            $$8 = $$16;
        }
        return $$8;
    }

    private boolean isWaterHole(BlockGetter p_75957_, Fluid p_75958_, BlockPos p_75959_, BlockState p_75960_, BlockPos p_75961_, BlockState p_75962_) {
        if (!this.canPassThroughWall(Direction.DOWN, p_75957_, p_75959_, p_75960_, p_75961_, p_75962_)) {
            return false;
        }
        if (p_75962_.getFluidState().getType().isSame(this)) {
            return true;
        }
        return this.canHoldFluid(p_75957_, p_75961_, p_75962_, p_75958_);
    }

    private boolean canPassThrough(BlockGetter p_75964_, Fluid p_75965_, BlockPos p_75966_, BlockState p_75967_, Direction p_75968_, BlockPos p_75969_, BlockState p_75970_, FluidState p_75971_) {
        return !this.isSourceBlockOfThisType(p_75971_) && this.canPassThroughWall(p_75968_, p_75964_, p_75966_, p_75967_, p_75969_, p_75970_) && this.canHoldFluid(p_75964_, p_75969_, p_75970_, p_75965_);
    }

    private boolean isSourceBlockOfThisType(FluidState p_76097_) {
        return p_76097_.getType().isSame(this) && p_76097_.isSource();
    }

    protected abstract int getSlopeFindDistance(LevelReader var1);

    private int sourceNeighborCount(LevelReader p_76020_, BlockPos p_76021_) {
        int $$2 = 0;
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BlockPos $$4 = p_76021_.relative($$3);
            FluidState $$5 = p_76020_.getFluidState($$4);
            if (!this.isSourceBlockOfThisType($$5)) continue;
            ++$$2;
        }
        return $$2;
    }

    protected Map<Direction, FluidState> getSpread(Level p_256191_, BlockPos p_76081_, BlockState p_76082_) {
        int $$3 = 1000;
        EnumMap $$4 = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap $$5 = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap $$6 = new Short2BooleanOpenHashMap();
        for (Direction $$7 : Direction.Plane.HORIZONTAL) {
            int $$17;
            BlockPos $$8 = p_76081_.relative($$7);
            short $$9 = FlowingFluid.getCacheKey(p_76081_, $$8);
            Pair $$10 = (Pair)$$5.computeIfAbsent($$9, p_284929_ -> {
                BlockState $$3 = p_256191_.getBlockState($$8);
                return Pair.of((Object)$$3, (Object)$$3.getFluidState());
            });
            BlockState $$11 = (BlockState)$$10.getFirst();
            FluidState $$12 = (FluidState)$$10.getSecond();
            FluidState $$13 = this.getNewLiquid(p_256191_, $$8, $$11);
            if (!this.canPassThrough(p_256191_, $$13.getType(), p_76081_, p_76082_, $$7, $$8, $$11, $$12)) continue;
            BlockPos $$14 = $$8.below();
            boolean $$15 = $$6.computeIfAbsent($$9, p_255612_ -> {
                BlockState $$5 = p_256191_.getBlockState($$14);
                return this.isWaterHole(p_256191_, this.getFlowing(), $$8, $$11, $$14, $$5);
            });
            if ($$15) {
                boolean $$16 = false;
            } else {
                $$17 = this.getSlopeDistance(p_256191_, $$8, 1, $$7.getOpposite(), $$11, p_76081_, (Short2ObjectMap<Pair<BlockState, FluidState>>)$$5, (Short2BooleanMap)$$6);
            }
            if ($$17 < $$3) {
                $$4.clear();
            }
            if ($$17 > $$3) continue;
            $$4.put($$7, $$13);
            $$3 = $$17;
        }
        return $$4;
    }

    private boolean canHoldFluid(BlockGetter p_75973_, BlockPos p_75974_, BlockState p_75975_, Fluid p_75976_) {
        Block $$4 = p_75975_.getBlock();
        if ($$4 instanceof LiquidBlockContainer) {
            LiquidBlockContainer $$5 = (LiquidBlockContainer)((Object)$$4);
            return $$5.canPlaceLiquid(null, p_75973_, p_75974_, p_75975_, p_75976_);
        }
        if ($$4 instanceof DoorBlock || p_75975_.is(BlockTags.SIGNS) || p_75975_.is(Blocks.LADDER) || p_75975_.is(Blocks.SUGAR_CANE) || p_75975_.is(Blocks.BUBBLE_COLUMN)) {
            return false;
        }
        if (p_75975_.is(Blocks.NETHER_PORTAL) || p_75975_.is(Blocks.END_PORTAL) || p_75975_.is(Blocks.END_GATEWAY) || p_75975_.is(Blocks.STRUCTURE_VOID)) {
            return false;
        }
        return !p_75975_.blocksMotion();
    }

    protected boolean canSpreadTo(BlockGetter p_75978_, BlockPos p_75979_, BlockState p_75980_, Direction p_75981_, BlockPos p_75982_, BlockState p_75983_, FluidState p_75984_, Fluid p_75985_) {
        return p_75984_.canBeReplacedWith(p_75978_, p_75982_, p_75985_, p_75981_) && this.canPassThroughWall(p_75981_, p_75978_, p_75979_, p_75980_, p_75982_, p_75983_) && this.canHoldFluid(p_75978_, p_75982_, p_75983_, p_75985_);
    }

    protected abstract int getDropOff(LevelReader var1);

    protected int getSpreadDelay(Level p_75998_, BlockPos p_75999_, FluidState p_76000_, FluidState p_76001_) {
        return this.getTickDelay(p_75998_);
    }

    @Override
    public void tick(Level p_75995_, BlockPos p_75996_, FluidState p_75997_) {
        if (!p_75997_.isSource()) {
            FluidState $$3 = this.getNewLiquid(p_75995_, p_75996_, p_75995_.getBlockState(p_75996_));
            int $$4 = this.getSpreadDelay(p_75995_, p_75996_, p_75997_, $$3);
            if ($$3.isEmpty()) {
                p_75997_ = $$3;
                p_75995_.setBlock(p_75996_, Blocks.AIR.defaultBlockState(), 3);
            } else if (!$$3.equals(p_75997_)) {
                p_75997_ = $$3;
                BlockState $$5 = p_75997_.createLegacyBlock();
                p_75995_.setBlock(p_75996_, $$5, 2);
                p_75995_.scheduleTick(p_75996_, p_75997_.getType(), $$4);
                p_75995_.updateNeighborsAt(p_75996_, $$5.getBlock());
            }
        }
        this.spread(p_75995_, p_75996_, p_75997_);
    }

    protected static int getLegacyLevel(FluidState p_76093_) {
        if (p_76093_.isSource()) {
            return 0;
        }
        return 8 - Math.min(p_76093_.getAmount(), 8) + (p_76093_.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(FluidState p_76089_, BlockGetter p_76090_, BlockPos p_76091_) {
        return p_76089_.getType().isSame(p_76090_.getFluidState(p_76091_.above()).getType());
    }

    @Override
    public float getHeight(FluidState p_76050_, BlockGetter p_76051_, BlockPos p_76052_) {
        if (FlowingFluid.hasSameAbove(p_76050_, p_76051_, p_76052_)) {
            return 1.0f;
        }
        return p_76050_.getOwnHeight();
    }

    @Override
    public float getOwnHeight(FluidState p_76048_) {
        return (float)p_76048_.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(FluidState var1);

    @Override
    public VoxelShape getShape(FluidState p_76084_, BlockGetter p_76085_, BlockPos p_76086_) {
        if (p_76084_.getAmount() == 9 && FlowingFluid.hasSameAbove(p_76084_, p_76085_, p_76086_)) {
            return Shapes.block();
        }
        return this.shapes.computeIfAbsent(p_76084_, p_76073_ -> Shapes.box(0.0, 0.0, 0.0, 1.0, p_76073_.getHeight(p_76085_, p_76086_), 1.0));
    }
}

