/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.blockpredicates.HasSturdyFacePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlocksPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.NotPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.UnobstructedPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.WouldSurvivePredicate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public interface BlockPredicate
extends BiPredicate<WorldGenLevel, BlockPos> {
    public static final Codec<BlockPredicate> CODEC = BuiltInRegistries.BLOCK_PREDICATE_TYPE.byNameCodec().dispatch(BlockPredicate::type, BlockPredicateType::codec);
    public static final BlockPredicate ONLY_IN_AIR_PREDICATE = BlockPredicate.matchesBlocks(Blocks.AIR);
    public static final BlockPredicate ONLY_IN_AIR_OR_WATER_PREDICATE = BlockPredicate.matchesBlocks(Blocks.AIR, Blocks.WATER);

    public BlockPredicateType<?> type();

    public static BlockPredicate allOf(List<BlockPredicate> p_190413_) {
        return new AllOfPredicate(p_190413_);
    }

    public static BlockPredicate allOf(BlockPredicate ... p_190418_) {
        return BlockPredicate.allOf(List.of(p_190418_));
    }

    public static BlockPredicate allOf(BlockPredicate p_190405_, BlockPredicate p_190406_) {
        return BlockPredicate.allOf(List.of(p_190405_, p_190406_));
    }

    public static BlockPredicate anyOf(List<BlockPredicate> p_190426_) {
        return new AnyOfPredicate(p_190426_);
    }

    public static BlockPredicate anyOf(BlockPredicate ... p_190431_) {
        return BlockPredicate.anyOf(List.of(p_190431_));
    }

    public static BlockPredicate anyOf(BlockPredicate p_190421_, BlockPredicate p_190422_) {
        return BlockPredicate.anyOf(List.of(p_190421_, p_190422_));
    }

    public static BlockPredicate matchesBlocks(Vec3i p_224772_, List<Block> p_224773_) {
        return new MatchingBlocksPredicate(p_224772_, HolderSet.direct(Block::builtInRegistryHolder, p_224773_));
    }

    public static BlockPredicate matchesBlocks(List<Block> p_198312_) {
        return BlockPredicate.matchesBlocks(Vec3i.ZERO, p_198312_);
    }

    public static BlockPredicate matchesBlocks(Vec3i p_224775_, Block ... p_224776_) {
        return BlockPredicate.matchesBlocks(p_224775_, List.of(p_224776_));
    }

    public static BlockPredicate matchesBlocks(Block ... p_224781_) {
        return BlockPredicate.matchesBlocks(Vec3i.ZERO, p_224781_);
    }

    public static BlockPredicate matchesTag(Vec3i p_224769_, TagKey<Block> p_224770_) {
        return new MatchingBlockTagPredicate(p_224769_, p_224770_);
    }

    public static BlockPredicate matchesTag(TagKey<Block> p_204678_) {
        return BlockPredicate.matchesTag(Vec3i.ZERO, p_204678_);
    }

    public static BlockPredicate matchesFluids(Vec3i p_224785_, List<Fluid> p_224786_) {
        return new MatchingFluidsPredicate(p_224785_, HolderSet.direct(Fluid::builtInRegistryHolder, p_224786_));
    }

    public static BlockPredicate matchesFluids(Vec3i p_224778_, Fluid ... p_224779_) {
        return BlockPredicate.matchesFluids(p_224778_, List.of(p_224779_));
    }

    public static BlockPredicate matchesFluids(Fluid ... p_224783_) {
        return BlockPredicate.matchesFluids(Vec3i.ZERO, p_224783_);
    }

    public static BlockPredicate not(BlockPredicate p_190403_) {
        return new NotPredicate(p_190403_);
    }

    public static BlockPredicate replaceable(Vec3i p_190411_) {
        return new ReplaceablePredicate(p_190411_);
    }

    public static BlockPredicate replaceable() {
        return BlockPredicate.replaceable(Vec3i.ZERO);
    }

    public static BlockPredicate wouldSurvive(BlockState p_190400_, Vec3i p_190401_) {
        return new WouldSurvivePredicate(p_190401_, p_190400_);
    }

    public static BlockPredicate hasSturdyFace(Vec3i p_198309_, Direction p_198310_) {
        return new HasSturdyFacePredicate(p_198309_, p_198310_);
    }

    public static BlockPredicate hasSturdyFace(Direction p_198914_) {
        return BlockPredicate.hasSturdyFace(Vec3i.ZERO, p_198914_);
    }

    public static BlockPredicate solid(Vec3i p_190424_) {
        return new SolidPredicate(p_190424_);
    }

    public static BlockPredicate solid() {
        return BlockPredicate.solid(Vec3i.ZERO);
    }

    public static BlockPredicate noFluid() {
        return BlockPredicate.noFluid(Vec3i.ZERO);
    }

    public static BlockPredicate noFluid(Vec3i p_249383_) {
        return BlockPredicate.matchesFluids(p_249383_, Fluids.EMPTY);
    }

    public static BlockPredicate insideWorld(Vec3i p_190434_) {
        return new InsideWorldBoundsPredicate(p_190434_);
    }

    public static BlockPredicate alwaysTrue() {
        return TrueBlockPredicate.INSTANCE;
    }

    public static BlockPredicate unobstructed(Vec3i p_345358_) {
        return new UnobstructedPredicate(p_345358_);
    }

    public static BlockPredicate unobstructed() {
        return BlockPredicate.unobstructed(Vec3i.ZERO);
    }
}

