/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum Rarity implements StringRepresentable
{
    COMMON(0, "common", ChatFormatting.WHITE),
    UNCOMMON(1, "uncommon", ChatFormatting.YELLOW),
    RARE(2, "rare", ChatFormatting.AQUA),
    EPIC(3, "epic", ChatFormatting.LIGHT_PURPLE);

    public static final Codec<Rarity> CODEC;
    public static final IntFunction<Rarity> BY_ID;
    public static final StreamCodec<ByteBuf, Rarity> STREAM_CODEC;
    private final int id;
    private final String name;
    private final ChatFormatting color;

    private Rarity(int p_336096_, String p_335642_, ChatFormatting p_43028_) {
        this.id = p_336096_;
        this.name = p_335642_;
        this.color = p_43028_;
    }

    public ChatFormatting color() {
        return this.color;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromValues(Rarity::values);
        BY_ID = ByIdMap.continuous(p_335877_ -> p_335877_.id, Rarity.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, p_335484_ -> p_335484_.id);
    }
}

