/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Map;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class HttpUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Path downloadFile(Path p_314509_, URL p_314583_, Map<String, String> p_314414_, HashFunction p_314462_, @Nullable HashCode p_314495_, int p_314514_, Proxy p_314631_, DownloadProgressListener p_314610_) {
        InputStream $$9;
        HttpURLConnection $$8;
        block21: {
            $$8 = null;
            $$9 = null;
            p_314610_.requestStart();
            if (p_314495_ != null) {
                Path $$10 = HttpUtil.cachedFilePath(p_314509_, p_314495_);
                try {
                    if (HttpUtil.checkExistingFile($$10, p_314462_, p_314495_)) {
                        LOGGER.info("Returning cached file since actual hash matches requested");
                        p_314610_.requestFinished(true);
                        HttpUtil.updateModificationTime($$10);
                        return $$10;
                    }
                }
                catch (IOException $$11) {
                    LOGGER.warn("Failed to check cached file {}", (Object)$$10, (Object)$$11);
                }
                try {
                    LOGGER.warn("Existing file {} not found or had mismatched hash", (Object)$$10);
                    Files.deleteIfExists($$10);
                }
                catch (IOException $$12) {
                    p_314610_.requestFinished(false);
                    throw new UncheckedIOException("Failed to remove existing file " + String.valueOf($$10), $$12);
                }
            }
            Path $$13 = null;
            $$8 = (HttpURLConnection)p_314583_.openConnection(p_314631_);
            $$8.setInstanceFollowRedirects(true);
            p_314414_.forEach($$8::setRequestProperty);
            $$9 = $$8.getInputStream();
            long $$14 = $$8.getContentLengthLong();
            OptionalLong $$15 = $$14 != -1L ? OptionalLong.of($$14) : OptionalLong.empty();
            FileUtil.createDirectoriesSafe(p_314509_);
            p_314610_.downloadStart($$15);
            if ($$15.isPresent() && $$15.getAsLong() > (long)p_314514_) {
                throw new IOException("Filesize is bigger than maximum allowed (file is " + String.valueOf($$15) + ", limit is " + p_314514_ + ")");
            }
            if ($$13 == null) break block21;
            HashCode $$16 = HttpUtil.downloadAndHash(p_314462_, p_314514_, p_314610_, $$9, $$13);
            if (!$$16.equals((Object)p_314495_)) {
                throw new IOException("Hash of downloaded file (" + String.valueOf($$16) + ") did not match requested (" + String.valueOf(p_314495_) + ")");
            }
            p_314610_.requestFinished(true);
            Path path = $$13;
            IOUtils.closeQuietly((InputStream)$$9);
            return path;
        }
        Path $$17 = Files.createTempFile(p_314509_, "download", ".tmp", new FileAttribute[0]);
        HashCode $$18 = HttpUtil.downloadAndHash(p_314462_, p_314514_, p_314610_, $$9, $$17);
        Path $$19 = HttpUtil.cachedFilePath(p_314509_, $$18);
        if (!HttpUtil.checkExistingFile($$19, p_314462_, $$18)) {
            Files.move($$17, $$19, StandardCopyOption.REPLACE_EXISTING);
        } else {
            HttpUtil.updateModificationTime($$19);
        }
        p_314610_.requestFinished(true);
        Path path = $$19;
        Files.deleteIfExists($$17);
        IOUtils.closeQuietly((InputStream)$$9);
        return path;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Files.deleteIfExists($$17);
                        throw throwable;
                    }
                    catch (Throwable $$20) {
                        InputStream $$21;
                        if ($$8 != null && ($$21 = $$8.getErrorStream()) != null) {
                            try {
                                LOGGER.error("HTTP response error: {}", (Object)IOUtils.toString((InputStream)$$21, (Charset)StandardCharsets.UTF_8));
                            }
                            catch (Exception $$22) {
                                LOGGER.error("Failed to read response from server");
                            }
                        }
                        p_314610_.requestFinished(false);
                        throw new IllegalStateException("Failed to download file " + String.valueOf(p_314583_), $$20);
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly($$9);
                    throw throwable2;
                }
            }
        }
    }

    private static void updateModificationTime(Path p_314996_) {
        try {
            Files.setLastModifiedTime(p_314996_, FileTime.from(Instant.now()));
        }
        catch (IOException $$1) {
            LOGGER.warn("Failed to update modification time of {}", (Object)p_314996_, (Object)$$1);
        }
    }

    private static HashCode hashFile(Path p_314478_, HashFunction p_314630_) throws IOException {
        Hasher $$2 = p_314630_.newHasher();
        try (OutputStream $$3 = Funnels.asOutputStream((PrimitiveSink)$$2);
             InputStream $$4 = Files.newInputStream(p_314478_, new OpenOption[0]);){
            $$4.transferTo($$3);
        }
        return $$2.hash();
    }

    private static boolean checkExistingFile(Path p_314420_, HashFunction p_314503_, HashCode p_314584_) throws IOException {
        if (Files.exists(p_314420_, new LinkOption[0])) {
            HashCode $$3 = HttpUtil.hashFile(p_314420_, p_314503_);
            if ($$3.equals((Object)p_314584_)) {
                return true;
            }
            LOGGER.warn("Mismatched hash of file {}, expected {} but found {}", new Object[]{p_314420_, p_314584_, $$3});
        }
        return false;
    }

    private static Path cachedFilePath(Path p_314479_, HashCode p_314627_) {
        return p_314479_.resolve(p_314627_.toString());
    }

    private static HashCode downloadAndHash(HashFunction p_314429_, int p_314497_, DownloadProgressListener p_314419_, InputStream p_314557_, Path p_314618_) throws IOException {
        try (OutputStream $$5 = Files.newOutputStream(p_314618_, StandardOpenOption.CREATE);){
            int $$9;
            Hasher $$6 = p_314429_.newHasher();
            byte[] $$7 = new byte[8196];
            long $$8 = 0L;
            while (($$9 = p_314557_.read($$7)) >= 0) {
                p_314419_.downloadedBytes($$8 += (long)$$9);
                if ($$8 > (long)p_314497_) {
                    throw new IOException("Filesize was bigger than maximum allowed (got >= " + $$8 + ", limit was " + p_314497_ + ")");
                }
                if (Thread.interrupted()) {
                    LOGGER.error("INTERRUPTED");
                    throw new IOException("Download interrupted");
                }
                $$5.write($$7, 0, $$9);
                $$6.putBytes($$7, 0, $$9);
            }
            HashCode hashCode = $$6.hash();
            return hashCode;
        }
    }

    public static int getAvailablePort() {
        int n;
        ServerSocket $$0 = new ServerSocket(0);
        try {
            n = $$0.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$0.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$1) {
                return 25564;
            }
        }
        $$0.close();
        return n;
    }

    public static boolean isPortAvailable(int p_259872_) {
        boolean bl;
        if (p_259872_ < 0 || p_259872_ > 65535) {
            return false;
        }
        ServerSocket $$1 = new ServerSocket(p_259872_);
        try {
            bl = $$1.getLocalPort() == p_259872_;
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$2) {
                return false;
            }
        }
        $$1.close();
        return bl;
    }

    public static interface DownloadProgressListener {
        public void requestStart();

        public void downloadStart(OptionalLong var1);

        public void downloadedBytes(long var1);

        public void requestFinished(boolean var1);
    }
}

