/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public record BlockDataSource(String posPattern, @Nullable Coordinates compiledPos) implements DataSource
{
    public static final MapCodec<BlockDataSource> SUB_CODEC = RecordCodecBuilder.mapCodec(p_304487_ -> p_304487_.group((App)Codec.STRING.fieldOf("block").forGetter(BlockDataSource::posPattern)).apply((Applicative)p_304487_, BlockDataSource::new));
    public static final DataSource.Type<BlockDataSource> TYPE = new DataSource.Type<BlockDataSource>(SUB_CODEC, "block");

    public BlockDataSource(String p_237312_) {
        this(p_237312_, BlockDataSource.compilePos(p_237312_));
    }

    @Nullable
    private static Coordinates compilePos(String p_237318_) {
        try {
            return BlockPosArgument.blockPos().parse(new StringReader(p_237318_));
        }
        catch (CommandSyntaxException $$1) {
            return null;
        }
    }

    @Override
    public Stream<CompoundTag> getData(CommandSourceStack p_237323_) {
        BlockEntity $$3;
        BlockPos $$2;
        ServerLevel $$1;
        if (this.compiledPos != null && ($$1 = p_237323_.getLevel()).isLoaded($$2 = this.compiledPos.getBlockPos(p_237323_)) && ($$3 = $$1.getBlockEntity($$2)) != null) {
            return Stream.of($$3.saveWithFullMetadata(p_237323_.registryAccess()));
        }
        return Stream.empty();
    }

    @Override
    public DataSource.Type<?> type() {
        return TYPE;
    }

    @Override
    public String toString() {
        return "block=" + this.posPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object p_237321_) {
        if (this == p_237321_) {
            return true;
        }
        if (!(p_237321_ instanceof BlockDataSource)) return false;
        BlockDataSource $$1 = (BlockDataSource)p_237321_;
        if (!this.posPattern.equals($$1.posPattern)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.posPattern.hashCode();
    }
}

