/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.PotDecorations;

public class DecoratedPotRenderer
implements BlockEntityRenderer<DecoratedPotBlockEntity> {
    private static final String NECK = "neck";
    private static final String FRONT = "front";
    private static final String BACK = "back";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;
    private static final float WOBBLE_AMPLITUDE = 0.125f;

    public DecoratedPotRenderer(BlockEntityRendererProvider.Context p_272872_) {
        ModelPart $$1 = p_272872_.bakeLayer(ModelLayers.DECORATED_POT_BASE);
        this.neck = $$1.getChild(NECK);
        this.top = $$1.getChild(TOP);
        this.bottom = $$1.getChild(BOTTOM);
        ModelPart $$2 = p_272872_.bakeLayer(ModelLayers.DECORATED_POT_SIDES);
        this.frontSide = $$2.getChild(FRONT);
        this.backSide = $$2.getChild(BACK);
        this.leftSide = $$2.getChild(LEFT);
        this.rightSide = $$2.getChild(RIGHT);
    }

    public static LayerDefinition createBaseLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        CubeDeformation $$2 = new CubeDeformation(0.2f);
        CubeDeformation $$3 = new CubeDeformation(-0.1f);
        $$1.addOrReplaceChild(NECK, CubeListBuilder.create().texOffs(0, 0).addBox(4.0f, 17.0f, 4.0f, 8.0f, 3.0f, 8.0f, $$3).texOffs(0, 5).addBox(5.0f, 20.0f, 5.0f, 6.0f, 1.0f, 6.0f, $$2), PartPose.offsetAndRotation(0.0f, 37.0f, 16.0f, (float)Math.PI, 0.0f, 0.0f));
        CubeListBuilder $$4 = CubeListBuilder.create().texOffs(-14, 13).addBox(0.0f, 0.0f, 0.0f, 14.0f, 0.0f, 14.0f);
        $$1.addOrReplaceChild(TOP, $$4, PartPose.offsetAndRotation(1.0f, 16.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        $$1.addOrReplaceChild(BOTTOM, $$4, PartPose.offsetAndRotation(1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        return LayerDefinition.create($$0, 32, 32);
    }

    public static LayerDefinition createSidesLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        CubeListBuilder $$2 = CubeListBuilder.create().texOffs(1, 0).addBox(0.0f, 0.0f, 0.0f, 14.0f, 16.0f, 0.0f, EnumSet.of(Direction.NORTH));
        $$1.addOrReplaceChild(BACK, $$2, PartPose.offsetAndRotation(15.0f, 16.0f, 1.0f, 0.0f, 0.0f, (float)Math.PI));
        $$1.addOrReplaceChild(LEFT, $$2, PartPose.offsetAndRotation(1.0f, 16.0f, 1.0f, 0.0f, -1.5707964f, (float)Math.PI));
        $$1.addOrReplaceChild(RIGHT, $$2, PartPose.offsetAndRotation(15.0f, 16.0f, 15.0f, 0.0f, 1.5707964f, (float)Math.PI));
        $$1.addOrReplaceChild(FRONT, $$2, PartPose.offsetAndRotation(1.0f, 16.0f, 15.0f, (float)Math.PI, 0.0f, 0.0f));
        return LayerDefinition.create($$0, 16, 16);
    }

    private static Material getSideMaterial(Optional<Item> p_347523_) {
        Material $$1;
        if (p_347523_.isPresent() && ($$1 = Sheets.getDecoratedPotMaterial(DecoratedPotPatterns.getPatternFromItem(p_347523_.get()))) != null) {
            return $$1;
        }
        return Sheets.DECORATED_POT_SIDE;
    }

    @Override
    public void render(DecoratedPotBlockEntity p_273776_, float p_273103_, PoseStack p_273455_, MultiBufferSource p_273010_, int p_273407_, int p_273059_) {
        float $$8;
        p_273455_.pushPose();
        Direction $$6 = p_273776_.getDirection();
        p_273455_.translate(0.5, 0.0, 0.5);
        p_273455_.mulPose(Axis.YP.rotationDegrees(180.0f - $$6.toYRot()));
        p_273455_.translate(-0.5, 0.0, -0.5);
        DecoratedPotBlockEntity.WobbleStyle $$7 = p_273776_.lastWobbleStyle;
        if ($$7 != null && p_273776_.getLevel() != null && ($$8 = ((float)(p_273776_.getLevel().getGameTime() - p_273776_.wobbleStartedAtTick) + p_273103_) / (float)$$7.duration) >= 0.0f && $$8 <= 1.0f) {
            if ($$7 == DecoratedPotBlockEntity.WobbleStyle.POSITIVE) {
                float $$9 = 0.015625f;
                float $$10 = $$8 * ((float)Math.PI * 2);
                float $$11 = -1.5f * (Mth.cos($$10) + 0.5f) * Mth.sin($$10 / 2.0f);
                p_273455_.rotateAround(Axis.XP.rotation($$11 * 0.015625f), 0.5f, 0.0f, 0.5f);
                float $$12 = Mth.sin($$10);
                p_273455_.rotateAround(Axis.ZP.rotation($$12 * 0.015625f), 0.5f, 0.0f, 0.5f);
            } else {
                float $$13 = Mth.sin(-$$8 * 3.0f * (float)Math.PI) * 0.125f;
                float $$14 = 1.0f - $$8;
                p_273455_.rotateAround(Axis.YP.rotation($$13 * $$14), 0.5f, 0.0f, 0.5f);
            }
        }
        VertexConsumer $$15 = Sheets.DECORATED_POT_BASE.buffer(p_273010_, RenderType::entitySolid);
        this.neck.render(p_273455_, $$15, p_273407_, p_273059_);
        this.top.render(p_273455_, $$15, p_273407_, p_273059_);
        this.bottom.render(p_273455_, $$15, p_273407_, p_273059_);
        PotDecorations $$16 = p_273776_.getDecorations();
        this.renderSide(this.frontSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getSideMaterial($$16.front()));
        this.renderSide(this.backSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getSideMaterial($$16.back()));
        this.renderSide(this.leftSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getSideMaterial($$16.left()));
        this.renderSide(this.rightSide, p_273455_, p_273010_, p_273407_, p_273059_, DecoratedPotRenderer.getSideMaterial($$16.right()));
        p_273455_.popPose();
    }

    private void renderSide(ModelPart p_273495_, PoseStack p_272899_, MultiBufferSource p_273582_, int p_273242_, int p_273108_, Material p_273173_) {
        p_273495_.render(p_272899_, p_273173_.buffer(p_273582_, RenderType::entitySolid), p_273242_, p_273108_);
    }
}

