/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ModelBlockRenderer {
    private static final int FACE_CUBIC = 0;
    private static final int FACE_PARTIAL = 1;
    static final Direction[] DIRECTIONS = Direction.values();
    private final BlockColors blockColors;
    private static final int CACHE_SIZE = 100;
    static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(Cache::new);

    public ModelBlockRenderer(BlockColors p_110999_) {
        this.blockColors = p_110999_;
    }

    public void tesselateBlock(BlockAndTintGetter p_234380_, BakedModel p_234381_, BlockState p_234382_, BlockPos p_234383_, PoseStack p_234384_, VertexConsumer p_234385_, boolean p_234386_, RandomSource p_234387_, long p_234388_, int p_234389_) {
        boolean $$10 = Minecraft.useAmbientOcclusion() && p_234382_.getLightEmission() == 0 && p_234381_.useAmbientOcclusion();
        Vec3 $$11 = p_234382_.getOffset(p_234380_, p_234383_);
        p_234384_.translate($$11.x, $$11.y, $$11.z);
        try {
            if ($$10) {
                this.tesselateWithAO(p_234380_, p_234381_, p_234382_, p_234383_, p_234384_, p_234385_, p_234386_, p_234387_, p_234388_, p_234389_);
            } else {
                this.tesselateWithoutAO(p_234380_, p_234381_, p_234382_, p_234383_, p_234384_, p_234385_, p_234386_, p_234387_, p_234388_, p_234389_);
            }
        }
        catch (Throwable $$12) {
            CrashReport $$13 = CrashReport.forThrowable($$12, "Tesselating block model");
            CrashReportCategory $$14 = $$13.addCategory("Block model being tesselated");
            CrashReportCategory.populateBlockDetails($$14, p_234380_, p_234383_, p_234382_);
            $$14.setDetail("Using AO", $$10);
            throw new ReportedException($$13);
        }
    }

    public void tesselateWithAO(BlockAndTintGetter p_234391_, BakedModel p_234392_, BlockState p_234393_, BlockPos p_234394_, PoseStack p_234395_, VertexConsumer p_234396_, boolean p_234397_, RandomSource p_234398_, long p_234399_, int p_234400_) {
        float[] $$10 = new float[DIRECTIONS.length * 2];
        BitSet $$11 = new BitSet(3);
        AmbientOcclusionFace $$12 = new AmbientOcclusionFace();
        BlockPos.MutableBlockPos $$13 = p_234394_.mutable();
        for (Direction $$14 : DIRECTIONS) {
            p_234398_.setSeed(p_234399_);
            List<BakedQuad> $$15 = p_234392_.getQuads(p_234393_, $$14, p_234398_);
            if ($$15.isEmpty()) continue;
            $$13.setWithOffset((Vec3i)p_234394_, $$14);
            if (p_234397_ && !Block.shouldRenderFace(p_234393_, p_234391_, p_234394_, $$14, $$13)) continue;
            this.renderModelFaceAO(p_234391_, p_234393_, p_234394_, p_234395_, p_234396_, $$15, $$10, $$11, $$12, p_234400_);
        }
        p_234398_.setSeed(p_234399_);
        List<BakedQuad> $$16 = p_234392_.getQuads(p_234393_, null, p_234398_);
        if (!$$16.isEmpty()) {
            this.renderModelFaceAO(p_234391_, p_234393_, p_234394_, p_234395_, p_234396_, $$16, $$10, $$11, $$12, p_234400_);
        }
    }

    public void tesselateWithoutAO(BlockAndTintGetter p_234402_, BakedModel p_234403_, BlockState p_234404_, BlockPos p_234405_, PoseStack p_234406_, VertexConsumer p_234407_, boolean p_234408_, RandomSource p_234409_, long p_234410_, int p_234411_) {
        BitSet $$10 = new BitSet(3);
        BlockPos.MutableBlockPos $$11 = p_234405_.mutable();
        for (Direction $$12 : DIRECTIONS) {
            p_234409_.setSeed(p_234410_);
            List<BakedQuad> $$13 = p_234403_.getQuads(p_234404_, $$12, p_234409_);
            if ($$13.isEmpty()) continue;
            $$11.setWithOffset((Vec3i)p_234405_, $$12);
            if (p_234408_ && !Block.shouldRenderFace(p_234404_, p_234402_, p_234405_, $$12, $$11)) continue;
            int $$14 = LevelRenderer.getLightColor(p_234402_, p_234404_, $$11);
            this.renderModelFaceFlat(p_234402_, p_234404_, p_234405_, $$14, p_234411_, false, p_234406_, p_234407_, $$13, $$10);
        }
        p_234409_.setSeed(p_234410_);
        List<BakedQuad> $$15 = p_234403_.getQuads(p_234404_, null, p_234409_);
        if (!$$15.isEmpty()) {
            this.renderModelFaceFlat(p_234402_, p_234404_, p_234405_, -1, p_234411_, true, p_234406_, p_234407_, $$15, $$10);
        }
    }

    private void renderModelFaceAO(BlockAndTintGetter p_111013_, BlockState p_111014_, BlockPos p_111015_, PoseStack p_111016_, VertexConsumer p_111017_, List<BakedQuad> p_111018_, float[] p_111019_, BitSet p_111020_, AmbientOcclusionFace p_111021_, int p_111022_) {
        for (BakedQuad $$10 : p_111018_) {
            this.calculateShape(p_111013_, p_111014_, p_111015_, $$10.getVertices(), $$10.getDirection(), p_111019_, p_111020_);
            p_111021_.calculate(p_111013_, p_111014_, p_111015_, $$10.getDirection(), p_111019_, p_111020_, $$10.isShade());
            this.putQuadData(p_111013_, p_111014_, p_111015_, p_111017_, p_111016_.last(), $$10, p_111021_.brightness[0], p_111021_.brightness[1], p_111021_.brightness[2], p_111021_.brightness[3], p_111021_.lightmap[0], p_111021_.lightmap[1], p_111021_.lightmap[2], p_111021_.lightmap[3], p_111022_);
        }
    }

    private void putQuadData(BlockAndTintGetter p_111024_, BlockState p_111025_, BlockPos p_111026_, VertexConsumer p_111027_, PoseStack.Pose p_111028_, BakedQuad p_111029_, float p_111030_, float p_111031_, float p_111032_, float p_111033_, int p_111034_, int p_111035_, int p_111036_, int p_111037_, int p_111038_) {
        float $$21;
        float $$20;
        float $$19;
        if (p_111029_.isTinted()) {
            int $$15 = this.blockColors.getColor(p_111025_, p_111024_, p_111026_, p_111029_.getTintIndex());
            float $$16 = (float)($$15 >> 16 & 0xFF) / 255.0f;
            float $$17 = (float)($$15 >> 8 & 0xFF) / 255.0f;
            float $$18 = (float)($$15 & 0xFF) / 255.0f;
        } else {
            $$19 = 1.0f;
            $$20 = 1.0f;
            $$21 = 1.0f;
        }
        p_111027_.putBulkData(p_111028_, p_111029_, new float[]{p_111030_, p_111031_, p_111032_, p_111033_}, $$19, $$20, $$21, 1.0f, new int[]{p_111034_, p_111035_, p_111036_, p_111037_}, p_111038_, true);
    }

    private void calculateShape(BlockAndTintGetter p_111040_, BlockState p_111041_, BlockPos p_111042_, int[] p_111043_, Direction p_111044_, @Nullable float[] p_111045_, BitSet p_111046_) {
        float $$7 = 32.0f;
        float $$8 = 32.0f;
        float $$9 = 32.0f;
        float $$10 = -32.0f;
        float $$11 = -32.0f;
        float $$12 = -32.0f;
        for (int $$13 = 0; $$13 < 4; ++$$13) {
            float $$14 = Float.intBitsToFloat(p_111043_[$$13 * 8]);
            float $$15 = Float.intBitsToFloat(p_111043_[$$13 * 8 + 1]);
            float $$16 = Float.intBitsToFloat(p_111043_[$$13 * 8 + 2]);
            $$7 = Math.min($$7, $$14);
            $$8 = Math.min($$8, $$15);
            $$9 = Math.min($$9, $$16);
            $$10 = Math.max($$10, $$14);
            $$11 = Math.max($$11, $$15);
            $$12 = Math.max($$12, $$16);
        }
        if (p_111045_ != null) {
            p_111045_[Direction.WEST.get3DDataValue()] = $$7;
            p_111045_[Direction.EAST.get3DDataValue()] = $$10;
            p_111045_[Direction.DOWN.get3DDataValue()] = $$8;
            p_111045_[Direction.UP.get3DDataValue()] = $$11;
            p_111045_[Direction.NORTH.get3DDataValue()] = $$9;
            p_111045_[Direction.SOUTH.get3DDataValue()] = $$12;
            int $$17 = DIRECTIONS.length;
            p_111045_[Direction.WEST.get3DDataValue() + $$17] = 1.0f - $$7;
            p_111045_[Direction.EAST.get3DDataValue() + $$17] = 1.0f - $$10;
            p_111045_[Direction.DOWN.get3DDataValue() + $$17] = 1.0f - $$8;
            p_111045_[Direction.UP.get3DDataValue() + $$17] = 1.0f - $$11;
            p_111045_[Direction.NORTH.get3DDataValue() + $$17] = 1.0f - $$9;
            p_111045_[Direction.SOUTH.get3DDataValue() + $$17] = 1.0f - $$12;
        }
        float $$18 = 1.0E-4f;
        float $$19 = 0.9999f;
        switch (p_111044_) {
            case DOWN: {
                p_111046_.set(1, $$7 >= 1.0E-4f || $$9 >= 1.0E-4f || $$10 <= 0.9999f || $$12 <= 0.9999f);
                p_111046_.set(0, $$8 == $$11 && ($$8 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case UP: {
                p_111046_.set(1, $$7 >= 1.0E-4f || $$9 >= 1.0E-4f || $$10 <= 0.9999f || $$12 <= 0.9999f);
                p_111046_.set(0, $$8 == $$11 && ($$11 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case NORTH: {
                p_111046_.set(1, $$7 >= 1.0E-4f || $$8 >= 1.0E-4f || $$10 <= 0.9999f || $$11 <= 0.9999f);
                p_111046_.set(0, $$9 == $$12 && ($$9 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case SOUTH: {
                p_111046_.set(1, $$7 >= 1.0E-4f || $$8 >= 1.0E-4f || $$10 <= 0.9999f || $$11 <= 0.9999f);
                p_111046_.set(0, $$9 == $$12 && ($$12 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case WEST: {
                p_111046_.set(1, $$8 >= 1.0E-4f || $$9 >= 1.0E-4f || $$11 <= 0.9999f || $$12 <= 0.9999f);
                p_111046_.set(0, $$7 == $$10 && ($$7 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case EAST: {
                p_111046_.set(1, $$8 >= 1.0E-4f || $$9 >= 1.0E-4f || $$11 <= 0.9999f || $$12 <= 0.9999f);
                p_111046_.set(0, $$7 == $$10 && ($$10 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
            }
        }
    }

    private void renderModelFaceFlat(BlockAndTintGetter p_111002_, BlockState p_111003_, BlockPos p_111004_, int p_111005_, int p_111006_, boolean p_111007_, PoseStack p_111008_, VertexConsumer p_111009_, List<BakedQuad> p_111010_, BitSet p_111011_) {
        for (BakedQuad $$10 : p_111010_) {
            if (p_111007_) {
                this.calculateShape(p_111002_, p_111003_, p_111004_, $$10.getVertices(), $$10.getDirection(), null, p_111011_);
                BlockPos $$11 = p_111011_.get(0) ? p_111004_.relative($$10.getDirection()) : p_111004_;
                p_111005_ = LevelRenderer.getLightColor(p_111002_, p_111003_, $$11);
            }
            float $$12 = p_111002_.getShade($$10.getDirection(), $$10.isShade());
            this.putQuadData(p_111002_, p_111003_, p_111004_, p_111009_, p_111008_.last(), $$10, $$12, $$12, $$12, $$12, p_111005_, p_111005_, p_111005_, p_111005_, p_111006_);
        }
    }

    public void renderModel(PoseStack.Pose p_111068_, VertexConsumer p_111069_, @Nullable BlockState p_111070_, BakedModel p_111071_, float p_111072_, float p_111073_, float p_111074_, int p_111075_, int p_111076_) {
        RandomSource $$9 = RandomSource.create();
        long $$10 = 42L;
        for (Direction $$11 : DIRECTIONS) {
            $$9.setSeed(42L);
            ModelBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, p_111071_.getQuads(p_111070_, $$11, $$9), p_111075_, p_111076_);
        }
        $$9.setSeed(42L);
        ModelBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, p_111071_.getQuads(p_111070_, null, $$9), p_111075_, p_111076_);
    }

    private static void renderQuadList(PoseStack.Pose p_111059_, VertexConsumer p_111060_, float p_111061_, float p_111062_, float p_111063_, List<BakedQuad> p_111064_, int p_111065_, int p_111066_) {
        for (BakedQuad $$8 : p_111064_) {
            float $$14;
            float $$13;
            float $$12;
            if ($$8.isTinted()) {
                float $$9 = Mth.clamp(p_111061_, 0.0f, 1.0f);
                float $$10 = Mth.clamp(p_111062_, 0.0f, 1.0f);
                float $$11 = Mth.clamp(p_111063_, 0.0f, 1.0f);
            } else {
                $$12 = 1.0f;
                $$13 = 1.0f;
                $$14 = 1.0f;
            }
            p_111060_.putBulkData(p_111059_, $$8, $$12, $$13, $$14, 1.0f, p_111065_, p_111066_);
        }
    }

    public static void enableCaching() {
        CACHE.get().enable();
    }

    public static void clearCache() {
        CACHE.get().disable();
    }

    static class AmbientOcclusionFace {
        final float[] brightness = new float[4];
        final int[] lightmap = new int[4];

        public void calculate(BlockAndTintGetter p_111168_, BlockState p_111169_, BlockPos p_111170_, Direction p_111171_, float[] p_111172_, BitSet p_111173_, boolean p_111174_) {
            int $$50;
            float $$49;
            int $$45;
            float $$44;
            int $$40;
            float $$39;
            int $$35;
            float $$34;
            boolean $$30;
            BlockPos $$7 = p_111173_.get(0) ? p_111170_.relative(p_111171_) : p_111170_;
            AdjacencyInfo $$8 = AdjacencyInfo.fromFacing(p_111171_);
            BlockPos.MutableBlockPos $$9 = new BlockPos.MutableBlockPos();
            Cache $$10 = CACHE.get();
            $$9.setWithOffset((Vec3i)$$7, $$8.corners[0]);
            BlockState $$11 = p_111168_.getBlockState($$9);
            int $$12 = $$10.getLightColor($$11, p_111168_, $$9);
            float $$13 = $$10.getShadeBrightness($$11, p_111168_, $$9);
            $$9.setWithOffset((Vec3i)$$7, $$8.corners[1]);
            BlockState $$14 = p_111168_.getBlockState($$9);
            int $$15 = $$10.getLightColor($$14, p_111168_, $$9);
            float $$16 = $$10.getShadeBrightness($$14, p_111168_, $$9);
            $$9.setWithOffset((Vec3i)$$7, $$8.corners[2]);
            BlockState $$17 = p_111168_.getBlockState($$9);
            int $$18 = $$10.getLightColor($$17, p_111168_, $$9);
            float $$19 = $$10.getShadeBrightness($$17, p_111168_, $$9);
            $$9.setWithOffset((Vec3i)$$7, $$8.corners[3]);
            BlockState $$20 = p_111168_.getBlockState($$9);
            int $$21 = $$10.getLightColor($$20, p_111168_, $$9);
            float $$22 = $$10.getShadeBrightness($$20, p_111168_, $$9);
            BlockState $$23 = p_111168_.getBlockState($$9.setWithOffset((Vec3i)$$7, $$8.corners[0]).move(p_111171_));
            boolean $$24 = !$$23.isViewBlocking(p_111168_, $$9) || $$23.getLightBlock(p_111168_, $$9) == 0;
            BlockState $$25 = p_111168_.getBlockState($$9.setWithOffset((Vec3i)$$7, $$8.corners[1]).move(p_111171_));
            boolean $$26 = !$$25.isViewBlocking(p_111168_, $$9) || $$25.getLightBlock(p_111168_, $$9) == 0;
            BlockState $$27 = p_111168_.getBlockState($$9.setWithOffset((Vec3i)$$7, $$8.corners[2]).move(p_111171_));
            boolean $$28 = !$$27.isViewBlocking(p_111168_, $$9) || $$27.getLightBlock(p_111168_, $$9) == 0;
            BlockState $$29 = p_111168_.getBlockState($$9.setWithOffset((Vec3i)$$7, $$8.corners[3]).move(p_111171_));
            boolean bl = $$30 = !$$29.isViewBlocking(p_111168_, $$9) || $$29.getLightBlock(p_111168_, $$9) == 0;
            if ($$28 || $$24) {
                $$9.setWithOffset((Vec3i)$$7, $$8.corners[0]).move($$8.corners[2]);
                BlockState $$31 = p_111168_.getBlockState($$9);
                float $$32 = $$10.getShadeBrightness($$31, p_111168_, $$9);
                int $$33 = $$10.getLightColor($$31, p_111168_, $$9);
            } else {
                $$34 = $$13;
                $$35 = $$12;
            }
            if ($$30 || $$24) {
                $$9.setWithOffset((Vec3i)$$7, $$8.corners[0]).move($$8.corners[3]);
                BlockState $$36 = p_111168_.getBlockState($$9);
                float $$37 = $$10.getShadeBrightness($$36, p_111168_, $$9);
                int $$38 = $$10.getLightColor($$36, p_111168_, $$9);
            } else {
                $$39 = $$13;
                $$40 = $$12;
            }
            if ($$28 || $$26) {
                $$9.setWithOffset((Vec3i)$$7, $$8.corners[1]).move($$8.corners[2]);
                BlockState $$41 = p_111168_.getBlockState($$9);
                float $$42 = $$10.getShadeBrightness($$41, p_111168_, $$9);
                int $$43 = $$10.getLightColor($$41, p_111168_, $$9);
            } else {
                $$44 = $$13;
                $$45 = $$12;
            }
            if ($$30 || $$26) {
                $$9.setWithOffset((Vec3i)$$7, $$8.corners[1]).move($$8.corners[3]);
                BlockState $$46 = p_111168_.getBlockState($$9);
                float $$47 = $$10.getShadeBrightness($$46, p_111168_, $$9);
                int $$48 = $$10.getLightColor($$46, p_111168_, $$9);
            } else {
                $$49 = $$13;
                $$50 = $$12;
            }
            int $$51 = $$10.getLightColor(p_111169_, p_111168_, p_111170_);
            $$9.setWithOffset((Vec3i)p_111170_, p_111171_);
            BlockState $$52 = p_111168_.getBlockState($$9);
            if (p_111173_.get(0) || !$$52.isSolidRender(p_111168_, $$9)) {
                $$51 = $$10.getLightColor($$52, p_111168_, $$9);
            }
            float $$53 = p_111173_.get(0) ? $$10.getShadeBrightness(p_111168_.getBlockState($$7), p_111168_, $$7) : $$10.getShadeBrightness(p_111168_.getBlockState(p_111170_), p_111168_, p_111170_);
            AmbientVertexRemap $$54 = AmbientVertexRemap.fromFacing(p_111171_);
            if (!p_111173_.get(1) || !$$8.doNonCubicWeight) {
                float $$55 = ($$22 + $$13 + $$39 + $$53) * 0.25f;
                float $$56 = ($$19 + $$13 + $$34 + $$53) * 0.25f;
                float $$57 = ($$19 + $$16 + $$44 + $$53) * 0.25f;
                float $$58 = ($$22 + $$16 + $$49 + $$53) * 0.25f;
                this.lightmap[$$54.vert0] = this.blend($$21, $$12, $$40, $$51);
                this.lightmap[$$54.vert1] = this.blend($$18, $$12, $$35, $$51);
                this.lightmap[$$54.vert2] = this.blend($$18, $$15, $$45, $$51);
                this.lightmap[$$54.vert3] = this.blend($$21, $$15, $$50, $$51);
                this.brightness[$$54.vert0] = $$55;
                this.brightness[$$54.vert1] = $$56;
                this.brightness[$$54.vert2] = $$57;
                this.brightness[$$54.vert3] = $$58;
            } else {
                float $$59 = ($$22 + $$13 + $$39 + $$53) * 0.25f;
                float $$60 = ($$19 + $$13 + $$34 + $$53) * 0.25f;
                float $$61 = ($$19 + $$16 + $$44 + $$53) * 0.25f;
                float $$62 = ($$22 + $$16 + $$49 + $$53) * 0.25f;
                float $$63 = p_111172_[$$8.vert0Weights[0].shape] * p_111172_[$$8.vert0Weights[1].shape];
                float $$64 = p_111172_[$$8.vert0Weights[2].shape] * p_111172_[$$8.vert0Weights[3].shape];
                float $$65 = p_111172_[$$8.vert0Weights[4].shape] * p_111172_[$$8.vert0Weights[5].shape];
                float $$66 = p_111172_[$$8.vert0Weights[6].shape] * p_111172_[$$8.vert0Weights[7].shape];
                float $$67 = p_111172_[$$8.vert1Weights[0].shape] * p_111172_[$$8.vert1Weights[1].shape];
                float $$68 = p_111172_[$$8.vert1Weights[2].shape] * p_111172_[$$8.vert1Weights[3].shape];
                float $$69 = p_111172_[$$8.vert1Weights[4].shape] * p_111172_[$$8.vert1Weights[5].shape];
                float $$70 = p_111172_[$$8.vert1Weights[6].shape] * p_111172_[$$8.vert1Weights[7].shape];
                float $$71 = p_111172_[$$8.vert2Weights[0].shape] * p_111172_[$$8.vert2Weights[1].shape];
                float $$72 = p_111172_[$$8.vert2Weights[2].shape] * p_111172_[$$8.vert2Weights[3].shape];
                float $$73 = p_111172_[$$8.vert2Weights[4].shape] * p_111172_[$$8.vert2Weights[5].shape];
                float $$74 = p_111172_[$$8.vert2Weights[6].shape] * p_111172_[$$8.vert2Weights[7].shape];
                float $$75 = p_111172_[$$8.vert3Weights[0].shape] * p_111172_[$$8.vert3Weights[1].shape];
                float $$76 = p_111172_[$$8.vert3Weights[2].shape] * p_111172_[$$8.vert3Weights[3].shape];
                float $$77 = p_111172_[$$8.vert3Weights[4].shape] * p_111172_[$$8.vert3Weights[5].shape];
                float $$78 = p_111172_[$$8.vert3Weights[6].shape] * p_111172_[$$8.vert3Weights[7].shape];
                this.brightness[$$54.vert0] = $$59 * $$63 + $$60 * $$64 + $$61 * $$65 + $$62 * $$66;
                this.brightness[$$54.vert1] = $$59 * $$67 + $$60 * $$68 + $$61 * $$69 + $$62 * $$70;
                this.brightness[$$54.vert2] = $$59 * $$71 + $$60 * $$72 + $$61 * $$73 + $$62 * $$74;
                this.brightness[$$54.vert3] = $$59 * $$75 + $$60 * $$76 + $$61 * $$77 + $$62 * $$78;
                int $$79 = this.blend($$21, $$12, $$40, $$51);
                int $$80 = this.blend($$18, $$12, $$35, $$51);
                int $$81 = this.blend($$18, $$15, $$45, $$51);
                int $$82 = this.blend($$21, $$15, $$50, $$51);
                this.lightmap[$$54.vert0] = this.blend($$79, $$80, $$81, $$82, $$63, $$64, $$65, $$66);
                this.lightmap[$$54.vert1] = this.blend($$79, $$80, $$81, $$82, $$67, $$68, $$69, $$70);
                this.lightmap[$$54.vert2] = this.blend($$79, $$80, $$81, $$82, $$71, $$72, $$73, $$74);
                this.lightmap[$$54.vert3] = this.blend($$79, $$80, $$81, $$82, $$75, $$76, $$77, $$78);
            }
            float $$83 = p_111168_.getShade(p_111171_, p_111174_);
            int $$84 = 0;
            while ($$84 < this.brightness.length) {
                int n = $$84++;
                this.brightness[n] = this.brightness[n] * $$83;
            }
        }

        private int blend(int p_111154_, int p_111155_, int p_111156_, int p_111157_) {
            if (p_111154_ == 0) {
                p_111154_ = p_111157_;
            }
            if (p_111155_ == 0) {
                p_111155_ = p_111157_;
            }
            if (p_111156_ == 0) {
                p_111156_ = p_111157_;
            }
            return p_111154_ + p_111155_ + p_111156_ + p_111157_ >> 2 & 0xFF00FF;
        }

        private int blend(int p_111159_, int p_111160_, int p_111161_, int p_111162_, float p_111163_, float p_111164_, float p_111165_, float p_111166_) {
            int $$8 = (int)((float)(p_111159_ >> 16 & 0xFF) * p_111163_ + (float)(p_111160_ >> 16 & 0xFF) * p_111164_ + (float)(p_111161_ >> 16 & 0xFF) * p_111165_ + (float)(p_111162_ >> 16 & 0xFF) * p_111166_) & 0xFF;
            int $$9 = (int)((float)(p_111159_ & 0xFF) * p_111163_ + (float)(p_111160_ & 0xFF) * p_111164_ + (float)(p_111161_ & 0xFF) * p_111165_ + (float)(p_111162_ & 0xFF) * p_111166_) & 0xFF;
            return $$8 << 16 | $$9;
        }
    }

    static class Cache {
        private boolean enabled;
        private final Long2IntLinkedOpenHashMap colorCache = Util.make(() -> {
            Long2IntLinkedOpenHashMap $$0 = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111238_) {
                }
            };
            $$0.defaultReturnValue(Integer.MAX_VALUE);
            return $$0;
        });
        private final Long2FloatLinkedOpenHashMap brightnessCache = Util.make(() -> {
            Long2FloatLinkedOpenHashMap $$0 = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111245_) {
                }
            };
            $$0.defaultReturnValue(Float.NaN);
            return $$0;
        });

        private Cache() {
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
            this.colorCache.clear();
            this.brightnessCache.clear();
        }

        public int getLightColor(BlockState p_111222_, BlockAndTintGetter p_111223_, BlockPos p_111224_) {
            int $$4;
            long $$3 = p_111224_.asLong();
            if (this.enabled && ($$4 = this.colorCache.get($$3)) != Integer.MAX_VALUE) {
                return $$4;
            }
            int $$5 = LevelRenderer.getLightColor(p_111223_, p_111222_, p_111224_);
            if (this.enabled) {
                if (this.colorCache.size() == 100) {
                    this.colorCache.removeFirstInt();
                }
                this.colorCache.put($$3, $$5);
            }
            return $$5;
        }

        public float getShadeBrightness(BlockState p_111227_, BlockAndTintGetter p_111228_, BlockPos p_111229_) {
            float $$4;
            long $$3 = p_111229_.asLong();
            if (this.enabled && !Float.isNaN($$4 = this.brightnessCache.get($$3))) {
                return $$4;
            }
            float $$5 = p_111227_.getShadeBrightness(p_111228_, p_111229_);
            if (this.enabled) {
                if (this.brightnessCache.size() == 100) {
                    this.brightnessCache.removeFirstFloat();
                }
                this.brightnessCache.put($$3, $$5);
            }
            return $$5;
        }
    }

    protected static enum AdjacencyInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new SizeInfo[]{SizeInfo.EAST, SizeInfo.SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.EAST, SizeInfo.NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.UP, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.DOWN, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.DOWN, SizeInfo.EAST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.UP, SizeInfo.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.UP, SizeInfo.NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.SOUTH});

        final Direction[] corners;
        final boolean doNonCubicWeight;
        final SizeInfo[] vert0Weights;
        final SizeInfo[] vert1Weights;
        final SizeInfo[] vert2Weights;
        final SizeInfo[] vert3Weights;
        private static final AdjacencyInfo[] BY_FACING;

        private AdjacencyInfo(Direction[] p_111122_, float p_111123_, boolean p_111124_, SizeInfo[] p_111125_, SizeInfo[] p_111126_, SizeInfo[] p_111127_, SizeInfo[] p_111128_) {
            this.corners = p_111122_;
            this.doNonCubicWeight = p_111124_;
            this.vert0Weights = p_111125_;
            this.vert1Weights = p_111126_;
            this.vert2Weights = p_111127_;
            this.vert3Weights = p_111128_;
        }

        public static AdjacencyInfo fromFacing(Direction p_111132_) {
            return BY_FACING[p_111132_.get3DDataValue()];
        }

        static {
            BY_FACING = Util.make(new AdjacencyInfo[6], p_111134_ -> {
                p_111134_[Direction.DOWN.get3DDataValue()] = DOWN;
                p_111134_[Direction.UP.get3DDataValue()] = UP;
                p_111134_[Direction.NORTH.get3DDataValue()] = NORTH;
                p_111134_[Direction.SOUTH.get3DDataValue()] = SOUTH;
                p_111134_[Direction.WEST.get3DDataValue()] = WEST;
                p_111134_[Direction.EAST.get3DDataValue()] = EAST;
            });
        }
    }

    protected static enum SizeInfo {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        final int shape;

        private SizeInfo(Direction p_111264_, boolean p_111265_) {
            this.shape = p_111264_.get3DDataValue() + (p_111265_ ? DIRECTIONS.length : 0);
        }
    }

    static enum AmbientVertexRemap {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        final int vert0;
        final int vert1;
        final int vert2;
        final int vert3;
        private static final AmbientVertexRemap[] BY_FACING;

        private AmbientVertexRemap(int p_111195_, int p_111196_, int p_111197_, int p_111198_) {
            this.vert0 = p_111195_;
            this.vert1 = p_111196_;
            this.vert2 = p_111197_;
            this.vert3 = p_111198_;
        }

        public static AmbientVertexRemap fromFacing(Direction p_111202_) {
            return BY_FACING[p_111202_.get3DDataValue()];
        }

        static {
            BY_FACING = Util.make(new AmbientVertexRemap[6], p_111204_ -> {
                p_111204_[Direction.DOWN.get3DDataValue()] = DOWN;
                p_111204_[Direction.UP.get3DDataValue()] = UP;
                p_111204_[Direction.NORTH.get3DDataValue()] = NORTH;
                p_111204_[Direction.SOUTH.get3DDataValue()] = SOUTH;
                p_111204_[Direction.WEST.get3DDataValue()] = WEST;
                p_111204_[Direction.EAST.get3DDataValue()] = EAST;
            });
        }
    }
}

