/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignedMessageValidator;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;

public class PlayerInfo {
    private final GameProfile profile;
    private final java.util.function.Supplier<PlayerSkin> skinLookup;
    private GameType gameMode = GameType.DEFAULT_MODE;
    private int latency;
    @Nullable
    private Component tabListDisplayName;
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageValidator messageValidator;

    public PlayerInfo(GameProfile p_253609_, boolean p_254409_) {
        this.profile = p_253609_;
        this.messageValidator = PlayerInfo.fallbackMessageValidator(p_254409_);
        Supplier $$2 = Suppliers.memoize(() -> PlayerInfo.createSkinLookup(p_253609_));
        this.skinLookup = () -> PlayerInfo.lambda$new$1((java.util.function.Supplier)$$2);
    }

    private static java.util.function.Supplier<PlayerSkin> createSkinLookup(GameProfile p_295736_) {
        Minecraft $$1 = Minecraft.getInstance();
        SkinManager $$2 = $$1.getSkinManager();
        CompletableFuture<PlayerSkin> $$3 = $$2.getOrLoad(p_295736_);
        boolean $$4 = !$$1.isLocalPlayer(p_295736_.getId());
        PlayerSkin $$5 = DefaultPlayerSkin.get(p_295736_);
        return () -> {
            PlayerSkin $$3 = $$3.getNow($$5);
            if ($$4 && !$$3.secure()) {
                return $$5;
            }
            return $$3;
        };
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        return this.chatSession;
    }

    public SignedMessageValidator getMessageValidator() {
        return this.messageValidator;
    }

    public boolean hasVerifiableChat() {
        return this.chatSession != null;
    }

    protected void setChatSession(RemoteChatSession p_249599_) {
        this.chatSession = p_249599_;
        this.messageValidator = p_249599_.createMessageValidator(ProfilePublicKey.EXPIRY_GRACE_PERIOD);
    }

    protected void clearChatSession(boolean p_254536_) {
        this.chatSession = null;
        this.messageValidator = PlayerInfo.fallbackMessageValidator(p_254536_);
    }

    private static SignedMessageValidator fallbackMessageValidator(boolean p_254311_) {
        return p_254311_ ? SignedMessageValidator.REJECT_ALL : SignedMessageValidator.ACCEPT_UNSIGNED;
    }

    public GameType getGameMode() {
        return this.gameMode;
    }

    protected void setGameMode(GameType p_105318_) {
        this.gameMode = p_105318_;
    }

    public int getLatency() {
        return this.latency;
    }

    protected void setLatency(int p_105314_) {
        this.latency = p_105314_;
    }

    public PlayerSkin getSkin() {
        return this.skinLookup.get();
    }

    @Nullable
    public PlayerTeam getTeam() {
        return Minecraft.getInstance().level.getScoreboard().getPlayersTeam(this.getProfile().getName());
    }

    public void setTabListDisplayName(@Nullable Component p_105324_) {
        this.tabListDisplayName = p_105324_;
    }

    @Nullable
    public Component getTabListDisplayName() {
        return this.tabListDisplayName;
    }

    private static /* synthetic */ PlayerSkin lambda$new$1(java.util.function.Supplier p_293620_) {
        return (PlayerSkin)((java.util.function.Supplier)p_293620_.get()).get();
    }
}

