/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class TFMGTags {
    public static void init() {
        TFMGBlockTags.init();
        TFMGFluidTags.init();
    }

    public static enum TFMGBlockTags {
        BLAST_FURNACE_WALL,
        REINFORCED_BLAST_FURNACE_WALL,
        BLAST_FURNACE_SUPPORT,
        INDUSTRIAL_PIPE,
        REINFORCED_BLAST_FURNACE_SUPPORT,
        SURFACE_SCANNER_FINDABLE,
        PUMPJACK_PART,
        PUMPJACK_HEAD,
        PUMPJACK_CONNECTOR,
        PUMPJACK_SMALL_PART;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private TFMGBlockTags() {
            this(NameSpace.MOD);
        }

        private TFMGBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private TFMGBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? CreateLang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).getBlock());
        }

        public boolean matches(BlockState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum TFMGFluidTags {
        GAS(NameSpace.MOD),
        FLAMMABLE(NameSpace.MOD),
        FIREBOX_FUEL(NameSpace.MOD),
        BLAST_STOVE_FUEL(NameSpace.MOD),
        AIR(NameSpace.COMMON),
        COOLING_FLUID(NameSpace.COMMON),
        GASOLINE(NameSpace.COMMON),
        DIESEL(NameSpace.COMMON),
        KEROSENE(NameSpace.COMMON),
        CREOSOTE(NameSpace.COMMON),
        FURNACE_GAS(NameSpace.COMMON),
        LPG(NameSpace.COMMON),
        HEAVY_OIL(NameSpace.COMMON),
        LUBRICATION_OIL(NameSpace.COMMON),
        NAPHTHA(NameSpace.COMMON),
        CRUDE_OIL(NameSpace.COMMON),
        MOLTEN_STEEL(NameSpace.COMMON),
        FUEL(NameSpace.COMMON);

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private TFMGFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private TFMGFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? CreateLang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag((Registry)BuiltInRegistries.FLUID, (ResourceLocation)id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum TFMGItemTags {
        FLUX,
        SPOOLS,
        BLAST_FURNACE_FUEL,
        RODS,
        IRON_PLATES(NameSpace.COMMON, "plates/iron"),
        ALUMINUM_PLATES(NameSpace.COMMON, "plates/aluminum");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private TFMGItemTags() {
            this(NameSpace.MOD);
        }

        private TFMGItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private TFMGItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? CreateLang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag((Registry)BuiltInRegistries.ITEM, (ResourceLocation)id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("tfmg", false, true),
        COMMON("c");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

