/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public enum TFMGKeys {
    TRANSMISSION_SHIFT_UP("transmission_shift_up", 86, "Increases transmission shift"),
    TRANSMISSION_SHIFT_DOWN("transmission_shift_down", 67, "Decreases transmission shift"),
    ENGINE_CONTROLLER_CUSTOM_BUTTON("custom_button", 66, "Button for custom engine controls feature"),
    ENGINE_START("engine_start", 73, "Starts and stops the engine");

    private KeyMapping keybind;
    private final String description;
    private final String translation;
    private final int key;
    private final boolean modifiable;

    private TFMGKeys(String description, int defaultKey, String translation) {
        this.description = "tfmg.keyinfo." + description;
        this.key = defaultKey;
        this.modifiable = !description.isEmpty();
        this.translation = translation;
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (TFMGKeys key : TFMGKeys.values()) {
            if (!key.modifiable) continue;
            consumer.accept(key.description, key.translation);
        }
    }

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (TFMGKeys key : TFMGKeys.values()) {
            key.keybind = new KeyMapping(key.description, key.key, "Create: The Factory Must Grow");
            if (!key.modifiable) continue;
            event.register(key.keybind);
        }
    }

    public KeyMapping getKeybind() {
        return this.keybind;
    }

    public boolean isPressed() {
        if (!this.modifiable) {
            return TFMGKeys.isKeyDown(this.key);
        }
        return this.keybind.isDown();
    }

    public String getBoundKey() {
        return this.keybind.getTranslatedKeyMessage().getString().toUpperCase();
    }

    public int getBoundCode() {
        return this.keybind.getKey().getValue();
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key);
    }

    public static boolean isMouseButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)button) == 1;
    }

    public static boolean ctrlDown() {
        return Screen.hasControlDown();
    }

    public static boolean shiftDown() {
        return Screen.hasShiftDown();
    }

    public static boolean altDown() {
        return Screen.hasAltDown();
    }
}

