/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.winding_machine;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.TFMGRegistries;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableType;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.WindingMachineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SpoolItem
extends Item {
    public final int barColor;
    public final ResourceLocation cableTypeKey;

    public SpoolItem(Item.Properties properties, int barColor, ResourceLocation cableTypeKey) {
        super(properties);
        this.barColor = barColor;
        this.cableTypeKey = cableTypeKey;
    }

    public void onCraftedBy(ItemStack stack, Level p_41448_, Player p_41449_) {
        stack.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)1000);
        super.onCraftedBy(stack, p_41448_, p_41449_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && (Long)stack.get(TFMGDataComponents.POSITION) != 0L) {
            BlockEntity blockEntity = level.getBlockEntity(BlockPos.of((long)((Long)stack.get(TFMGDataComponents.POSITION))));
            if (blockEntity instanceof CableConnectorBlockEntity) {
                CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity;
                be.player = null;
            }
            stack.set(TFMGDataComponents.POSITION, (Object)0L);
            stack.remove(TFMGDataComponents.POSITION);
            stack.remove(TFMGDataComponents.X_POS);
            stack.remove(TFMGDataComponents.Y_POS);
            stack.remove(TFMGDataComponents.Z_POS);
            if (level.isClientSide) {
                player.displayClientMessage((Component)CreateLang.translateDirect((String)"wires.removed_data", (Object[])new Object[0]).withStyle(ChatFormatting.YELLOW), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)CreateLang.translateDirect((String)"tooltip.coils", (Object[])new Object[]{stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null ? Integer.valueOf(0) : stack.get(TFMGDataComponents.SPOOL_AMOUNT)}).withStyle(ChatFormatting.GREEN));
        if (stack.get(TFMGDataComponents.POSITION) == null) {
            return;
        }
        BlockPos pos = BlockPos.of((long)((Long)stack.get(TFMGDataComponents.POSITION)));
        if (pos.asLong() != 0L) {
            tooltip.add((Component)CreateLang.text((String)(pos.getX() + " " + pos.getY() + " " + pos.getZ())).component().withStyle(ChatFormatting.AQUA));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity posToConnect;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (Objects.equals(this.cableTypeKey, TFMG.asResource("empty"))) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CableConnectorBlockEntity) {
            CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity;
            if (stack.get(TFMGDataComponents.POSITION) != null) {
                posToConnect = BlockPos.of((long)((Long)stack.get(TFMGDataComponents.POSITION)));
                if (posToConnect.equals((Object)pos)) {
                    stack.set(TFMGDataComponents.POSITION, (Object)0L);
                    if (level.isClientSide) {
                        player.displayClientMessage((Component)CreateLang.translateDirect((String)"wires.cant_connect_itself", (Object[])new Object[0]).withStyle(ChatFormatting.YELLOW), true);
                    }
                    be.player = null;
                    be.sendData();
                    be.setChanged();
                    return InteractionResult.SUCCESS;
                }
                BlockEntity blockEntity2 = level.getBlockEntity((BlockPos)posToConnect);
                if (blockEntity2 instanceof CableConnectorBlockEntity) {
                    CableConnectorBlockEntity otherBE = (CableConnectorBlockEntity)blockEntity2;
                    CableType cableType = TFMGUtils.getCableType(this.cableTypeKey);
                    CableConnection connection1 = new CableConnection(be.getCablePosition(), otherBE.getCablePosition(), otherBE.getBlockPos(), cableType, true);
                    CableConnection connection2 = new CableConnection(otherBE.getCablePosition(), be.getCablePosition(), be.getBlockPos(), cableType, false);
                    float wireCost = connection1.getLength() / 8.0f;
                    if ((float)((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue() < wireCost * 125.0f) {
                        return InteractionResult.PASS;
                    }
                    if (be.connections.contains(connection1) || otherBE.connections.contains(connection1)) {
                        if (level.isClientSide) {
                            player.displayClientMessage((Component)CreateLang.translateDirect((String)"wires.connection_already_created", (Object[])new Object[0]).withStyle(ChatFormatting.YELLOW), true);
                        }
                        be.player = null;
                        be.sendData();
                        be.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                    be.connections.add(connection1);
                    otherBE.connections.add(connection2);
                    be.onPlaced();
                    stack.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)((int)((float)((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue() - wireCost * 125.0f)));
                    be.player = null;
                    otherBE.player = null;
                    be.setChanged();
                    otherBE.setChanged();
                    be.sendData();
                    otherBE.sendData();
                    stack.remove(TFMGDataComponents.POSITION);
                    stack.remove(TFMGDataComponents.X_POS);
                    stack.remove(TFMGDataComponents.Y_POS);
                    stack.remove(TFMGDataComponents.Z_POS);
                }
                be.player = null;
                return InteractionResult.SUCCESS;
            }
            stack.set(TFMGDataComponents.POSITION, (Object)be.getBlockPos().asLong());
            stack.set(TFMGDataComponents.X_POS, (Object)((int)be.getCablePosition().x()));
            stack.set(TFMGDataComponents.Y_POS, (Object)((int)be.getCablePosition().y()));
            stack.set(TFMGDataComponents.Z_POS, (Object)((int)be.getCablePosition().z()));
            be.player = player;
            be.color = this.barColor;
            be.sendData();
            be.setChanged();
            return InteractionResult.SUCCESS;
        }
        posToConnect = level.getBlockEntity(pos);
        if (posToConnect instanceof WindingMachineBlockEntity) {
            WindingMachineBlockEntity be = (WindingMachineBlockEntity)posToConnect;
            ItemStack oldSpool = ItemStack.EMPTY;
            if (!be.spool.isEmpty()) {
                oldSpool = be.spool;
            }
            be.spool = context.getItemInHand();
            context.getPlayer().setItemInHand(context.getHand(), oldSpool);
            be.sendData();
            be.setChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void removeOtherConnections(Player player, ItemStack stack) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemStack = player.getInventory().getItem(i);
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean p_41408_) {
        super.inventoryTick(stack, level, entity, slot, p_41408_);
        if (stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null) {
            return;
        }
        if ((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT) == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            if (!stack.is((Item)TFMGItems.EMPTY_SPOOL.get())) {
                player.getInventory().setItem(slot, TFMGItems.EMPTY_SPOOL.asStack());
            }
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return !Objects.equals(this.cableTypeKey, TFMG.asResource("empty")) && TFMGRegistries.CABLE_TYPE_REGISTRY.containsKey(this.cableTypeKey);
    }

    public int getBarColor(ItemStack stack) {
        return this.barColor;
    }

    public int getBarWidth(ItemStack stack) {
        if (stack.get(TFMGDataComponents.SPOOL_AMOUNT) == null) {
            return 13;
        }
        return (int)(13.0f * ((float)((Integer)stack.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue() / 1000.0f));
    }
}

