/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades;

import com.drmangotea.tfmg.base.spark.BlueSpark;
import com.drmangotea.tfmg.base.spark.FireSpark;
import com.drmangotea.tfmg.base.spark.GreenSpark;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.Create;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThermiteGrenade
extends ThrowableItemProjectile {
    public final ChemicalColor flameColor;

    public ThermiteGrenade(EntityType<? extends ThermiteGrenade> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
        this.flameColor = ChemicalColor.BLUE;
    }

    public ThermiteGrenade(Level p_37399_, LivingEntity p_37400_, ChemicalColor color, EntityType grenade) {
        super(grenade, p_37400_, p_37399_);
        this.flameColor = color;
    }

    public ThermiteGrenade(Level p_37394_, double p_37395_, double p_37396_, double p_37397_) {
        super((EntityType)TFMGEntityTypes.THERMITE_GRENADE.get(), p_37395_, p_37396_, p_37397_, p_37394_);
        this.flameColor = ChemicalColor.BLUE;
    }

    protected Item getDefaultItem() {
        return (Item)TFMGItems.THERMITE_GRENADE.get();
    }

    private ParticleOptions getParticle() {
        return ParticleTypes.FLAME;
    }

    public void handleEntityEvent(byte p_37402_) {
        if (p_37402_ == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult p_37404_) {
        super.onHitEntity(p_37404_);
        Entity entity = p_37404_.getEntity();
    }

    protected void onHit(HitResult p_37406_) {
        super.onHit(p_37406_);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            for (int i = 0; i < 20; ++i) {
                FireSpark spark;
                float x = Create.RANDOM.nextFloat(360.0f);
                float y = Create.RANDOM.nextFloat(360.0f);
                float z = Create.RANDOM.nextFloat(360.0f);
                if (this.flameColor == ChemicalColor.GREEN) {
                    spark = (GreenSpark)TFMGEntityTypes.GREEN_SPARK.create(this.level());
                    spark.moveTo(this.getX(), this.getY() + 1.0, this.getZ());
                    spark.shootFromRotation((Entity)this, x, y, z, 0.2f, 1.0f);
                    this.level().addFreshEntity((Entity)spark);
                    continue;
                }
                if (this.flameColor == ChemicalColor.BLUE) {
                    spark = (BlueSpark)TFMGEntityTypes.BLUE_SPARK.create(this.level());
                    spark.moveTo(this.getX(), this.getY() + 1.0, this.getZ());
                    spark.shootFromRotation((Entity)this, x, y, z, 0.2f, 1.0f);
                    this.level().addFreshEntity((Entity)spark);
                    continue;
                }
                spark = (FireSpark)TFMGEntityTypes.SPARK.create(this.level());
                spark.moveTo(this.getX(), this.getY() + 1.0, this.getZ());
                spark.shootFromRotation((Entity)this, x, y, z, 0.2f, 1.0f);
                this.level().addFreshEntity((Entity)spark);
            }
            this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
            this.discard();
        }
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.sized(0.25f, 0.25f);
    }

    public static enum ChemicalColor {
        BASE,
        GREEN,
        BLUE;

    }
}

