/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.advanced_potato_cannon;

import com.drmangotea.tfmg.TFMGClient;
import com.drmangotea.tfmg.content.items.weapons.advanced_potato_cannon.AdvancedPotatoCannonItemRenderer;
import com.drmangotea.tfmg.content.items.weapons.advanced_potato_cannon.projectile.NapalmPotato;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class AdvancedPotatoCannonItem
extends ProjectileWeaponItem
implements CustomArmPoseItem {
    public static ItemStack CLIENT_CURRENT_AMMO = ItemStack.EMPTY;
    public static final int MAX_DAMAGE = 500;

    public AdvancedPotatoCannonItem(Item.Properties properties) {
        super(properties.durability(500));
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.maxUses());
    }

    private int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxPotatoCannonShots.get() * 5;
    }

    public boolean isCannon(ItemStack stack) {
        return stack.getItem() instanceof AdvancedPotatoCannonItem;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return this.findAmmoInInventory(world, player, stack).map(itemStack -> {
            if (ShootableGadgetItemMethods.shouldSwap((Player)player, (ItemStack)stack, (InteractionHand)hand, this::isCannon)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            if (world.isClientSide) {
                TFMGClient.ADVANCED_POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
                return InteractionResultHolder.success((Object)stack);
            }
            Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)new Vec3(0.75, (double)-0.15f, 1.5));
            Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)new Vec3((double)-0.05f, 0.0, 0.0)).subtract(player.position().add(0.0, (double)player.getEyeHeight(), 0.0));
            Vec3 lookVec = player.getLookAngle();
            Vec3 motion = lookVec.add(correction).normalize().scale(2.0);
            float soundPitch = 1.0f + (Create.RANDOM.nextFloat() - 0.5f) / 4.0f;
            NapalmPotato projectile = (NapalmPotato)TFMGEntityTypes.NAPALM_POTATO.create(world);
            projectile.setPos(barrelPos.x, barrelPos.y, barrelPos.z);
            projectile.setDeltaMovement(motion);
            projectile.setOwner((Entity)player);
            world.addFreshEntity((Entity)projectile);
            if (!player.isCreative()) {
                itemStack.shrink(1);
                if (itemStack.isEmpty()) {
                    player.getInventory().removeItem(itemStack);
                }
            }
            if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, (int)this.maxUses())) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            Integer cooldown = 75;
            AllSoundEvents.FWOOMP.play(world, player, player.getX(), player.getY(), player.getZ(), 1.0f, 0.2f);
            ShootableGadgetItemMethods.applyCooldown((Player)player, (ItemStack)stack, (InteractionHand)hand, this::isCannon, (int)cooldown);
            return InteractionResultHolder.success((Object)stack);
        }).orElse(InteractionResultHolder.pass((Object)stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    private Optional<ItemStack> findAmmoInInventory(Level world, Player player, ItemStack held) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!stack.is((Item)TFMGItems.NAPALM_POTATO.get())) continue;
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return Optional.of(((Item)TFMGItems.NAPALM_POTATO.get()).getDefaultInstance());
        }
        return Optional.empty();
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.is((Item)TFMGItems.NAPALM_POTATO.get());
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    protected void shootProjectile(LivingEntity livingEntity, Projectile projectile, int i, float v, float v1, float v2, @Nullable LivingEntity livingEntity1) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new AdvancedPotatoCannonItemRenderer()));
    }
}

