/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.transformer;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.IVoltageChanger;
import com.drmangotea.tfmg.content.electricity.utilities.transformer.TransformerBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TransformerBlock
extends TFMGHorizontalDirectionalBlock
implements IBE<TransformerBlockEntity>,
IVoltageChanger {
    public TransformerBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return TFMGShapes.TRANSFORMER.get((Direction)p_60555_.getValue((Property)FACING));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack inHand = player.getItemInHand(hand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TransformerBlockEntity) {
            TransformerBlockEntity be = (TransformerBlockEntity)blockEntity;
            if (inHand.is((Item)TFMGItems.ELECTROMAGNETIC_COIL.get())) {
                if (be.primaryCoil.isEmpty()) {
                    be.primaryCoil = inHand;
                    player.setItemInHand(hand, ItemStack.EMPTY);
                    this.withBlockEntityDo((BlockGetter)level, pos, TransformerBlockEntity::updateCoils);
                    return ItemInteractionResult.SUCCESS;
                }
                if (be.secondaryCoil.isEmpty()) {
                    be.secondaryCoil = inHand;
                    player.setItemInHand(hand, ItemStack.EMPTY);
                    this.withBlockEntityDo((BlockGetter)level, pos, TransformerBlockEntity::updateCoils);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (inHand.isEmpty()) {
                if (!be.primaryCoil.isEmpty()) {
                    player.setItemInHand(hand, be.primaryCoil);
                    be.primaryCoil = ItemStack.EMPTY;
                    this.withBlockEntityDo((BlockGetter)level, pos, TransformerBlockEntity::updateCoils);
                    return ItemInteractionResult.SUCCESS;
                }
                if (!be.secondaryCoil.isEmpty()) {
                    player.setItemInHand(hand, be.secondaryCoil);
                    be.secondaryCoil = ItemStack.EMPTY;
                    this.withBlockEntityDo((BlockGetter)level, pos, TransformerBlockEntity::updateCoils);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void onPlace(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<TransformerBlockEntity> getBlockEntityClass() {
        return TransformerBlockEntity.class;
    }

    public BlockEntityType<? extends TransformerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.TRANSFORMER.get();
    }
}

