/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.storage;

import com.drmangotea.tfmg.base.blocks.TFMGDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.storage.AccumulatorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.simibubi.create.foundation.block.IBE;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;

public class AccumulatorBlock
extends TFMGDirectionalBlock
implements IBE<AccumulatorBlockEntity> {
    public AccumulatorBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCapacity(stack));
    }

    public List<ItemStack> getDrops(BlockState p_287732_, LootParams.Builder p_287596_) {
        return Collections.emptyList();
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        if (!player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            ItemStack item = TFMGBlocks.ACCUMULATOR.asItem().getDefaultInstance();
            item.set(TFMGDataComponents.ACCUMULATOR_STORAGE, (Object)be.energy.getEnergyStored());
            ItemEntity itemToSpawn = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), item);
            if (itemToSpawn.getItem().getCount() > 0) {
                level.addFreshEntity((Entity)itemToSpawn);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.withBlockEntityDo((BlockGetter)level, pos, AccumulatorBlockEntity::refreshMultiblock);
        super.onNeighborChange(state, level, pos, neighbor);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState blockState1, boolean a) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
        this.withBlockEntityDo((BlockGetter)level, pos, b -> {
            b.refreshNextTick = true;
        });
        super.onPlace(state, level, pos, blockState1, a);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            if (!level.getBlockState(pos).is((Block)TFMGBlocks.ACCUMULATOR.get())) continue;
            this.withBlockEntityDo((BlockGetter)level, neighborPos, AccumulatorBlockEntity::refreshMultiblock);
        }
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<AccumulatorBlockEntity> getBlockEntityClass() {
        return AccumulatorBlockEntity.class;
    }

    public BlockEntityType<? extends AccumulatorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.ACCUMULATOR.get();
    }
}

